/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctMatrix;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;

public class OctInterval {
    private final OctValue mMin;
    private final OctValue mMax;

    public OctInterval(IntervalDomainValue intervalDomainValue) {
        if (intervalDomainValue.isBottom()) {
            this.mMin = OctValue.ONE;
            this.mMax = OctValue.ZERO;
        } else {
            this.mMin = new OctValue(intervalDomainValue.getLower());
            this.mMax = new OctValue(intervalDomainValue.getUpper());
        }
    }

    public OctInterval(OctValue octValue, OctValue octValue2) {
        this.mMin = octValue;
        this.mMax = octValue2;
    }

    public static OctInterval fromMatrix(OctMatrix octMatrix, int n) {
        int n2 = n * 2;
        int n3 = n2 + 1;
        return new OctInterval(octMatrix.get(n2, n3).half().negateIfNotInfinity(), octMatrix.get(n3, n2).half());
    }

    public static OctInterval fromMatrix(OctMatrix octMatrix, int n, int n2) {
        return new OctInterval(octMatrix.get(n, n2).negateIfNotInfinity(), octMatrix.get(n2, n));
    }

    public OctInterval() {
        this.mMin = this.mMax = OctValue.INFINITY;
    }

    public IntervalDomainValue toIvlInterval() {
        if (this.isBottom()) {
            return new IntervalDomainValue(true);
        }
        return new IntervalDomainValue(this.mMin.toIvlValue(), this.mMax.toIvlValue());
    }

    public OctValue getMin() {
        return this.mMin;
    }

    public OctValue getMax() {
        return this.mMax;
    }

    public boolean isBottom() {
        if (this.mMin.isInfinity()) {
            return false;
        }
        return this.mMin.compareTo(this.mMax) > 0;
    }

    public boolean isTop() {
        return this.mMin.isInfinity() && this.mMax.isInfinity();
    }

    public IAbstractPostOperator.EvalResult evaluate(RelationSymbol relationSymbol, Rational rational) {
        if (this.isBottom()) {
            return IAbstractPostOperator.EvalResult.TRUE;
        }
        Rational rational2 = this.mMin.isInfinity() ? Rational.NEGATIVE_INFINITY : this.mMin.toRational();
        Rational rational3 = this.mMax.toRational();
        switch (relationSymbol) {
            case DISTINCT: {
                return IAbstractPostOperator.EvalResult.selectTF((rational2.compareTo(rational) > 0 || rational3.compareTo(rational) < 0 ? 1 : 0) != 0, (rational2.compareTo(rational) == 0 && rational3.compareTo(rational) == 0 ? 1 : 0) != 0);
            }
            case EQ: {
                return IAbstractPostOperator.EvalResult.selectTF((rational2.compareTo(rational) == 0 && rational3.compareTo(rational) == 0 ? 1 : 0) != 0, (rational2.compareTo(rational) > 0 || rational3.compareTo(rational) < 0 ? 1 : 0) != 0);
            }
            case GEQ: {
                return IAbstractPostOperator.EvalResult.selectTF((rational2.compareTo(rational) >= 0 ? 1 : 0) != 0, (rational3.compareTo(rational) < 0 ? 1 : 0) != 0);
            }
            case GREATER: {
                return IAbstractPostOperator.EvalResult.selectTF((rational2.compareTo(rational) > 0 ? 1 : 0) != 0, (rational3.compareTo(rational) <= 0 ? 1 : 0) != 0);
            }
            case LEQ: {
                return IAbstractPostOperator.EvalResult.selectTF((rational3.compareTo(rational) <= 0 ? 1 : 0) != 0, (rational2.compareTo(rational) > 0 ? 1 : 0) != 0);
            }
            case LESS: {
                return IAbstractPostOperator.EvalResult.selectTF((rational3.compareTo(rational) < 0 ? 1 : 0) != 0, (rational2.compareTo(rational) >= 0 ? 1 : 0) != 0);
            }
        }
        return IAbstractPostOperator.EvalResult.UNKNOWN;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (this.mMin.isInfinity()) {
            stringBuilder.append('-');
        }
        stringBuilder.append(this.mMin).append("; ").append(this.mMax).append(']');
        return stringBuilder.toString();
    }
}

