/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.ModelContainer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.DataAccessException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.GraphNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.PersistentObjectNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.PersistentObjectTypeMismatchException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.StoreObjectException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelrepository.IRepository;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelrepository.SerializationRepository;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PersistenceAwareModelManager
implements IModelManager {
    private final LinkedHashMap<ModelType, ModelContainer> mModelMap;
    private final IRepository<String, ModelContainer> mRepository;
    private final ILogger mLogger;
    private ModelType mLastAdded;

    public PersistenceAwareModelManager(File file, ILogger iLogger) {
        assert (iLogger != null);
        this.mModelMap = new LinkedHashMap();
        this.mLogger = iLogger;
        this.mLogger.info((Object)("Repository-Root is: " + file.getAbsolutePath()));
        this.mRepository = new SerializationRepository(file, this.mLogger);
    }

    public PersistenceAwareModelManager(String string, ILogger iLogger) {
        this(new File(string), iLogger);
    }

    private static String createFileNameFromNode(IElement iElement) {
        if (iElement == null) {
            return "";
        }
        String string = "";
        ILocation iLocation = ILocation.getAnnotation((IElement)iElement);
        if (iLocation != null && iLocation.getFileName() != null) {
            string = iLocation.getFileName();
        }
        if (string.contains(", ")) {
            String[] stringArray = string.split(", ");
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                stringBuilder.append(string2.substring(string2.lastIndexOf(File.separator) + 1)).append(", ");
                ++n2;
            }
            string = stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length()).toString();
        } else {
            string = string.trim();
            string = string.substring(string.lastIndexOf(File.separator) + 1);
        }
        return string;
    }

    private boolean addItem(ModelContainer modelContainer) {
        ModelType modelType = modelContainer.getType();
        if (this.mModelMap.containsKey(modelType)) {
            this.mLogger.warn((Object)"Model is already present, skipping insertion....");
            return false;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Inserting " + String.valueOf(modelContainer)));
        }
        this.mModelMap.put(modelType, modelContainer);
        this.mLastAdded = modelType;
        return true;
    }

    @Override
    public boolean addItem(IElement iElement, ModelType modelType) {
        return this.addItem(new ModelContainer(iElement, modelType, PersistenceAwareModelManager.createFileNameFromNode(iElement)));
    }

    @Override
    public List<String> getItemNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ModelType modelType : this.mModelMap.keySet()) {
            arrayList.add(modelType.toString());
        }
        arrayList.addAll(this.mRepository.listKeys());
        return arrayList;
    }

    @Override
    public ModelType getLastAdded() {
        return this.mLastAdded;
    }

    @Override
    public IElement getRootNode(ModelType modelType) throws GraphNotFoundException {
        ModelContainer modelContainer = this.mModelMap.get(modelType);
        if (modelContainer == null) {
            try {
                modelContainer = this.mRepository.get(modelType.toString());
                this.mModelMap.put(modelType, modelContainer);
            }
            catch (PersistentObjectNotFoundException persistentObjectNotFoundException) {
                throw new GraphNotFoundException(modelType, persistentObjectNotFoundException);
            }
            catch (PersistentObjectTypeMismatchException persistentObjectTypeMismatchException) {
                this.mLogger.error((Object)("Could not deserialize graph " + String.valueOf(modelType)), (Throwable)persistentObjectTypeMismatchException);
                throw new GraphNotFoundException(modelType, persistentObjectTypeMismatchException);
            }
        }
        return modelContainer.getRoot();
    }

    @Override
    public boolean isEmpty() {
        return this.mModelMap.isEmpty() && this.mRepository.isEmpty();
    }

    @Override
    public void persistAll(boolean bl) throws StoreObjectException {
        for (Map.Entry<ModelType, ModelContainer> entry : this.mModelMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.mRepository.addOrReplace(entry.getKey().toString(), entry.getValue());
        }
        if (!bl) {
            this.removeAll();
        }
    }

    @Override
    public void persistAndDropExistingGraph(ModelType modelType) throws StoreObjectException, GraphNotFoundException {
        this.persistExistingGraph(modelType, false);
    }

    @Override
    public void persistExistingGraph(ModelType modelType, boolean bl) throws StoreObjectException, GraphNotFoundException {
        if (this.mModelMap.containsKey(modelType)) {
            this.mRepository.addOrReplace(modelType.toString(), this.mModelMap.get(modelType));
            if (!bl) {
                this.mModelMap.remove(modelType);
            }
        } else {
            throw new GraphNotFoundException(modelType);
        }
    }

    @Override
    public void removeAll() {
        this.mModelMap.clear();
    }

    @Override
    public boolean removeItem(ModelType modelType) {
        boolean bl = true;
        if (this.mModelMap.containsKey(modelType)) {
            boolean bl2 = bl = this.mModelMap.remove(modelType) != null;
        }
        return bl && this.mRepository.remove(modelType.toString());
    }

    @Override
    public boolean removeItem(String string) {
        boolean bl = true;
        ModelType modelType = this.getInMemoryGraphTypeById(string);
        if (modelType != null) {
            boolean bl2 = bl = this.mModelMap.remove(modelType) != null;
        }
        return bl && this.mRepository.remove(string);
    }

    @Override
    public boolean removeItem(ModelContainer modelContainer) {
        return this.mModelMap.remove(modelContainer.getType()) != null;
    }

    @Override
    public ModelType getGraphTypeById(String string) {
        for (ModelType modelType : this.mModelMap.keySet()) {
            if (!modelType.toString().equals(string)) continue;
            return modelType;
        }
        if (this.mRepository.listKeys().contains(string)) {
            try {
                return this.mRepository.get(string).getType();
            }
            catch (DataAccessException dataAccessException) {
                this.mLogger.error((Object)"Problems deserializing persistent model: ", (Throwable)dataAccessException);
            }
        }
        return null;
    }

    private ModelType getInMemoryGraphTypeById(String string) {
        for (ModelType modelType : this.mModelMap.keySet()) {
            if (!modelType.toString().equals(string)) continue;
            return modelType;
        }
        return null;
    }

    @Override
    public ModelType getGraphTypeByGeneratorPluginId(String string) {
        Optional<Map.Entry> optional = this.mModelMap.entrySet().stream().filter(entry -> ((ModelType)entry.getKey()).getCreator().equals(string)).findFirst();
        if (optional.isPresent()) {
            return (ModelType)optional.get().getKey();
        }
        for (String string2 : this.mRepository.listKeys()) {
            if (!string2.contains(string)) continue;
            try {
                ModelType modelType = this.mRepository.get(string2).getType();
                if (!modelType.getCreator().equals(string)) continue;
                return modelType;
            }
            catch (DataAccessException dataAccessException) {
                this.mLogger.error((Object)"Problems deserializing persistent model: ", (Throwable)dataAccessException);
            }
        }
        return null;
    }

    @Override
    public int size() {
        this.mLogger.debug((Object)("Current MM size is " + this.mModelMap.size() + ". There are " + this.mRepository.listKeys().size() + " models in the repository."));
        return this.mModelMap.size();
    }

    @Override
    public List<ModelType> getItemKeys() {
        return new ArrayList<ModelType>(this.mModelMap.keySet());
    }
}

