/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.trace;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IndexedStatement;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefEdgeAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVar;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVarBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag.DataflowDAG;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag.TraceCodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.trace.ReachDefTraceVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReachDefTrace {
    private final ILogger mLogger;
    private final IAnnotationProvider<ReachDefStatementAnnotation> mStatementProvider;
    private final IAnnotationProvider<ReachDefEdgeAnnotation> mEdgeProvider;
    private final BoogieSymbolTable mSymbolTable;

    public ReachDefTrace(IAnnotationProvider<ReachDefEdgeAnnotation> iAnnotationProvider, IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider2, ILogger iLogger, BoogieSymbolTable boogieSymbolTable) {
        this.mLogger = iLogger;
        this.mStatementProvider = iAnnotationProvider2;
        this.mEdgeProvider = iAnnotationProvider;
        this.mSymbolTable = boogieSymbolTable;
    }

    public List<DataflowDAG<TraceCodeBlock>> process(List<CodeBlock> list) throws Throwable {
        ArrayList<CodeBlock> arrayList = new ArrayList<CodeBlock>(list);
        this.annotateReachingDefinitions(arrayList);
        List<BlockAndAssumes> list2 = this.findAssumes(arrayList);
        List<DataflowDAG<TraceCodeBlock>> list3 = this.buildDAG(arrayList, list2);
        if (this.mLogger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (IActionWithBranchEncoders iActionWithBranchEncoders : arrayList) {
                stringBuilder.append("[").append(iActionWithBranchEncoders).append("] ");
            }
            this.mLogger.debug((Object)("RD DAGs for " + String.valueOf(stringBuilder)));
            this.mLogger.debug((Object)("#" + list3.size() + " DAGs constructed"));
            this.printDebugForest(list3);
        }
        return list3;
    }

    private List<DataflowDAG<TraceCodeBlock>> buildDAG(List<CodeBlock> list, List<BlockAndAssumes> list2) {
        ArrayList<DataflowDAG<TraceCodeBlock>> arrayList = new ArrayList<DataflowDAG<TraceCodeBlock>>();
        for (BlockAndAssumes blockAndAssumes : list2) {
            for (AssumeStatement assumeStatement : blockAndAssumes.getAssumes()) {
                arrayList.add(this.buildDAG(list, blockAndAssumes, assumeStatement));
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("Finished " + BoogiePrettyPrinter.print((Statement)assumeStatement)));
            }
        }
        return arrayList;
    }

    private DataflowDAG<TraceCodeBlock> buildDAG(List<CodeBlock> list, BlockAndAssumes blockAndAssumes, AssumeStatement assumeStatement) {
        DataflowDAG dataflowDAG;
        LinkedList<DataflowDAG<TraceCodeBlock>> linkedList = new LinkedList<DataflowDAG<TraceCodeBlock>>();
        DataflowDAG dataflowDAG2 = dataflowDAG = new DataflowDAG(new TraceCodeBlock(list, blockAndAssumes.getBlock(), blockAndAssumes.getIndex()));
        linkedList.add(dataflowDAG);
        while (!linkedList.isEmpty()) {
            dataflowDAG = (DataflowDAG)((Object)linkedList.removeFirst());
            this.mLogger.debug((Object)("Current: " + dataflowDAG.toString()));
            Set<Map.Entry<ScopedBoogieVar, HashSet<IndexedStatement>>> set = this.getUse(dataflowDAG);
            if (set.isEmpty()) {
                this.mLogger.debug((Object)"Uses are empty");
            }
            for (Map.Entry<ScopedBoogieVar, HashSet<IndexedStatement>> entry : set) {
                for (IndexedStatement indexedStatement : entry.getValue()) {
                    TraceCodeBlock traceCodeBlock = this.getBlockContainingStatement(list, indexedStatement);
                    assert (traceCodeBlock != null);
                    assert (traceCodeBlock.getBlock() != null);
                    DataflowDAG<TraceCodeBlock> dataflowDAG3 = new DataflowDAG<TraceCodeBlock>(traceCodeBlock);
                    if (((TraceCodeBlock)dataflowDAG.getNodeLabel()).equals(dataflowDAG3.getNodeLabel())) {
                        this.mLogger.debug((Object)"Staying in the same block; no need to add dependency");
                        continue;
                    }
                    dataflowDAG.connectOutgoing(dataflowDAG3, entry.getKey());
                    linkedList.addFirst(dataflowDAG3);
                    this.mLogger.debug((Object)("Adding: " + dataflowDAG3.toString()));
                }
            }
        }
        return dataflowDAG2;
    }

    private TraceCodeBlock getBlockContainingStatement(List<CodeBlock> list, IndexedStatement indexedStatement) {
        StatementFinder statementFinder = new StatementFinder();
        ISearchPredicate<Statement> iSearchPredicate = statement -> statement.equals(indexedStatement.getStatement());
        int n = Integer.valueOf(indexedStatement.getKey());
        CodeBlock codeBlock = list.get(n);
        List<Statement> list2 = statementFinder.start(codeBlock, iSearchPredicate);
        if (!list2.isEmpty()) {
            return new TraceCodeBlock(list, codeBlock, n);
        }
        return null;
    }

    private Set<Map.Entry<ScopedBoogieVar, HashSet<IndexedStatement>>> getUse(DataflowDAG<TraceCodeBlock> dataflowDAG) {
        String string = String.valueOf(dataflowDAG.getNodeLabel().getIndex());
        CodeBlock codeBlock = dataflowDAG.getNodeLabel().getBlock();
        ReachDefEdgeAnnotation reachDefEdgeAnnotation = this.mEdgeProvider.getAnnotation((IElement)codeBlock, string);
        assert (reachDefEdgeAnnotation != null);
        assert (reachDefEdgeAnnotation.getKey().equals(string));
        HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> hashMap = reachDefEdgeAnnotation.getUse();
        assert (hashMap != null);
        return hashMap.entrySet();
    }

    private void annotateReachingDefinitions(List<CodeBlock> list) {
        ScopedBoogieVarBuilder scopedBoogieVarBuilder = new ScopedBoogieVarBuilder(this.mSymbolTable);
        int n = 0;
        while (n < list.size()) {
            CodeBlock codeBlock = null;
            CodeBlock codeBlock2 = list.get(n);
            if (n != 0) {
                codeBlock = list.get(n - 1);
            }
            assert (this.checkElement((IActionWithBranchEncoders)codeBlock2));
            new ReachDefTraceVisitor(this.mStatementProvider, this.mEdgeProvider, codeBlock, this.mLogger, scopedBoogieVarBuilder, n).process(codeBlock2);
            ++n;
        }
    }

    private boolean checkElement(IActionWithBranchEncoders iActionWithBranchEncoders) {
        if (iActionWithBranchEncoders instanceof StatementSequence) {
            StatementSequence statementSequence = (StatementSequence)iActionWithBranchEncoders;
            return statementSequence.getStatements().size() < 2;
        }
        if (iActionWithBranchEncoders instanceof Call) {
            return true;
        }
        if (iActionWithBranchEncoders instanceof Return) {
            return true;
        }
        if (iActionWithBranchEncoders instanceof SequentialComposition) {
            SequentialComposition sequentialComposition = (SequentialComposition)iActionWithBranchEncoders;
            for (IActionWithBranchEncoders iActionWithBranchEncoders2 : sequentialComposition.getCodeBlocks()) {
                if (this.checkElement(iActionWithBranchEncoders2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<BlockAndAssumes> findAssumes(List<CodeBlock> list) {
        ArrayList<BlockAndAssumes> arrayList = new ArrayList<BlockAndAssumes>();
        StatementFinder statementFinder = new StatementFinder();
        ISearchPredicate<Statement> iSearchPredicate = AssumeStatement.class::isInstance;
        int n = 0;
        for (CodeBlock codeBlock : list) {
            ArrayList<AssumeStatement> arrayList2 = new ArrayList<AssumeStatement>();
            for (Statement statement : statementFinder.start(codeBlock, iSearchPredicate)) {
                arrayList2.add((AssumeStatement)statement);
            }
            if (!arrayList2.isEmpty()) {
                arrayList.add(new BlockAndAssumes(arrayList2, n, codeBlock));
            }
            ++n;
        }
        return arrayList;
    }

    private void printDebugForest(List<DataflowDAG<TraceCodeBlock>> list) {
        if (list == null) {
            return;
        }
        for (DataflowDAG<TraceCodeBlock> dataflowDAG : list) {
            dataflowDAG.printGraphDebug(this.mLogger);
        }
    }

    private static class BlockAndAssumes {
        private final List<AssumeStatement> mAssumes;
        private final int mIndex;
        private final CodeBlock mBlock;

        public BlockAndAssumes(List<AssumeStatement> list, int n, CodeBlock codeBlock) {
            this.mAssumes = list;
            this.mIndex = n;
            this.mBlock = codeBlock;
        }

        public List<AssumeStatement> getAssumes() {
            return this.mAssumes;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public CodeBlock getBlock() {
            return this.mBlock;
        }
    }

    public static interface ISearchPredicate<T> {
        public boolean is(T var1);
    }

    private static class StatementFinder
    extends RCFGEdgeVisitor {
        private List<Statement> mStatements;
        private ISearchPredicate<Statement> mPredicate;

        private StatementFinder() {
        }

        protected void visit(StatementSequence statementSequence) {
            for (Statement statement : statementSequence.getStatements()) {
                if (!this.mPredicate.is(statement)) continue;
                this.mStatements.add(statement);
            }
            super.visit(statementSequence);
        }

        public List<Statement> start(CodeBlock codeBlock, ISearchPredicate<Statement> iSearchPredicate) {
            this.mStatements = new ArrayList<Statement>();
            this.mPredicate = iSearchPredicate;
            this.visit(codeBlock);
            return this.mStatements;
        }
    }
}

