/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityProvidingState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryStateFactoryAndPredicateHelper;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SMTTheoryState
implements IAbstractState<SMTTheoryState>,
IEqualityProvidingState {
    private final IPredicate mPredicate;
    private final SMTTheoryStateFactoryAndPredicateHelper mFactory;
    private final ImmutableSet<IProgramVarOrConst> mPvocs;

    public SMTTheoryState(IPredicate iPredicate, ImmutableSet<IProgramVarOrConst> immutableSet, SMTTheoryStateFactoryAndPredicateHelper sMTTheoryStateFactoryAndPredicateHelper) {
        this.mPredicate = iPredicate;
        this.mFactory = sMTTheoryStateFactoryAndPredicateHelper;
        this.mPvocs = immutableSet;
    }

    public SMTTheoryState addVariable(IProgramVarOrConst iProgramVarOrConst) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mPvocs);
        hashSet.add(iProgramVarOrConst);
        return this.mFactory.getOrConstructState(this.mPredicate, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public SMTTheoryState removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.removeVariables(Collections.singleton(iProgramVarOrConst));
    }

    public SMTTheoryState addVariables(Collection<IProgramVarOrConst> collection) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mPvocs);
        hashSet.addAll(collection);
        return this.mFactory.getOrConstructState(this.mPredicate, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public SMTTheoryState removeVariables(Collection<IProgramVarOrConst> collection) {
        Set<TermVariable> set = collection.stream().map(iProgramVarOrConst -> (TermVariable)iProgramVarOrConst.getTerm()).collect(Collectors.toSet());
        IPredicate iPredicate = this.mFactory.projectExistentially(set, this.mPredicate);
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mPvocs);
        hashSet.removeAll(collection);
        return this.mFactory.getOrConstructState(iPredicate, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mPvocs.contains((Object)iProgramVarOrConst);
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return this.mPvocs;
    }

    public SMTTheoryState patch(SMTTheoryState sMTTheoryState) {
        IAbstractState iAbstractState = this.removeVariables((Collection)sMTTheoryState.getVariables());
        return iAbstractState.intersect(sMTTheoryState);
    }

    public SMTTheoryState intersect(SMTTheoryState sMTTheoryState) {
        return this.mFactory.conjoin(this, sMTTheoryState);
    }

    public SMTTheoryState union(SMTTheoryState sMTTheoryState) {
        return this.mFactory.disjoinFlat(this, sMTTheoryState);
    }

    public boolean isEmpty() {
        return this.mPvocs.isEmpty();
    }

    public boolean isBottom() {
        return this == this.mFactory.getBottomState();
    }

    public boolean isEqualTo(SMTTheoryState sMTTheoryState) {
        return this.isSubsetOf(sMTTheoryState) == IAbstractState.SubsetResult.NON_STRICT && sMTTheoryState.isSubsetOf(this) == IAbstractState.SubsetResult.NON_STRICT || this.isSubsetOf(sMTTheoryState) == IAbstractState.SubsetResult.EQUAL;
    }

    public IAbstractState.SubsetResult isSubsetOf(SMTTheoryState sMTTheoryState) {
        boolean bl = this.mFactory.implies(this, sMTTheoryState);
        boolean bl2 = this.mFactory.implies(sMTTheoryState, this);
        if (bl && bl2) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        if (bl) {
            return IAbstractState.SubsetResult.NON_STRICT;
        }
        return IAbstractState.SubsetResult.NONE;
    }

    public SMTTheoryState compact() {
        List<TermVariable> list = Arrays.asList(this.mPredicate.getFormula().getFreeVars());
        ImmutableSet immutableSet = (ImmutableSet)this.mPvocs.stream().filter(iProgramVarOrConst -> !(iProgramVarOrConst instanceof IProgramVar) || list.contains(iProgramVarOrConst.getTerm())).collect(ImmutableSet.collector());
        return this.mFactory.getOrConstructState(this.mPredicate, (ImmutableSet<IProgramVarOrConst>)immutableSet);
    }

    public Term getTerm(Script script) {
        return this.mPredicate.getFormula();
    }

    public String toLogString() {
        return this.mPredicate.toString();
    }

    public IPredicate getPredicate() {
        return this.mPredicate;
    }

    public boolean impliesLiteral(Term term) {
        return this.mFactory.impliesLiteral(this, term);
    }

    public String toString() {
        return this.mPredicate.toString();
    }

    public boolean areEqual(Term term, Term term2) {
        ManagedScript managedScript = this.mFactory.getManagedScript();
        managedScript.lock((Object)this);
        Term term3 = managedScript.term((Object)this, "=", new Term[]{term, term2});
        managedScript.unlock((Object)this);
        return this.impliesLiteral(term3);
    }

    public boolean areUnequal(Term term, Term term2) {
        ManagedScript managedScript = this.mFactory.getManagedScript();
        managedScript.lock((Object)this);
        Term term3 = managedScript.term((Object)this, "distinct", new Term[]{term, term2});
        managedScript.unlock((Object)this);
        return this.impliesLiteral(term3);
    }

    public IEqualityProvidingState join(IEqualityProvidingState iEqualityProvidingState) {
        return this.union((SMTTheoryState)iEqualityProvidingState);
    }

    public SMTTheoryState renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

