/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class StructAccessExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(StructAccessExpression.class);
    Expression struct;
    String field;

    public StructAccessExpression(ILocation iLocation, Expression expression, String string) {
        super(iLocation);
        this.struct = expression;
        this.field = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid StructAccessExpression: " + String.valueOf((Object)this);
    }

    public StructAccessExpression(ILocation iLocation, IBoogieType iBoogieType, Expression expression, String string) {
        super(iLocation, iBoogieType);
        this.struct = expression;
        this.field = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid StructAccessExpression: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StructAccessExpression").append('[');
        stringBuffer.append((Object)this.struct);
        stringBuffer.append(',').append(this.field);
        return stringBuffer.append(']').toString();
    }

    public Expression getStruct() {
        return this.struct;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.struct);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.struct != null) {
            this.struct.accept(generatedBoogieAstVisitor);
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.struct != null) {
            expression2 = this.struct.accept(generatedBoogieAstTransformer);
        }
        if (this.struct != expression2) {
            return new StructAccessExpression(this.loc, this.type, expression2, this.field);
        }
        return this;
    }
}

