/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.Arrays;

public class DataTypeLemma {
    private final CCAnnotation.RuleKind mRule;
    private final SymmetricPair<CCTerm> mMainEquality;
    private final SymmetricPair<CCTerm>[] mReason;
    private final Object[] mAnnotation;

    public DataTypeLemma(CCAnnotation.RuleKind ruleKind, SymmetricPair<CCTerm> symmetricPair, SymmetricPair<CCTerm>[] symmetricPairArray) {
        this.mRule = ruleKind;
        this.mReason = symmetricPairArray;
        this.mMainEquality = symmetricPair;
        this.mAnnotation = null;
    }

    public DataTypeLemma(CCAnnotation.RuleKind ruleKind, SymmetricPair<CCTerm> symmetricPair, SymmetricPair<CCTerm>[] symmetricPairArray, CCTerm cCTerm) {
        assert (ruleKind == CCAnnotation.RuleKind.DT_PROJECT || ruleKind == CCAnnotation.RuleKind.DT_TESTER);
        this.mRule = ruleKind;
        this.mReason = symmetricPairArray;
        this.mMainEquality = symmetricPair;
        this.mAnnotation = new Object[]{":cons", cCTerm.getFlatTerm()};
    }

    public DataTypeLemma(CCAnnotation.RuleKind ruleKind, SymmetricPair<CCTerm> symmetricPair, SymmetricPair<CCTerm>[] symmetricPairArray, CCTerm cCTerm, CCTerm cCTerm2) {
        assert (ruleKind == CCAnnotation.RuleKind.DT_INJECTIVE);
        this.mRule = ruleKind;
        this.mReason = symmetricPairArray;
        this.mMainEquality = symmetricPair;
        this.mAnnotation = new Object[]{":cons", cCTerm.getFlatTerm(), cCTerm2.getFlatTerm()};
    }

    public DataTypeLemma(CCAnnotation.RuleKind ruleKind, SymmetricPair<CCTerm>[] symmetricPairArray, CCTerm cCTerm, CCTerm cCTerm2) {
        assert (ruleKind == CCAnnotation.RuleKind.DT_DISJOINT);
        this.mRule = ruleKind;
        this.mReason = symmetricPairArray;
        this.mMainEquality = null;
        this.mAnnotation = new Object[]{":cons", cCTerm.getFlatTerm(), cCTerm2.getFlatTerm()};
    }

    public DataTypeLemma(CCAnnotation.RuleKind ruleKind, SymmetricPair<CCTerm>[] symmetricPairArray, Term[] termArray) {
        assert (ruleKind == CCAnnotation.RuleKind.DT_CASES || ruleKind == CCAnnotation.RuleKind.DT_UNIQUE);
        this.mRule = ruleKind;
        this.mReason = symmetricPairArray;
        this.mMainEquality = null;
        this.mAnnotation = termArray;
    }

    public DataTypeLemma(CCAnnotation.RuleKind ruleKind, SymmetricPair<CCTerm>[] symmetricPairArray, CCTerm[] cCTermArray) {
        assert (ruleKind == CCAnnotation.RuleKind.DT_CYCLE);
        this.mRule = ruleKind;
        this.mReason = symmetricPairArray;
        this.mMainEquality = null;
        this.mAnnotation = new Object[]{":cycle", this.getCycleTerms(cCTermArray)};
    }

    public CCAnnotation.RuleKind getRule() {
        return this.mRule;
    }

    public SymmetricPair<CCTerm> getMainEquality() {
        return this.mMainEquality;
    }

    public SymmetricPair<CCTerm>[] getReason() {
        return this.mReason;
    }

    public Object[] getAnnotation() {
        return this.mAnnotation == null ? new Object[]{} : this.mAnnotation;
    }

    private Term[] getCycleTerms(CCTerm[] cCTermArray) {
        Term[] termArray = new Term[cCTermArray.length];
        int n = 0;
        CCTerm[] cCTermArray2 = cCTermArray;
        int n2 = cCTermArray.length;
        int n3 = 0;
        while (n3 < n2) {
            CCTerm cCTerm = cCTermArray2[n3];
            termArray[n++] = cCTerm.getFlatTerm();
            ++n3;
        }
        return termArray;
    }

    public String toString() {
        return "DataTypeLemma[" + String.valueOf((Object)this.mRule) + "," + String.valueOf(this.mMainEquality) + "," + Arrays.toString(this.mAnnotation) + "]";
    }
}

