/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonEpimorphism;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.ITransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.HashMap;

public final class SuperDifference<LETTER, STATE, FAC extends IIntersectionStateFactory<STATE> & ISinkStateFactory<STATE>>
extends BinaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final String FOLLOW_LABEL = "follow label ";
    private static final String ADD_TARGET_SINK_STATE_Q2 = "add target (sink) state q2: ";
    private static final String TRAVERSE_IN_SINK_STATE = "Traverse in sink state ";
    private static final String WITH = " with ";
    private static final String AND_DOTS = " and ...";
    private final INestedWordAutomaton<LETTER, STATE> mMinuend;
    private final INestedWordAutomaton<LETTER, STATE> mSubtrahend;
    private final AutomatonEpimorphism<STATE> mEpimorphism;
    private final NestedWordAutomaton<LETTER, STATE> mResult;
    private final STATE mSinkState;
    private final HashMap<String, STATE> mContainedStatesHashMap;
    private final FAC mStateFactory;

    public SuperDifference(AutomataLibraryServices automataLibraryServices, FAC FAC, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton2, AutomatonEpimorphism<STATE> automatonEpimorphism, boolean bl) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mMinuend = iNestedWordAutomaton;
        this.mSubtrahend = iNestedWordAutomaton2;
        this.mEpimorphism = automatonEpimorphism;
        this.mStateFactory = FAC;
        this.mContainedStatesHashMap = new HashMap();
        if (bl && this.mLogger.isErrorEnabled()) {
            this.mLogger.error((Object)"Minimization not implemented.");
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = new NestedWordAutomaton(this.mServices, iNestedWordAutomaton.getVpAlphabet(), this.mStateFactory);
        this.mSinkState = ((ISinkStateFactory)this.mStateFactory).createSinkStateContent();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Created Sink-State: " + this.mSinkState.toString()));
        }
        for (Object e : this.mMinuend.getInitialStates()) {
            STATE STATE = this.mEpimorphism.getMapping(e);
            if (STATE == null || !this.mSubtrahend.getInitialStates().contains(STATE)) {
                STATE = this.mSinkState;
            } else assert (this.mSubtrahend.getStates().contains(STATE));
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Add initial state:" + String.valueOf(e) + "---" + String.valueOf(STATE)));
            }
            this.addState(e, STATE);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". Minuend " + this.mMinuend.sizeInformation() + " Subtrahend " + this.mSubtrahend.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Result " + this.mResult.sizeInformation();
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mMinuend;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSubtrahend;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    String bl(boolean bl) {
        return bl ? "T" : "F";
    }

    private STATE addState(STATE STATE, STATE STATE2) {
        boolean bl;
        STATE STATE3;
        assert (this.mMinuend.getStates().contains(STATE));
        assert (STATE2 == this.mSinkState || this.mSubtrahend.getStates().contains(STATE2));
        String string = STATE.toString() + "|" + STATE2.toString();
        STATE STATE4 = this.mContainedStatesHashMap.get(string);
        if (STATE4 != null) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("State for " + string + " already exists: " + STATE4.toString()));
            }
            return STATE4;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Add state: " + string + " created from: " + STATE.toString() + " and " + STATE2.toString()));
        }
        if ((STATE3 = this.mStateFactory.intersection(STATE, STATE2)) == null && this.mLogger.isErrorEnabled()) {
            this.mLogger.error((Object)"State factory returned no state!");
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("intersection: " + String.valueOf(STATE3)));
        }
        this.mContainedStatesHashMap.put(string, STATE3);
        boolean bl2 = this.mMinuend.isInitial(STATE) && (STATE2 == this.mSinkState || this.mSubtrahend.isInitial(STATE2));
        boolean bl3 = bl = this.mMinuend.isFinal(STATE) && (STATE2 == this.mSinkState || !this.mSubtrahend.isFinal(STATE2));
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("isFinal: " + bl));
            this.mLogger.debug((Object)("isIniti: " + bl2));
        }
        this.mResult.addState(bl2, bl, STATE3);
        STATE STATE5 = this.mEpimorphism.getMapping(STATE);
        if (STATE5 == STATE2) {
            this.addStateNormalState(STATE, STATE2, STATE3, STATE5);
        } else {
            this.addStateSinkState(STATE, STATE2, STATE3, STATE5);
        }
        return STATE3;
    }

    private void addStateSinkState(STATE STATE, STATE STATE2, STATE STATE3, STATE STATE4) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("No epimorph state found: hr:" + String.valueOf(STATE4) + " r:" + String.valueOf(STATE) + " s: " + String.valueOf(STATE2)));
        }
        this.addStateSinkStateInternal(STATE, STATE3);
        this.addStateSinkStateCall(STATE, STATE3);
        this.addStateSinkStateReturn(STATE, STATE3);
    }

    private void addStateSinkStateInternal(STATE STATE, STATE STATE2) {
        for (OutgoingInternalTransition outgoingInternalTransition : this.mMinuend.internalSuccessors(STATE)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)(FOLLOW_LABEL + String.valueOf(outgoingInternalTransition.getLetter()) + AND_DOTS));
                this.mLogger.debug((Object)(ADD_TARGET_SINK_STATE_Q2 + String.valueOf(outgoingInternalTransition.getSucc())));
            }
            STATE STATE3 = this.addState(outgoingInternalTransition.getSucc(), this.mSinkState);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)(TRAVERSE_IN_SINK_STATE + String.valueOf(STATE2) + WITH + String.valueOf(outgoingInternalTransition.getLetter()) + " to " + STATE3.toString()));
            }
            this.mResult.addInternalTransition(STATE2, outgoingInternalTransition.getLetter(), STATE3);
        }
    }

    private void addStateSinkStateCall(STATE STATE, STATE STATE2) {
        for (OutgoingCallTransition outgoingCallTransition : this.mMinuend.callSuccessors(STATE)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)(FOLLOW_LABEL + String.valueOf(outgoingCallTransition.getLetter()) + AND_DOTS));
                this.mLogger.debug((Object)(ADD_TARGET_SINK_STATE_Q2 + String.valueOf(outgoingCallTransition.getSucc())));
            }
            STATE STATE3 = this.addState(outgoingCallTransition.getSucc(), this.mSinkState);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)(TRAVERSE_IN_SINK_STATE + String.valueOf(STATE2) + WITH + String.valueOf(outgoingCallTransition.getLetter()) + " to " + STATE3.toString()));
            }
            this.mResult.addCallTransition(STATE2, outgoingCallTransition.getLetter(), STATE3);
        }
    }

    private void addStateSinkStateReturn(STATE STATE, STATE STATE2) {
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mMinuend.returnSuccessors(STATE)) {
            STATE STATE3;
            STATE STATE4;
            STATE STATE5;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)(FOLLOW_LABEL + String.valueOf(outgoingReturnTransition.getLetter()) + AND_DOTS));
                this.mLogger.debug((Object)(ADD_TARGET_SINK_STATE_Q2 + String.valueOf(outgoingReturnTransition.getSucc())));
            }
            if ((STATE5 = this.mEpimorphism.getMapping(outgoingReturnTransition.getHierPred())) != null) {
                STATE4 = this.addState(outgoingReturnTransition.getHierPred(), STATE5);
                STATE3 = this.addState(outgoingReturnTransition.getSucc(), this.mSinkState);
                this.mResult.addReturnTransition(STATE2, STATE4, outgoingReturnTransition.getLetter(), STATE3);
            }
            STATE4 = this.addState(outgoingReturnTransition.getHierPred(), this.mSinkState);
            STATE3 = this.addState(outgoingReturnTransition.getSucc(), this.mSinkState);
            this.mResult.addReturnTransition(STATE2, STATE4, outgoingReturnTransition.getLetter(), STATE3);
            if (!this.mLogger.isDebugEnabled()) continue;
            this.mLogger.debug((Object)(TRAVERSE_IN_SINK_STATE + String.valueOf(STATE2) + WITH + String.valueOf(outgoingReturnTransition.getLetter()) + " to " + STATE3.toString()));
        }
    }

    private void addStateNormalState(STATE STATE, STATE STATE2, STATE STATE3, STATE STATE4) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("epimorph state: " + STATE4.toString()));
        }
        for (OutgoingInternalTransition iOutgoingTransitionlet : this.mMinuend.internalSuccessors(STATE)) {
            this.traverseEdge(iOutgoingTransitionlet, STATE, STATE2, STATE3, iOutgoingTransitionlet.getSucc(), 0, null);
        }
        for (OutgoingCallTransition outgoingCallTransition : this.mMinuend.callSuccessors(STATE)) {
            this.traverseEdge(outgoingCallTransition, STATE, STATE2, STATE3, outgoingCallTransition.getSucc(), 1, null);
        }
        for (OutgoingReturnTransition outgoingReturnTransition : this.mMinuend.returnSuccessors(STATE)) {
            Object STATE5;
            STATE STATE6 = this.mEpimorphism.getMapping(outgoingReturnTransition.getHierPred());
            if (STATE6 != null) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("found hier pred state mapping:" + STATE6.toString()));
                }
                STATE5 = this.addState(outgoingReturnTransition.getHierPred(), STATE6);
                this.traverseEdge(outgoingReturnTransition, STATE, STATE2, STATE3, outgoingReturnTransition.getSucc(), 2, STATE5);
            } else if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"found sink no hier pred mapping, took sink state");
            }
            STATE5 = this.addState(outgoingReturnTransition.getHierPred(), this.mSinkState);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("hier pred is: " + String.valueOf(STATE5)));
            }
            this.traverseEdge(outgoingReturnTransition, STATE, STATE2, STATE3, outgoingReturnTransition.getSucc(), 2, STATE5);
        }
    }

    private void traverseEdge(ITransitionlet<LETTER, STATE> iTransitionlet, STATE STATE, STATE STATE2, STATE STATE3, STATE STATE4, int n, STATE STATE5) {
        STATE STATE6;
        LETTER LETTER = iTransitionlet.getLetter();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Traverse edge: from " + STATE.toString() + WITH + String.valueOf(LETTER) + " to " + STATE4.toString()));
        }
        STATE STATE7 = this.mEpimorphism.getMapping(STATE4);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("mapping of the target is: " + String.valueOf(STATE7)));
        }
        boolean bl = false;
        if (STATE7 != null) {
            switch (n) {
                case 0: {
                    bl = this.findTargetInternal(STATE2, LETTER, STATE7);
                    break;
                }
                case 1: {
                    bl = this.findTargetCall(STATE2, LETTER, STATE7);
                    break;
                }
                case 2: {
                    bl = this.findTargetReturn(STATE2, STATE5, LETTER, STATE7);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (bl) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"target state exists");
            }
            STATE6 = this.addState(STATE4, STATE7);
        } else {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"target state exists not");
            }
            STATE6 = this.addState(STATE4, this.mSinkState);
        }
        switch (n) {
            case 0: {
                this.mResult.addInternalTransition(STATE3, LETTER, STATE6);
                break;
            }
            case 1: {
                this.mResult.addCallTransition(STATE3, LETTER, STATE6);
                break;
            }
            case 2: {
                this.mResult.addReturnTransition(STATE3, STATE5, LETTER, STATE6);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private boolean findTargetInternal(STATE STATE, LETTER LETTER, STATE STATE2) {
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.mSubtrahend.internalSuccessors(STATE, LETTER)) {
            if (outgoingInternalTransition.getSucc() != STATE2) continue;
            return true;
        }
        return false;
    }

    private boolean findTargetCall(STATE STATE, LETTER LETTER, STATE STATE2) {
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.mSubtrahend.callSuccessors(STATE, LETTER)) {
            if (outgoingCallTransition.getSucc() != STATE2) continue;
            return true;
        }
        return false;
    }

    private boolean findTargetReturn(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("hierPred for " + String.valueOf(STATE2)));
        }
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mSubtrahend.returnSuccessors(STATE, STATE2, LETTER)) {
            if (outgoingReturnTransition.getSucc() != STATE3) continue;
            return true;
        }
        return false;
    }
}

