/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonForLetterBasedOnDemandConstruction;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.FullMultipebbleGameState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.FullMultipebbleStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.IFullMultipebbleAuxiliaryGameState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FullMultipebbleGameAutomaton<LETTER, STATE, GS extends FullMultipebbleGameState<STATE>>
extends NestedWordAutomatonForLetterBasedOnDemandConstruction<LETTER, GS> {
    private final AutomataLibraryServices mServices;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final FullMultipebbleStateFactory<STATE, GS> mStateFactory;
    private final GS mEmptyStackState;
    private final NestedMap2<STATE, STATE, GS> mGameStateMapping;
    private final Set<GS> mInitialStates;
    private final LETTER mInternalLetterForSpoilerWinningSink;
    private final LETTER mCallLetterForSpoilerWinningSink;

    public FullMultipebbleGameAutomaton(AutomataLibraryServices automataLibraryServices, FullMultipebbleStateFactory<STATE, GS> fullMultipebbleStateFactory, ISetOfPairs<STATE, ?> iSetOfPairs, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
        this.mServices = automataLibraryServices;
        this.mOperand = iDoubleDeckerAutomaton;
        this.mStateFactory = fullMultipebbleStateFactory;
        this.mEmptyStackState = (FullMultipebbleGameState)fullMultipebbleStateFactory.createEmptyStackState();
        this.mInitialStates = new HashSet<GS>();
        this.mGameStateMapping = new NestedMap2();
        if (this.mOperand.getVpAlphabet().getInternalAlphabet().isEmpty()) {
            this.mInternalLetterForSpoilerWinningSink = null;
            if (this.mOperand.getVpAlphabet().getCallAlphabet().isEmpty()) {
                throw new UnsupportedOperationException("Unsupported: automata where internal alphabet and call alphabet are empty.");
            }
            this.mCallLetterForSpoilerWinningSink = this.mOperand.getVpAlphabet().getCallAlphabet().iterator().next();
        } else {
            this.mInternalLetterForSpoilerWinningSink = this.mOperand.getVpAlphabet().getInternalAlphabet().iterator().next();
            this.mCallLetterForSpoilerWinningSink = null;
        }
        this.constructInitialStates(iSetOfPairs);
    }

    private void constructInitialStates(ISetOfPairs<STATE, ?> iSetOfPairs) {
        for (Pair pair : iSetOfPairs) {
            Object object;
            Object object2 = pair.getFirst();
            if (!this.mStateFactory.isImmediatelyWinningForSpoiler(object2, object = pair.getSecond(), this.mOperand)) {
                GS GS = this.mStateFactory.constructInitialState(object2, object, this.mOperand);
                this.mGameStateMapping.put(object2, object, GS);
                this.mInitialStates.add(GS);
            }
            if (this.mServices.getProgressAwareTimer().continueProcessing()) continue;
            throw new ToolchainCanceledException(this.getClass(), "constructing initial states of game automaton (already constructed: " + this.mInitialStates.size() + " states");
        }
    }

    public NestedMap2<STATE, STATE, GS> getGameStateMapping() {
        return this.mGameStateMapping;
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<GS> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public String sizeInformation() {
        return "has " + this.mInitialStates.size() + " initial states, number of all states yet unknown.";
    }

    @Override
    public GS getEmptyStackState() {
        return this.mEmptyStackState;
    }

    @Override
    public Iterable<GS> getInitialStates() {
        return this.mInitialStates;
    }

    @Override
    public boolean isInitial(GS GS) {
        return this.mInitialStates.contains(GS);
    }

    @Override
    public boolean isFinal(GS GS) {
        return ((FullMultipebbleGameState)GS).isAccepting();
    }

    @Override
    public Set<LETTER> lettersInternal(GS GS) {
        if (IFullMultipebbleAuxiliaryGameState.isSpoilerWinningSink(GS)) {
            if (this.mInternalLetterForSpoilerWinningSink == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.mInternalLetterForSpoilerWinningSink);
        }
        return this.mOperand.lettersInternal(((FullMultipebbleGameState)GS).getSpoilerDoubleDecker().getUp());
    }

    @Override
    public Set<LETTER> lettersCall(GS GS) {
        if (IFullMultipebbleAuxiliaryGameState.isSpoilerWinningSink(GS)) {
            if (this.mCallLetterForSpoilerWinningSink == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.mCallLetterForSpoilerWinningSink);
        }
        return this.mOperand.lettersCall(((FullMultipebbleGameState)GS).getSpoilerDoubleDecker().getUp());
    }

    @Override
    public Set<LETTER> lettersReturn(GS GS, GS GS2) {
        if (IFullMultipebbleAuxiliaryGameState.isSpoilerWinningSink(GS)) {
            return Collections.emptySet();
        }
        return this.mOperand.lettersReturn(((FullMultipebbleGameState)GS).getSpoilerDoubleDecker().getUp(), ((FullMultipebbleGameState)GS2).getSpoilerDoubleDecker().getUp());
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, GS>> internalSuccessors(GS GS, LETTER LETTER) {
        ArrayList<OutgoingInternalTransition<LETTER, GS>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, GS>>();
        for (FullMultipebbleGameState fullMultipebbleGameState : this.mStateFactory.computeSuccessorsInternal(GS, LETTER, this.mOperand)) {
            arrayList.add(new OutgoingInternalTransition<LETTER, FullMultipebbleGameState>(LETTER, fullMultipebbleGameState));
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, GS>> callSuccessors(GS GS, LETTER LETTER) {
        ArrayList<OutgoingCallTransition<LETTER, GS>> arrayList = new ArrayList<OutgoingCallTransition<LETTER, GS>>();
        for (FullMultipebbleGameState fullMultipebbleGameState : this.mStateFactory.computeSuccessorsCall(GS, LETTER, this.mOperand)) {
            arrayList.add(new OutgoingCallTransition<LETTER, FullMultipebbleGameState>(LETTER, fullMultipebbleGameState));
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, GS>> returnSuccessors(GS GS, GS GS2, LETTER LETTER) {
        ArrayList<OutgoingReturnTransition<LETTER, GS>> arrayList = new ArrayList<OutgoingReturnTransition<LETTER, GS>>();
        for (FullMultipebbleGameState fullMultipebbleGameState : this.mStateFactory.computeSuccessorsReturn(GS, GS2, LETTER, this.mOperand)) {
            arrayList.add(new OutgoingReturnTransition<LETTER, FullMultipebbleGameState>((FullMultipebbleGameState)GS2, LETTER, fullMultipebbleGameState));
        }
        return arrayList;
    }
}

