/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.FunctionDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IBooleanArrayHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryAdressing;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryStructure;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryAddressing1D;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryAddressing2D;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryAddressingFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureMultiBitprecise;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureSingleBitprecise;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureUnbounded;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;

public class MemoryModelFactory {
    public static MemoryModel createMemoryModel(TranslationSettings translationSettings, ITypeHandler iTypeHandler, ExpressionTranslation expressionTranslation, IBooleanArrayHelper iBooleanArrayHelper, TypeSizes typeSizes, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, FunctionDeclarations functionDeclarations, IMemoryPointer iMemoryPointer) {
        IMemoryAdressing iMemoryAdressing = MemoryAddressingFactory.createMemoryAddressing(translationSettings, iTypeHandler, expressionTranslation, iBooleanArrayHelper, typeSizes, typeSizeAndOffsetComputer, functionDeclarations, iMemoryPointer);
        IMemoryStructure iMemoryStructure = MemoryStructureFactory.createMemoryStructure(translationSettings, typeSizes, iTypeHandler);
        if (!Combinations.isValid(iMemoryAdressing.getClass(), iMemoryStructure.getClass())) {
            throw new UnsupportedOperationException("The combination of addressing: " + String.valueOf(iMemoryAdressing.getClass()) + " and structure " + String.valueOf(iMemoryStructure.getClass()) + " is invalid!");
        }
        return new MemoryModel(iMemoryAdressing, iMemoryStructure);
    }

    private static enum Combinations {
        ONE_Dimensional_SingleBitPrecise(MemoryAddressing1D.class, MemoryStructureSingleBitprecise.class),
        ONE_Dimensional_MultiBitPrecise(MemoryAddressing1D.class, MemoryStructureMultiBitprecise.class),
        ONE_Dimensional_Unbounded(MemoryAddressing1D.class, MemoryStructureUnbounded.class),
        TWO_Dimensional_MultiBitPrecise(MemoryAddressing2D.class, MemoryStructureMultiBitprecise.class),
        TWO_Dimensional_SingleBitPrecise(MemoryAddressing2D.class, MemoryStructureSingleBitprecise.class),
        TWO_Dimensional_Unbounded(MemoryAddressing2D.class, MemoryStructureUnbounded.class);

        private final Class<? extends IMemoryAdressing> mAddressingType;
        private final Class<? extends IMemoryStructure> mStructureType;

        private Combinations(Class<? extends IMemoryAdressing> clazz, Class<? extends IMemoryStructure> clazz2) {
            this.mAddressingType = clazz;
            this.mStructureType = clazz2;
        }

        public static boolean isValid(Class<? extends IMemoryAdressing> clazz, Class<? extends IMemoryStructure> clazz2) {
            Combinations[] combinationsArray = Combinations.values();
            int n = combinationsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Combinations combinations = combinationsArray[n2];
                if (combinations.mAddressingType.equals(clazz) && combinations.mStructureType.equals(clazz2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

