/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.AbstractCounterexample;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IVariableProvider;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IAbstractStateStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ISummaryStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IWorklistItem;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class AbsIntResult<STATE extends IAbstractState<STATE>, ACTION, LOCATION>
implements IAbstractInterpretationResult<STATE, ACTION, LOCATION> {
    private final IAbstractDomain<STATE, ACTION> mAbstractDomain;
    private final IVariableProvider<STATE, ACTION> mVariableProvider;
    private final ITransitionProvider<ACTION, LOCATION> mTransProvider;
    private final List<AbstractCounterexample<DisjunctiveAbstractState<STATE>, ACTION, LOCATION>> mCounterexamples;
    private final AbsIntBenchmark<ACTION> mBenchmark;
    private final Script mScript;
    private IAbstractStateStorage<STATE, ACTION, LOCATION> mRootStorage;
    private ISummaryStorage<STATE, ACTION, LOCATION> mSummaryMap;
    private Map<LOCATION, Term> mLoc2Term;
    private Map<LOCATION, Set<STATE>> mLoc2States;
    private Map<LOCATION, STATE> mLoc2SingleStates;
    private Set<Term> mTerms;

    protected AbsIntResult(Script script, IAbstractDomain<STATE, ACTION> iAbstractDomain, ITransitionProvider<ACTION, LOCATION> iTransitionProvider, IVariableProvider<STATE, ACTION> iVariableProvider) {
        this.mAbstractDomain = Objects.requireNonNull(iAbstractDomain);
        this.mScript = Objects.requireNonNull(script);
        this.mTransProvider = Objects.requireNonNull(iTransitionProvider);
        this.mVariableProvider = Objects.requireNonNull(iVariableProvider);
        this.mCounterexamples = new ArrayList<AbstractCounterexample<DisjunctiveAbstractState<STATE>, ACTION, LOCATION>>();
        this.mBenchmark = new AbsIntBenchmark();
    }

    void reachedError(ITransitionProvider<ACTION, LOCATION> iTransitionProvider, IWorklistItem<STATE, ACTION, LOCATION> iWorklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        ArrayList<Triple<DisjunctiveAbstractState<STATE>, LOCATION, ACTION>> arrayList = new ArrayList<Triple<DisjunctiveAbstractState<STATE>, LOCATION, ACTION>>();
        ACTION ACTION = iWorklistItem.getAction();
        arrayList.add(this.getCexTriple(iTransitionProvider, disjunctiveAbstractState, ACTION));
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = iWorklistItem.getState();
        IWorklistItem<STATE, ACTION, LOCATION> iWorklistItem2 = iWorklistItem.getPredecessor();
        while (iWorklistItem2 != null) {
            ACTION = iWorklistItem2.getAction();
            arrayList.add(this.getCexTriple(iTransitionProvider, disjunctiveAbstractState2, ACTION));
            disjunctiveAbstractState2 = iWorklistItem2.getState();
            iWorklistItem2 = iWorklistItem2.getPredecessor();
        }
        Collections.reverse(arrayList);
        this.mCounterexamples.add(new AbstractCounterexample(disjunctiveAbstractState2, iTransitionProvider.getSource(ACTION), arrayList));
    }

    private Triple<DisjunctiveAbstractState<STATE>, LOCATION, ACTION> getCexTriple(ITransitionProvider<ACTION, LOCATION> iTransitionProvider, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, ACTION ACTION) {
        return new Triple(disjunctiveAbstractState, iTransitionProvider.getTarget(ACTION), ACTION);
    }

    void saveRootStorage(IAbstractStateStorage<STATE, ACTION, LOCATION> iAbstractStateStorage) {
        this.mRootStorage = iAbstractStateStorage;
    }

    void saveSummaryStorage(ISummaryStorage<STATE, ACTION, LOCATION> iSummaryStorage) {
        this.mSummaryMap = iSummaryStorage;
    }

    public Set<STATE> getPostStates(Deque<ACTION> deque, ACTION ACTION, Set<STATE> set) {
        Set<STATE> set2 = this.mRootStorage.computeContextSensitiveAbstractPostStates(deque, ACTION);
        return set2;
    }

    public Map<LOCATION, Term> getLoc2Term() {
        if (this.mLoc2Term == null) {
            this.mLoc2Term = new HashMap<LOCATION, Term>();
            for (Map.Entry<LOCATION, STATE> entry : this.getLoc2SingleStates().entrySet()) {
                this.mLoc2Term.put(entry.getKey(), ((IAbstractState)entry.getValue()).getTerm(this.mScript));
            }
        }
        return this.mLoc2Term;
    }

    public Map<LOCATION, Set<STATE>> getLoc2States() {
        if (this.mLoc2States == null) {
            this.mLoc2States = new HashMap<LOCATION, Set<STATE>>();
            Map<LOCATION, Set<DisjunctiveAbstractState<STATE>>> map = this.mRootStorage.computeLoc2States();
            for (Map.Entry<LOCATION, Set<DisjunctiveAbstractState<STATE>>> entry : map.entrySet()) {
                Set set = entry.getValue().stream().flatMap(disjunctiveAbstractState -> disjunctiveAbstractState.getStates().stream()).collect(Collectors.toSet());
                this.mLoc2States.put(entry.getKey(), set);
            }
        }
        return this.mLoc2States;
    }

    public Map<LOCATION, STATE> getLoc2SingleStates() {
        if (this.mLoc2SingleStates == null) {
            this.mLoc2SingleStates = new HashMap<LOCATION, STATE>();
            for (Map.Entry<LOCATION, Set<STATE>> entry : this.getLoc2States().entrySet()) {
                Optional optional = entry.getValue().stream().reduce((iAbstractState, iAbstractState2) -> iAbstractState.union(iAbstractState2));
                if (!optional.isPresent()) continue;
                this.mLoc2SingleStates.put(entry.getKey(), (IAbstractState)optional.get());
            }
        }
        return this.mLoc2SingleStates;
    }

    public Set<Term> getTerms() {
        if (this.mTerms == null) {
            this.mTerms = new HashSet<Term>();
            this.getLoc2Term().entrySet().stream().map(entry -> (Term)entry.getValue()).forEach(this.mTerms::add);
        }
        return this.mTerms;
    }

    public IAbstractDomain<STATE, ACTION> getUsedDomain() {
        return this.mAbstractDomain;
    }

    public IVariableProvider<STATE, ACTION> getUsedVariableProvider() {
        return this.mVariableProvider;
    }

    public List<AbstractCounterexample<DisjunctiveAbstractState<STATE>, ACTION, LOCATION>> getCounterexamples() {
        return this.mCounterexamples;
    }

    public boolean hasReachedError() {
        return !this.mCounterexamples.isEmpty();
    }

    public AbsIntBenchmark<ACTION> getBenchmark() {
        return this.mBenchmark;
    }

    public String toString() {
        return this.toSimplifiedString(Term::toStringDirect);
    }

    public String toSimplifiedString(Function<Term, String> function) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasReachedError()) {
            stringBuilder.append("AI reached error location.");
        } else {
            stringBuilder.append("AI did not reach error location.");
        }
        if (this.getTerms() != null) {
            stringBuilder.append(" Found terms ");
            stringBuilder.append(String.join((CharSequence)", ", this.getTerms().stream().map(function::apply).collect(Collectors.toList())));
        }
        return stringBuilder.toString();
    }
}

