/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.DataRaceFoundResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.NotAnalyzedResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovabilityReason;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UserSpecifiedLimitReachedResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.IcfgAngelicProgramExecution;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopLocalResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public final class CegarLoopResultReporter<L extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final BiConsumer<IcfgLocation, IResult> mReportFunction;
    private final String mPluginId;
    private final String mPluginName;

    public CegarLoopResultReporter(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, String string, String string2) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mPluginId = string;
        this.mPluginName = string2;
        this.mReportFunction = (icfgLocation, iResult) -> this.reportResult((IResult)iResult);
    }

    public CegarLoopResultReporter(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, String string, String string2, BiConsumer<IcfgLocation, IResult> biConsumer) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mPluginId = string;
        this.mPluginName = string2;
        this.mReportFunction = biConsumer;
    }

    public void reportCegarLoopResult(CegarLoopResult<L> cegarLoopResult) {
        for (Map.Entry<IcfgLocation, CegarLoopLocalResult<L>> entry : cegarLoopResult.getResults().entrySet()) {
            CegarLoopLocalResult<L> cegarLoopLocalResult = entry.getValue();
            IcfgLocation icfgLocation = entry.getKey();
            switch (cegarLoopLocalResult.getResult()) {
                case SAFE: {
                    this.reportPositiveResult(icfgLocation);
                    break;
                }
                case UNSAFE: {
                    this.reportCounterexampleResult(icfgLocation, cegarLoopLocalResult.getProgramExecution());
                    break;
                }
                case TIMEOUT: 
                case USER_LIMIT_TIME: 
                case USER_LIMIT_TRACEHISTOGRAM: 
                case USER_LIMIT_ITERATIONS: 
                case USER_LIMIT_PATH_PROGRAM: {
                    this.reportLimitResult(icfgLocation, cegarLoopLocalResult);
                    break;
                }
                case UNKNOWN: {
                    this.reportUnknownResult(cegarLoopLocalResult.getUnprovabilityReasons(), icfgLocation, cegarLoopLocalResult.getProgramExecution());
                }
            }
        }
    }

    public void reportAllSafeResultIfNecessary(CegarLoopResult<L> cegarLoopResult, int n) {
        this.reportAllSafeResultIfNecessary(Collections.singletonList(cegarLoopResult), n);
    }

    public void reportAllSafeResultIfNecessary(Collection<? extends CegarLoopResult<L>> collection, int n) {
        if (collection.stream().allMatch(cegarLoopResult -> cegarLoopResult.resultStream().allMatch(result -> result == AbstractCegarLoop.Result.SAFE))) {
            AllSpecificationsHoldResult allSpecificationsHoldResult = AllSpecificationsHoldResult.createAllSpecificationsHoldResult((String)this.mPluginName, (int)n);
            this.reportResult((IResult)allSpecificationsHoldResult);
        }
    }

    public void reportResult(IResult iResult) {
        this.mServices.getResultService().reportResult(this.mPluginId, iResult);
    }

    private void reportPositiveResult(IcfgLocation icfgLocation) {
        PositiveResult positiveResult = new PositiveResult(this.mPluginName, (IElement)icfgLocation, this.mServices.getBacktranslationService());
        this.mReportFunction.accept(icfgLocation, (IResult)positiveResult);
    }

    private void reportCounterexampleResult(IcfgLocation icfgLocation, IProgramExecution<L, Term> iProgramExecution) {
        List list = UnprovabilityReason.getUnprovabilityReasons(iProgramExecution);
        if (!list.isEmpty()) {
            this.reportUnproveableResult(icfgLocation, iProgramExecution, list);
            return;
        }
        assert (iProgramExecution == null || icfgLocation == this.getErrorPP(iProgramExecution));
        if (this.isAngelicallySafe(iProgramExecution)) {
            this.mLogger.info("Ignoring angelically safe counterexample for %s", new Object[]{icfgLocation});
            return;
        }
        Check check = Check.getAnnotation((IElement)icfgLocation);
        Object object = check != null && check.getSpec().contains(Spec.DATA_RACE) ? new DataRaceFoundResult((IElement)icfgLocation, this.mPluginName, this.mServices.getBacktranslationService(), iProgramExecution) : new CounterExampleResult((IElement)icfgLocation, this.mPluginName, this.mServices.getBacktranslationService(), iProgramExecution);
        this.mReportFunction.accept(icfgLocation, (IResult)object);
    }

    private void reportLimitResult(IcfgLocation icfgLocation, CegarLoopLocalResult<L> cegarLoopLocalResult) {
        IResult iResult = this.constructLimitResult(this.mServices, cegarLoopLocalResult, icfgLocation);
        this.mReportFunction.accept(icfgLocation, iResult);
    }

    private void reportUnknownResult(List<UnprovabilityReason> list, IcfgLocation icfgLocation, IProgramExecution<L, Term> iProgramExecution) {
        if (list.isEmpty()) {
            this.mReportFunction.accept(icfgLocation, (IResult)new NotAnalyzedResult(this.mPluginId, (IElement)icfgLocation));
        } else {
            this.reportUnproveableResult(icfgLocation, iProgramExecution, list);
        }
    }

    private void reportUnproveableResult(IcfgLocation icfgLocation, IProgramExecution<L, Term> iProgramExecution, List<UnprovabilityReason> list) {
        assert (iProgramExecution == null || icfgLocation == this.getErrorPP(iProgramExecution));
        UnprovableResult unprovableResult = new UnprovableResult(this.mPluginName, (IElement)icfgLocation, this.mServices.getBacktranslationService(), iProgramExecution, list);
        this.mReportFunction.accept(icfgLocation, (IResult)unprovableResult);
    }

    private IResult constructLimitResult(IUltimateServiceProvider iUltimateServiceProvider, CegarLoopLocalResult<L> cegarLoopLocalResult, IcfgLocation icfgLocation) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to prove that ");
        stringBuilder.append(Check.getAnnotation((IElement)icfgLocation).getPositiveMessage());
        if (icfgLocation instanceof BoogieIcfgLocation) {
            object = ((BoogieIcfgLocation)icfgLocation).getBoogieASTNode().getLocation();
            stringBuilder.append(" (line ").append(object.getStartLine()).append(").");
        }
        if (cegarLoopLocalResult.getRunningTaskStackProvider() != null) {
            stringBuilder.append(" Cancelled ").append(cegarLoopLocalResult.getRunningTaskStackProvider().printRunningTaskMessage());
        }
        Object object2 = (object = cegarLoopLocalResult.getResult()) == AbstractCegarLoop.Result.TIMEOUT ? new TimeoutResultAtElement((IElement)icfgLocation, this.mPluginName, iUltimateServiceProvider.getBacktranslationService(), stringBuilder.toString()) : new UserSpecifiedLimitReachedResultAtElement(((Enum)object).toString(), (IElement)icfgLocation, this.mPluginName, iUltimateServiceProvider.getBacktranslationService(), cegarLoopLocalResult.getProgramExecution(), stringBuilder.toString());
        return object2;
    }

    private boolean isAngelicallySafe(IProgramExecution<L, Term> iProgramExecution) {
        if (iProgramExecution instanceof IcfgAngelicProgramExecution) {
            return !((IcfgAngelicProgramExecution)iProgramExecution).getAngelicStatus();
        }
        return false;
    }

    private IcfgLocation getErrorPP(IProgramExecution<L, Term> iProgramExecution) {
        int n = iProgramExecution.getLength() - 1;
        IIcfgTransition iIcfgTransition = (IIcfgTransition)iProgramExecution.getTraceElement(n).getTraceElement();
        return iIcfgTransition.getTarget();
    }
}

