/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwaDd;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirect;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirectBi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateXsimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.QuotientNwaConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.ASimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.NwaSimulationUtil;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.GameFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.GameAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.GameAutomatonToGameGraphTransformer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.ISimulationInfoProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.SummaryComputation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.util.HashRelationBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.NestedMapBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionAndMapBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiPredicate;

public abstract class ReduceNwaSimulationBased<LETTER, STATE>
extends AbstractMinimizeNwaDd<LETTER, STATE> {
    private static final boolean DEFAULT_USE_BISIMULATION = false;
    private static final boolean DEFAULT_USE_BISIMULATION_PREPROCESSING = false;
    private static final boolean OMIT_MAX_SAT_FOR_FINITE_AUTOMATA = false;
    private static final boolean USE_FULL_PREPROCESSING = false;
    private final IDoubleDeckerAutomaton<LETTER, STATE> mOperand;
    private final AutomataOperationStatistics mStatistics;

    public ReduceNwaSimulationBased(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, ISimulationInfoProvider<LETTER, STATE> iSimulationInfoProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iDoubleDeckerAutomaton;
        MinimizationBackend minimizationBackend = MinimizationBackend.SIMULATION;
        this.printStartMessage();
        long l = System.currentTimeMillis();
        ISetOfPairs iSetOfPairs = new NwaApproximateSimulation<LETTER, STATE>(automataLibraryServices, iDoubleDeckerAutomaton, iSimulationInfoProvider.mayMergeFinalAndNonFinalStates() ? NwaApproximateXsimulation.SimulationType.ORDINARY : NwaApproximateXsimulation.SimulationType.DIRECT, false).getResult();
        int n = -1;
        long l2 = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        try {
            GameFactory gameFactory = new GameFactory();
            SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex = ReduceNwaSimulationBased.constructUniqueSpoilerWinningSink();
            GameAutomaton<LETTER, STATE> gameAutomaton = new GameAutomaton<LETTER, STATE>(this.mServices, gameFactory, iSetOfPairs, iDoubleDeckerAutomaton, iSimulationInfoProvider, spoilerNwaVertex);
            IDoubleDeckerAutomaton iDoubleDeckerAutomaton2 = new RemoveUnreachable<LETTER, STATE>(this.mServices, gameAutomaton).getResult();
            int n2 = iDoubleDeckerAutomaton2.size();
            SummaryComputation<LETTER, STATE> summaryComputation = new SummaryComputation<LETTER, STATE>(this.mServices, iDoubleDeckerAutomaton2, this.mOperand);
            AGameGraph<LETTER, STATE> aGameGraph = new GameAutomatonToGameGraphTransformer<LETTER, STATE>(this.mServices, iDoubleDeckerAutomaton2, spoilerNwaVertex, this.mOperand, summaryComputation.getGameSummaries()).getResult();
            ParsimoniousSimulation parsimoniousSimulation = new ParsimoniousSimulation(this.mServices.getProgressAwareTimer(), this.mLogger, false, null, null, aGameGraph);
            parsimoniousSimulation.doSimulation();
            long l3 = System.currentTimeMillis() - l;
            assert (NwaSimulationUtil.areNwaSimulationResultsCorrect(aGameGraph, this.mOperand, this.getSimulationType(), iSetOfPairs::containsPair, this.mLogger)) : "The computed simulation results are incorrect.";
            Pair<IDoubleDeckerAutomaton<LETTER, STATE>, MinimizeNwaMaxSat2<LETTER, STATE, ?>> pair = switch (minimizationBackend) {
                case MinimizationBackend.FINITE_AUTOMATON -> this.useFiniteAutomatonBackend(iMinimizationStateFactory, iDoubleDeckerAutomaton, iSimulationInfoProvider, aGameGraph);
                case MinimizationBackend.BISIMULATION -> this.useBisimulationBackend(iMinimizationStateFactory, iDoubleDeckerAutomaton, iSimulationInfoProvider, aGameGraph);
                case MinimizationBackend.SIMULATION -> this.useSimulationBackend(iMinimizationStateFactory, iDoubleDeckerAutomaton, iSimulationInfoProvider, aGameGraph);
                default -> throw new IllegalArgumentException("Unknown backend type: " + String.valueOf((Object)minimizationBackend));
            };
            IDoubleDeckerAutomaton iDoubleDeckerAutomaton3 = (IDoubleDeckerAutomaton)pair.getFirst();
            super.directResultConstruction(iDoubleDeckerAutomaton3);
            parsimoniousSimulation.triggerComputationOfPerformanceData(iDoubleDeckerAutomaton3);
            parsimoniousSimulation.getSimulationPerformance();
            NwaSimulationUtil.retrieveGeneralNwaAutomataPerformance(parsimoniousSimulation.getSimulationPerformance(), this.mOperand, iDoubleDeckerAutomaton3, this.mServices);
            this.mStatistics = this.collectStatistics(iSetOfPairs, n, n2, aGameGraph, parsimoniousSimulation, pair, l2, l3);
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            if (iSetOfPairs instanceof PartitionBackedSetOfPairs) {
                Object object = ((PartitionBackedSetOfPairs)iSetOfPairs).getRelation();
                RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), NestedWordAutomataUtils.generateGenericMinimizationRunningTaskDescription(this.getOperationName(), this.mOperand, object));
                automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
            } else {
                this.addGenericRunningTaskInfo(automataOperationCanceledException);
            }
            throw automataOperationCanceledException;
        }
        this.printExitMessage();
    }

    private AutomataOperationStatistics collectStatistics(ISetOfPairs<STATE, ?> iSetOfPairs, int n, int n2, AGameGraph<LETTER, STATE> aGameGraph, ParsimoniousSimulation parsimoniousSimulation, Pair<IDoubleDeckerAutomaton<LETTER, STATE>, MinimizeNwaMaxSat2<LETTER, STATE, ?>> pair, long l, long l2) {
        Object object;
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        automataOperationStatistics.addKeyValuePair(StatisticsType.TIME_PREPROCESSING, l);
        automataOperationStatistics.addKeyValuePair(StatisticsType.TIME_SIMULATION, l2);
        if (iSetOfPairs instanceof PartitionBackedSetOfPairs) {
            object = ((PartitionBackedSetOfPairs)iSetOfPairs).getRelation();
            automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_INITIAL_PAIRS, new PartitionAndMapBackedSetOfPairs(object).getOrConstructPartitionSizeInformation().getNumberOfPairs());
            automataOperationStatistics.addKeyValuePair(StatisticsType.SIZE_INITIAL_PARTITION, object.size());
            automataOperationStatistics.addKeyValuePair(StatisticsType.SIZE_MAXIMAL_INITIAL_BLOCK, n);
        } else {
            long l3 = 0L;
            Iterator iterator = iSetOfPairs.iterator();
            while (iterator.hasNext()) {
                ++l3;
                iterator.next();
            }
            automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_INITIAL_PAIRS, l3);
        }
        automataOperationStatistics.addKeyValuePair(StatisticsType.SIZE_GAME_AUTOMATON, n2);
        automataOperationStatistics.addKeyValuePair(StatisticsType.SIZE_GAME_GRAPH, aGameGraph.getSize());
        object = (MinimizeNwaMaxSat2)pair.getSecond();
        if (object != null) {
            ((MinimizeNwaMaxSat2)object).addStatistics(automataOperationStatistics);
        }
        return automataOperationStatistics;
    }

    private static <LETTER, STATE> SpoilerNwaVertex<LETTER, STATE> constructUniqueSpoilerWinningSink() {
        return new SpoilerNwaVertex(1, false, null, null, new SpoilerWinningSink(null));
    }

    private UnionFind<STATE> computeEquivalenceRelation(HashRelation<STATE, STATE> hashRelation, Set<STATE> set) {
        UnionFind unionFind = new UnionFind();
        for (Object object : set) {
            unionFind.makeEquivalenceClass(object);
        }
        for (Object object : hashRelation.getDomain()) {
            for (Object e : hashRelation.getImage(object)) {
                if (!hashRelation.containsPair(e, object)) continue;
                Object object2 = unionFind.find(object);
                Object object3 = unionFind.find(e);
                unionFind.union(object2, object3);
            }
        }
        return unionFind;
    }

    private void readoutSimulationRelation(AGameGraph<LETTER, STATE> aGameGraph, ISimulationInfoProvider<LETTER, STATE> iSimulationInfoProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, ISetOfPairs<STATE, ?> iSetOfPairs) {
        for (SpoilerVertex spoilerVertex : aGameGraph.getSpoilerVertices()) {
            if (this.isAuxiliaryVertex(spoilerVertex) || !iSimulationInfoProvider.isSimulationInformationProvider(spoilerVertex, iNwaOutgoingLetterAndTransitionProvider) || spoilerVertex.getPM(null, aGameGraph.getGlobalInfinity()) >= aGameGraph.getGlobalInfinity()) continue;
            iSetOfPairs.addPair(spoilerVertex.getQ0(), spoilerVertex.getQ1());
        }
    }

    private boolean isAuxiliaryVertex(SpoilerVertex<LETTER, STATE> spoilerVertex) {
        return spoilerVertex.getQ0() == null || spoilerVertex.getQ1() == null;
    }

    private UnionFind<STATE> simulationToEquivalenceRelation(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, ISimulationInfoProvider<LETTER, STATE> iSimulationInfoProvider, AGameGraph<LETTER, STATE> aGameGraph) {
        HashRelationBackedSetOfPairs hashRelationBackedSetOfPairs = new HashRelationBackedSetOfPairs();
        this.readoutSimulationRelation(aGameGraph, iSimulationInfoProvider, iDoubleDeckerAutomaton, hashRelationBackedSetOfPairs);
        return this.computeEquivalenceRelation(hashRelationBackedSetOfPairs.getRelation(), iDoubleDeckerAutomaton.getStates());
    }

    private Pair<IDoubleDeckerAutomaton<LETTER, STATE>, MinimizeNwaMaxSat2<LETTER, STATE, ?>> useFiniteAutomatonBackend(IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, ISimulationInfoProvider<LETTER, STATE> iSimulationInfoProvider, AGameGraph<LETTER, STATE> aGameGraph) {
        UnionFind<STATE> unionFind = this.simulationToEquivalenceRelation(iDoubleDeckerAutomaton, iSimulationInfoProvider, aGameGraph);
        QuotientNwaConstructor<LETTER, STATE> quotientNwaConstructor = new QuotientNwaConstructor<LETTER, STATE>(this.mServices, iMinimizationStateFactory, this.mOperand, unionFind, false);
        return new Pair((Object)((IDoubleDeckerAutomaton)quotientNwaConstructor.getResult()), null);
    }

    private Pair<IDoubleDeckerAutomaton<LETTER, STATE>, MinimizeNwaMaxSat2<LETTER, STATE, ?>> useBisimulationBackend(IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, ISimulationInfoProvider<LETTER, STATE> iSimulationInfoProvider, AGameGraph<LETTER, STATE> aGameGraph) throws AutomataOperationCanceledException {
        UnionFind<STATE> unionFind = this.simulationToEquivalenceRelation(iDoubleDeckerAutomaton, iSimulationInfoProvider, aGameGraph);
        MinimizeNwaMaxSat2.Settings<STATE> settings = this.getPmaxSatSettings(iSimulationInfoProvider);
        MinimizeNwaPmaxSatDirectBi<LETTER, STATE> minimizeNwaPmaxSatDirectBi = new MinimizeNwaPmaxSatDirectBi<LETTER, STATE>(this.mServices, iMinimizationStateFactory, this.mOperand, new PartitionBackedSetOfPairs(unionFind.getAllEquivalenceClasses()), settings);
        return new Pair((Object)minimizeNwaPmaxSatDirectBi.getResult(), minimizeNwaPmaxSatDirectBi);
    }

    private Pair<IDoubleDeckerAutomaton<LETTER, STATE>, MinimizeNwaMaxSat2<LETTER, STATE, ?>> useSimulationBackend(IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, ISimulationInfoProvider<LETTER, STATE> iSimulationInfoProvider, AGameGraph<LETTER, STATE> aGameGraph) throws AutomataOperationCanceledException {
        NestedMapBackedSetOfPairs nestedMapBackedSetOfPairs = new NestedMapBackedSetOfPairs();
        this.readoutSimulationRelation(aGameGraph, iSimulationInfoProvider, iDoubleDeckerAutomaton, nestedMapBackedSetOfPairs);
        MinimizeNwaMaxSat2.Settings<STATE> settings = this.getPmaxSatSettings(iSimulationInfoProvider);
        MinimizeNwaPmaxSatDirect<LETTER, STATE> minimizeNwaPmaxSatDirect = new MinimizeNwaPmaxSatDirect<LETTER, STATE>(this.mServices, iMinimizationStateFactory, this.mOperand, nestedMapBackedSetOfPairs.getRelation(), settings);
        return new Pair((Object)minimizeNwaPmaxSatDirect.getResult(), minimizeNwaPmaxSatDirect);
    }

    private MinimizeNwaMaxSat2.Settings<STATE> getPmaxSatSettings(ISimulationInfoProvider<LETTER, STATE> iSimulationInfoProvider) {
        boolean bl = iSimulationInfoProvider.mayMergeFinalAndNonFinalStates();
        BiPredicate biPredicate = bl ? new MinimizeNwaMaxSat2.RelationBackedBiPredicate(new HashRelationBackedSetOfPairs()) : new MinimizeNwaMaxSat2.TrueBiPredicate();
        MinimizeNwaMaxSat2.Settings settings = new MinimizeNwaMaxSat2.Settings().setFinalNonfinalConstraintPredicate(biPredicate);
        return settings;
    }

    @Override
    protected IDoubleDeckerAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    protected abstract SimulationOrMinimizationType getSimulationType();

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = super.getAutomataOperationStatistics();
        automataOperationStatistics.addAllStatistics(this.mStatistics);
        return automataOperationStatistics;
    }

    private static enum MinimizationBackend {
        FINITE_AUTOMATON,
        BISIMULATION,
        SIMULATION;

    }

    private class ParsimoniousSimulation
    extends ASimulation<LETTER, STATE> {
        private final AGameGraph<LETTER, STATE> mGameGraph;

        public ParsimoniousSimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, SimulationOrMinimizationType simulationOrMinimizationType, AGameGraph<LETTER, STATE> aGameGraph) throws AutomataOperationCanceledException {
            super(iProgressAwareTimer, iLogger, bl, iStateFactory, simulationOrMinimizationType);
            this.mGameGraph = aGameGraph;
        }

        public void triggerComputationOfPerformanceData(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
            this.mResult = iDoubleDeckerAutomaton;
            super.retrieveGeneralAutomataPerformance();
        }

        @Override
        protected AGameGraph<LETTER, STATE> getGameGraph() {
            return this.mGameGraph;
        }
    }
}

