/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqtotest.testgenerator;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseLabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.models.ModifiableLabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.AuxVarGen;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.ReqGraphAnnotation;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.ReqGraphOracleAnnotation;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.Req2TestReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.ReqGuardGraph;
import de.uni_freiburg.informatik.ultimate.reqtotest.testgenerator.DirectTriggerDependency;
import de.uni_freiburg.informatik.ultimate.reqtotest.testgenerator.SystemState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestGeneratorResult
implements IResult {
    private final List<SystemState> mTestStates;
    private final List<List<ReqGraphAnnotation>> mStepsAnnotations;
    private final List<Map<ReqGuardGraph, DirectTriggerDependency>> mDependenciesGraphNodes = new ArrayList<Map<ReqGuardGraph, DirectTriggerDependency>>();
    private final AuxVarGen mAuxVarGen;
    private final Req2TestReqSymbolTable mReqSymbolTable;
    private final ReqGraphOracleAnnotation mOracleAnnotation;

    public TestGeneratorResult(ILogger iLogger, List<SystemState> list, List<List<ReqGraphAnnotation>> list2, ReqGraphOracleAnnotation reqGraphOracleAnnotation, Req2TestReqSymbolTable req2TestReqSymbolTable, AuxVarGen auxVarGen) {
        this.mTestStates = list;
        this.mStepsAnnotations = list2;
        this.mAuxVarGen = auxVarGen;
        this.mReqSymbolTable = req2TestReqSymbolTable;
        this.mOracleAnnotation = reqGraphOracleAnnotation;
        this.calculateDependencyGraph();
    }

    private void calculateDependencyGraph() {
        Map<ReqGuardGraph, DirectTriggerDependency> map = new HashMap<ReqGuardGraph, DirectTriggerDependency>();
        for (List<ReqGraphAnnotation> list : this.mStepsAnnotations) {
            Map<ReqGuardGraph, DirectTriggerDependency> map2 = this.calculateDependencyGraphStep(list, map);
            this.mDependenciesGraphNodes.add(map2);
            map = map2;
        }
    }

    private Map<ReqGuardGraph, DirectTriggerDependency> calculateDependencyGraphStep(List<ReqGraphAnnotation> list, Map<ReqGuardGraph, DirectTriggerDependency> map) {
        ModifiableLabeledEdgesMultigraph modifiableLabeledEdgesMultigraph;
        HashMap<ReqGuardGraph, DirectTriggerDependency> hashMap = new HashMap<ReqGuardGraph, DirectTriggerDependency>();
        for (ReqGraphAnnotation reqGraphAnnotation : list) {
            modifiableLabeledEdgesMultigraph = reqGraphAnnotation.getRequirementAut();
            DirectTriggerDependency directTriggerDependency = new DirectTriggerDependency((ReqGuardGraph)modifiableLabeledEdgesMultigraph);
            hashMap.put((ReqGuardGraph)modifiableLabeledEdgesMultigraph, directTriggerDependency);
        }
        for (ReqGraphAnnotation reqGraphAnnotation : list) {
            modifiableLabeledEdgesMultigraph = (DirectTriggerDependency)((Object)hashMap.get((Object)reqGraphAnnotation.getRequirementAut()));
            this.connectEffectDependencies((DirectTriggerDependency)modifiableLabeledEdgesMultigraph, hashMap, reqGraphAnnotation, list);
            this.connectInputDependencies((DirectTriggerDependency)modifiableLabeledEdgesMultigraph, reqGraphAnnotation);
            this.connectOutput((DirectTriggerDependency)modifiableLabeledEdgesMultigraph, reqGraphAnnotation);
            this.connectInterStepDependency((DirectTriggerDependency)modifiableLabeledEdgesMultigraph, map, reqGraphAnnotation);
        }
        return hashMap;
    }

    private void connectInterStepDependency(DirectTriggerDependency directTriggerDependency, Map<ReqGuardGraph, DirectTriggerDependency> map, ReqGraphAnnotation reqGraphAnnotation) {
        if (reqGraphAnnotation.getSourceLocation().getLabel() > 0) {
            DirectTriggerDependency directTriggerDependency2 = map.get((Object)reqGraphAnnotation.getRequirementAut());
            directTriggerDependency.connectOutgoing(directTriggerDependency2, new HashSet<TermVariable>(Arrays.asList(reqGraphAnnotation.getLabel().getClockGuard().getFreeVars())));
        }
    }

    private void connectEffectDependencies(DirectTriggerDependency directTriggerDependency, Map<ReqGuardGraph, DirectTriggerDependency> map, ReqGraphAnnotation reqGraphAnnotation, List<ReqGraphAnnotation> list) {
        Set set = SmtUtils.getFreeVars(Arrays.asList(reqGraphAnnotation.getGuard()));
        for (ReqGraphAnnotation reqGraphAnnotation2 : list) {
            if (reqGraphAnnotation2 == reqGraphAnnotation || !reqGraphAnnotation2.getLabel().isEffect()) continue;
            Set set2 = SmtUtils.getFreeVars(Arrays.asList(reqGraphAnnotation2.getGuard()));
            set2.retainAll(this.mAuxVarGen.getEffectVariables(reqGraphAnnotation2.getRequirementAut()));
            HashSet hashSet = new HashSet(set);
            hashSet.retainAll(set2);
            if (hashSet.size() <= 0) continue;
            DirectTriggerDependency directTriggerDependency2 = map.get((Object)reqGraphAnnotation2.getRequirementAut());
            directTriggerDependency.connectOutgoing(directTriggerDependency2, hashSet);
        }
    }

    private void connectInputDependencies(DirectTriggerDependency directTriggerDependency, ReqGraphAnnotation reqGraphAnnotation) {
        Set set = SmtUtils.getFreeVars(Arrays.asList(reqGraphAnnotation.getGuard()));
        Set<String> set2 = this.mReqSymbolTable.getInputVars();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (TermVariable termVariable : set) {
            if (!set2.contains(termVariable.getName())) continue;
            hashSet.add(termVariable);
        }
        directTriggerDependency.addInputs(hashSet);
    }

    private void connectOutput(DirectTriggerDependency directTriggerDependency, ReqGraphAnnotation reqGraphAnnotation) {
        if (!reqGraphAnnotation.getLabel().isEffect()) {
            return;
        }
        Set set = SmtUtils.getFreeVars(Arrays.asList(reqGraphAnnotation.getGuard()));
        Collection<TermVariable> collection = this.mAuxVarGen.getEffectVariables(reqGraphAnnotation.getRequirementAut());
        Set<String> set2 = this.mReqSymbolTable.getOutputVars();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (TermVariable termVariable : set) {
            if (!set2.contains(termVariable.getName()) || !collection.contains(termVariable)) continue;
            hashSet.add(termVariable);
        }
        directTriggerDependency.addOutputs(hashSet);
    }

    public String getPlugin() {
        return null;
    }

    public String getShortDescription() {
        return this.toString();
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Test Vector:" + System.getProperty("line.separator"));
        Set<DirectTriggerDependency> set = this.getOracleReverseWalkTestPlan();
        stringBuilder.append(this.getStepsTestPlan(set));
        return stringBuilder.toString();
    }

    private Set<DirectTriggerDependency> getOracleReverseWalkTestPlan() {
        Set<DirectTriggerDependency> set = this.getOracleDependencyNodes();
        Set<DirectTriggerDependency> set2 = this.reverseTraverseDependencyGraph(set);
        return set2;
    }

    private Set<DirectTriggerDependency> getOracleDependencyNodes() {
        Map<ReqGuardGraph, DirectTriggerDependency> map = this.mDependenciesGraphNodes.get(this.mDependenciesGraphNodes.size() - 1);
        HashSet<DirectTriggerDependency> hashSet = new HashSet<DirectTriggerDependency>();
        for (DirectTriggerDependency directTriggerDependency : map.values()) {
            if (Collections.disjoint(directTriggerDependency.getOutputs(), this.mOracleAnnotation.getOracleVars())) continue;
            hashSet.add(directTriggerDependency);
        }
        return hashSet;
    }

    private Set<DirectTriggerDependency> reverseTraverseDependencyGraph(Set<DirectTriggerDependency> set) {
        HashSet<DirectTriggerDependency> hashSet = new HashSet<DirectTriggerDependency>();
        LinkedList<DirectTriggerDependency> linkedList = new LinkedList<DirectTriggerDependency>(set);
        while (!linkedList.isEmpty()) {
            DirectTriggerDependency directTriggerDependency = (DirectTriggerDependency)((Object)linkedList.poll());
            hashSet.add(directTriggerDependency);
            for (DirectTriggerDependency directTriggerDependency2 : directTriggerDependency.getOutgoingNodes()) {
                if (linkedList.contains((Object)directTriggerDependency2) || hashSet.contains((Object)directTriggerDependency2)) continue;
                linkedList.add(directTriggerDependency2);
            }
        }
        return hashSet;
    }

    private String getStepsTestPlan(Set<DirectTriggerDependency> set) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.mDependenciesGraphNodes.size()) {
            SystemState systemState = this.mTestStates.get(n);
            float f = this.mTestStates.get(n).getTimeStep();
            stringBuilder.append(System.getProperty("line.separator"));
            Map<ReqGuardGraph, DirectTriggerDependency> map = this.mDependenciesGraphNodes.get(n);
            stringBuilder.append(this.getStepTestPlan(map, systemState, set, f));
            ++n;
        }
        stringBuilder.append("------------------------------------------------------------------------------------------");
        return stringBuilder.toString();
    }

    private String getStepTestPlan(Map<ReqGuardGraph, DirectTriggerDependency> map, SystemState systemState, Set<DirectTriggerDependency> set, float f) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append("Set inputs:");
        stringBuilder.append(System.getProperty("line.separator"));
        for (DirectTriggerDependency directTriggerDependency : map.values()) {
            if (!set.contains((Object)directTriggerDependency)) continue;
            if (directTriggerDependency.getInputs().size() > 0) {
                stringBuilder.append("\t");
                stringBuilder.append(systemState.getVarSetToValueSet(directTriggerDependency.getInputs()));
                stringBuilder.append("\t\t(" + directTriggerDependency.getReqAut().getName() + ") ");
                stringBuilder.append(System.getProperty("line.separator"));
            }
            if (directTriggerDependency.getOutputs().size() <= 0) continue;
            stringBuilder2.append("\t");
            stringBuilder2.append(systemState.getVarSetToValueSet(directTriggerDependency.getOutputs()));
            stringBuilder2.append("\t\t(" + directTriggerDependency.getReqAut().getName() + ") ");
            stringBuilder2.append(System.getProperty("line.separator"));
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("Expect output:" + System.getProperty("line.separator"));
            stringBuilder2.append("Wait exactly  " + Float.toString(f) + System.getProperty("line.separator"));
            return stringBuilder.append((CharSequence)stringBuilder2).toString();
        }
        stringBuilder.append("Wait exactly  " + Float.toString(f));
        stringBuilder.append(System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    private String getStepTestPlanGraphed(Map<ReqGuardGraph, DirectTriggerDependency> map, SystemState systemState, Set<DirectTriggerDependency> set, double d) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        for (ReqGuardGraph reqGuardGraph : map.keySet()) {
            DirectTriggerDependency directTriggerDependency = map.get((Object)reqGuardGraph);
            if (!set.contains((Object)directTriggerDependency)) continue;
            if (directTriggerDependency.getInputs().size() > 0) {
                stringBuilder.append("Input ---------- (");
                stringBuilder.append(systemState.getVarSetToValueSet(directTriggerDependency.getInputs()));
                stringBuilder.append(") ----------> ");
                stringBuilder.append(directTriggerDependency.getReqAut().getName());
                stringBuilder.append(System.getProperty("line.separator"));
            }
            for (DirectTriggerDependency directTriggerDependency2 : directTriggerDependency.getOutgoingNodes()) {
                if (((Set)directTriggerDependency.getOutgoingEdgeLabel((BaseLabeledEdgesMultigraph)directTriggerDependency2)).size() <= 0) continue;
                stringBuilder2.append(directTriggerDependency2.getReqAut().getName());
                stringBuilder2.append("---------- (");
                stringBuilder2.append(systemState.getVarSetToValueSet((Set)directTriggerDependency.getOutgoingEdgeLabel((BaseLabeledEdgesMultigraph)directTriggerDependency2)));
                stringBuilder2.append(") ----------> ");
                stringBuilder2.append(directTriggerDependency.getReqAut().getName());
                stringBuilder2.append(System.getProperty("line.separator"));
            }
            if (directTriggerDependency.getOutputs().size() <= 0) continue;
            stringBuilder3.append(directTriggerDependency.getReqAut().getName());
            stringBuilder3.append("---------- (");
            stringBuilder3.append(systemState.getVarSetToValueSet(directTriggerDependency.getOutputs()));
            stringBuilder3.append(") ----------> Output");
            stringBuilder3.append(System.getProperty("line.separator"));
        }
        return "Wait " + Double.toString(d) + ":\n" + stringBuilder.append((CharSequence)stringBuilder2).append((CharSequence)stringBuilder3).toString();
    }

    public String toString() {
        return String.format("Found Test for: %s", this.mOracleAnnotation.getOracleVars());
    }
}

