/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.emptinesscheck;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AnnotatedProgramPoint;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.DummyCodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.EmptyStackSymbol;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.emptinesscheck.IEmptinessCheck;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class BFSEmptinessCheck
implements IEmptinessCheck {
    private static final int BAD_NESTING_RELATION_INIT = -7;
    private ArrayDeque<AppDoubleDecker> mOpenNodes;
    private HashSet<AppDoubleDecker> mVisitedNodes;
    private HashMap<AnnotatedProgramPoint, HashSet<AnnotatedProgramPoint>> mSummaryEdges;
    private HashMap<Pair<AnnotatedProgramPoint, AnnotatedProgramPoint>, AppDoubleDecker> mSummaryEdgeToReturnSucc;
    private final ILogger mLogger;

    public BFSEmptinessCheck(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    @Override
    public NestedRun<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint> checkForEmptiness(AnnotatedProgramPoint annotatedProgramPoint) {
        this.mOpenNodes = new ArrayDeque();
        this.mVisitedNodes = new HashSet();
        this.mSummaryEdges = new HashMap();
        this.mSummaryEdgeToReturnSucc = new HashMap();
        EmptyStackSymbol emptyStackSymbol = new EmptyStackSymbol();
        this.mOpenNodes.add(new AppDoubleDecker(annotatedProgramPoint, emptyStackSymbol, new Stack(), new Stack<AnnotatedProgramPoint>()));
        Pair<AnnotatedProgramPoint[], NestedWord<IIcfgTransition<IcfgLocation>>> pair = null;
        while (!this.mOpenNodes.isEmpty() && pair == null) {
            AppDoubleDecker appDoubleDecker;
            Iterator iterator;
            Object object2;
            AppDoubleDecker appDoubleDecker2 = this.mOpenNodes.pollFirst();
            this.mVisitedNodes.add(appDoubleDecker2);
            for (Object object2 : appDoubleDecker2.mTop.getOutgoingNodes()) {
                iterator = null;
                if (iterator instanceof IIcfgSummaryTransition) continue;
                appDoubleDecker = null;
                if (!(iterator instanceof IIcfgCallTransition) && !(iterator instanceof IIcfgReturnTransition)) {
                    appDoubleDecker = new AppDoubleDecker((AnnotatedProgramPoint)((Object)object2), appDoubleDecker2.mBot, (Stack)appDoubleDecker2.mCallStack.clone(), (Stack)appDoubleDecker2.mCallPredStack.clone());
                    if (pair != null) continue;
                    pair = this.openNewNode(appDoubleDecker2, (AnnotatedProgramPoint)((Object)object2), (IIcfgTransition<IcfgLocation>)iterator, appDoubleDecker);
                    continue;
                }
                if (iterator instanceof IIcfgCallTransition) {
                    appDoubleDecker = new AppDoubleDecker((AnnotatedProgramPoint)((Object)object2), appDoubleDecker2.mTop, (Stack)appDoubleDecker2.mCallStack.clone(), (Stack)appDoubleDecker2.mCallPredStack.clone());
                    appDoubleDecker.mCallStack.add((IIcfgCallTransition)iterator);
                    appDoubleDecker.mCallPredStack.add(appDoubleDecker2.mBot);
                    if (pair != null) continue;
                    pair = this.openNewNode(appDoubleDecker2, (AnnotatedProgramPoint)((Object)object2), (IIcfgTransition<IcfgLocation>)iterator, appDoubleDecker);
                    continue;
                }
                if (!(iterator instanceof IIcfgReturnTransition)) continue;
                Stack stack = (Stack)appDoubleDecker2.mCallStack.clone();
                Stack stack2 = (Stack)appDoubleDecker2.mCallPredStack.clone();
                IIcfgCallTransition iIcfgCallTransition = (IIcfgCallTransition)stack.pop();
                AnnotatedProgramPoint annotatedProgramPoint2 = (AnnotatedProgramPoint)((Object)stack2.pop());
                if (!((IIcfgReturnTransition)iterator).getCorrespondingCall().equals(iIcfgCallTransition)) continue;
                appDoubleDecker = new AppDoubleDecker((AnnotatedProgramPoint)((Object)object2), annotatedProgramPoint2, stack, stack2);
                this.addSummaryEdge(appDoubleDecker2.mBot, (AnnotatedProgramPoint)((Object)object2));
                Pair pair2 = new Pair((Object)appDoubleDecker2.mBot, object2);
                this.mSummaryEdgeToReturnSucc.put((Pair<AnnotatedProgramPoint, AnnotatedProgramPoint>)pair2, appDoubleDecker);
                if (pair != null) continue;
                pair = this.openNewNode(appDoubleDecker2, (AnnotatedProgramPoint)((Object)object2), (IIcfgTransition<IcfgLocation>)iterator, appDoubleDecker);
            }
            object2 = this.mSummaryEdges.get((Object)appDoubleDecker2.mTop);
            if (object2 == null) continue;
            iterator = ((HashSet)object2).iterator();
            while (iterator.hasNext()) {
                Object object3 = (AnnotatedProgramPoint)((Object)iterator.next());
                appDoubleDecker = new AppDoubleDecker((AnnotatedProgramPoint)((Object)object3), appDoubleDecker2.mBot, (Stack)appDoubleDecker2.mCallStack.clone(), (Stack)appDoubleDecker2.mCallPredStack.clone());
                if (pair != null) continue;
                pair = this.openNewNode(appDoubleDecker2, (AnnotatedProgramPoint)((Object)object3), (IIcfgTransition<IcfgLocation>)new DummyCodeBlock(), appDoubleDecker);
            }
        }
        return pair == null ? null : new NestedRun((NestedWord)pair.getSecond(), new ArrayList<AnnotatedProgramPoint>(Arrays.asList((AnnotatedProgramPoint[])pair.getFirst())));
    }

    private void addSummaryEdge(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2) {
        HashSet<AnnotatedProgramPoint> hashSet = this.mSummaryEdges.get((Object)annotatedProgramPoint);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        hashSet.add(annotatedProgramPoint2);
        this.mSummaryEdges.put(annotatedProgramPoint, hashSet);
    }

    private Pair<AnnotatedProgramPoint[], NestedWord<IIcfgTransition<IcfgLocation>>> openNewNode(AppDoubleDecker appDoubleDecker, AnnotatedProgramPoint annotatedProgramPoint, IIcfgTransition<IcfgLocation> iIcfgTransition, AppDoubleDecker appDoubleDecker2) {
        if (!this.mVisitedNodes.contains(appDoubleDecker2)) {
            AddEdge addEdge;
            appDoubleDecker2.mInEdge = addEdge = new AddEdge(appDoubleDecker, appDoubleDecker2, iIcfgTransition);
            appDoubleDecker.mOutEdges.add(addEdge);
            appDoubleDecker2.setPathToRoot();
            if (annotatedProgramPoint.isErrorLocation()) {
                return this.reconstructPath(appDoubleDecker2);
            }
            this.mOpenNodes.add(appDoubleDecker2);
        }
        return null;
    }

    private Pair<AnnotatedProgramPoint[], NestedWord<IIcfgTransition<IcfgLocation>>> reconstructPath(AppDoubleDecker appDoubleDecker) {
        ArrayDeque arrayDeque = new ArrayDeque();
        ArrayDeque arrayDeque2 = new ArrayDeque();
        AppDoubleDecker appDoubleDecker2 = appDoubleDecker;
        AddEdge addEdge = appDoubleDecker.mInEdge;
        while (addEdge != null) {
            arrayDeque.addFirst(appDoubleDecker2.mTop);
            arrayDeque2.addFirst(addEdge.mLabel);
            appDoubleDecker2 = addEdge.mSource;
            addEdge = appDoubleDecker2.mInEdge;
        }
        arrayDeque.addFirst(appDoubleDecker2.mTop);
        Pair<ArrayDeque<AnnotatedProgramPoint>, ArrayDeque<IIcfgTransition<IcfgLocation>>> pair = this.expandSummaries(arrayDeque2, arrayDeque);
        arrayDeque = (ArrayDeque)pair.getFirst();
        arrayDeque2 = (ArrayDeque)pair.getSecond();
        Object[] objectArray = new IIcfgTransition[arrayDeque2.size()];
        arrayDeque2.toArray(objectArray);
        NestedWord nestedWord = new NestedWord(objectArray, BFSEmptinessCheck.computeNestingRelation(objectArray));
        AnnotatedProgramPoint[] annotatedProgramPointArray = new AnnotatedProgramPoint[arrayDeque.size()];
        arrayDeque.toArray(annotatedProgramPointArray);
        return new Pair((Object)annotatedProgramPointArray, (Object)nestedWord);
    }

    private Pair<ArrayDeque<AnnotatedProgramPoint>, ArrayDeque<IIcfgTransition<IcfgLocation>>> expandSummaries(ArrayDeque<IIcfgTransition<IcfgLocation>> arrayDeque, ArrayDeque<AnnotatedProgramPoint> arrayDeque2) {
        ArrayDeque<Object> arrayDeque3 = arrayDeque;
        ArrayDeque<AnnotatedProgramPoint> arrayDeque4 = arrayDeque2;
        boolean bl = true;
        while (bl) {
            bl = false;
            ArrayDeque<Object> arrayDeque5 = new ArrayDeque<Object>();
            ArrayDeque<AnnotatedProgramPoint> arrayDeque6 = new ArrayDeque<AnnotatedProgramPoint>();
            Iterator<AnnotatedProgramPoint> iterator = arrayDeque4.iterator();
            AnnotatedProgramPoint annotatedProgramPoint = iterator.next();
            for (IIcfgTransition<IcfgLocation> iIcfgTransition : arrayDeque3) {
                AnnotatedProgramPoint annotatedProgramPoint2 = annotatedProgramPoint;
                arrayDeque6.add(annotatedProgramPoint2);
                arrayDeque5.add(iIcfgTransition);
                annotatedProgramPoint = iterator.next();
                if (!(iIcfgTransition instanceof DummyCodeBlock)) continue;
                assert (this.mSummaryEdges.get((Object)annotatedProgramPoint2).contains((Object)annotatedProgramPoint));
                arrayDeque5.removeLast();
                Pair pair = new Pair((Object)annotatedProgramPoint2, (Object)annotatedProgramPoint);
                AppDoubleDecker appDoubleDecker = this.mSummaryEdgeToReturnSucc.get(pair);
                LinkedList<IIcfgTransition<IcfgLocation>> linkedList = new LinkedList<IIcfgTransition<IcfgLocation>>();
                LinkedList<AnnotatedProgramPoint> linkedList2 = new LinkedList<AnnotatedProgramPoint>();
                while (!(appDoubleDecker.mInEdge.mLabel instanceof IIcfgCallTransition)) {
                    if (appDoubleDecker.mInEdge.mLabel instanceof DummyCodeBlock) {
                        bl = true;
                    }
                    linkedList.add(appDoubleDecker.mInEdge.mLabel);
                    linkedList2.add(appDoubleDecker.mInEdge.mSource.mTop);
                    appDoubleDecker = appDoubleDecker.mInEdge.mSource;
                }
                if (appDoubleDecker.mInEdge.mLabel instanceof DummyCodeBlock) {
                    bl = true;
                }
                linkedList.add(appDoubleDecker.mInEdge.mLabel);
                Collections.reverse(linkedList2);
                Collections.reverse(linkedList);
                arrayDeque6.addAll(linkedList2);
                arrayDeque5.addAll(linkedList);
            }
            arrayDeque6.add(annotatedProgramPoint);
            arrayDeque3 = arrayDeque5;
            arrayDeque4 = arrayDeque6;
        }
        return new Pair(arrayDeque4, arrayDeque3);
    }

    private static int[] computeNestingRelation(IIcfgTransition<IcfgLocation>[] iIcfgTransitionArray) {
        int[] nArray = new int[iIcfgTransitionArray.length];
        Stack<IIcfgCallTransition> stack = new Stack<IIcfgCallTransition>();
        Stack<Integer> stack2 = new Stack<Integer>();
        int n = 0;
        while (n < nArray.length) {
            if (iIcfgTransitionArray[n] instanceof IIcfgCallTransition) {
                nArray[n] = -2;
                stack.push((IIcfgCallTransition)iIcfgTransitionArray[n]);
                stack2.push(n);
            } else if (iIcfgTransitionArray[n] instanceof IIcfgReturnTransition) {
                if (stack2.isEmpty()) {
                    nArray[n] = Integer.MIN_VALUE;
                    break;
                }
                IIcfgCallTransition iIcfgCallTransition = (IIcfgCallTransition)stack.pop();
                if (!((IIcfgReturnTransition)iIcfgTransitionArray[n]).getCorrespondingCall().equals(iIcfgCallTransition)) {
                    return new int[]{-7, n, (Integer)stack2.pop()};
                }
                nArray[n] = (Integer)stack2.pop();
                nArray[nArray[n]] = n;
            } else {
                nArray[n] = -2;
            }
            ++n;
        }
        for (Integer n2 : stack2) {
            nArray[n2.intValue()] = Integer.MAX_VALUE;
        }
        return nArray;
    }

    private static final class AddEdge {
        private final AppDoubleDecker mSource;
        private final AppDoubleDecker mTarget;
        private final IIcfgTransition<IcfgLocation> mLabel;

        public AddEdge(AppDoubleDecker appDoubleDecker, AppDoubleDecker appDoubleDecker2, IIcfgTransition<IcfgLocation> iIcfgTransition) {
            assert (iIcfgTransition != null);
            this.mSource = appDoubleDecker;
            this.mTarget = appDoubleDecker2;
            this.mLabel = iIcfgTransition;
        }

        public String toString() {
            return String.valueOf(this.mSource) + "--" + String.valueOf(this.mLabel) + "-->" + String.valueOf(this.mTarget);
        }
    }

    private static final class AppDoubleDecker {
        private final AnnotatedProgramPoint mTop;
        private final AnnotatedProgramPoint mBot;
        private final Stack<IIcfgCallTransition<?>> mCallStack;
        private final Stack<AnnotatedProgramPoint> mCallPredStack;
        private final ArrayList<AnnotatedProgramPoint> mPathToRoot = new ArrayList();
        private AddEdge mInEdge;
        private final ArrayList<AddEdge> mOutEdges = new ArrayList();

        AppDoubleDecker(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2, Stack<IIcfgCallTransition<?>> stack, Stack<AnnotatedProgramPoint> stack2) {
            this.mTop = annotatedProgramPoint;
            this.mBot = annotatedProgramPoint2;
            this.mCallPredStack = stack2;
            this.mCallStack = stack;
        }

        void setPathToRoot() {
            this.mPathToRoot.addAll(this.mInEdge.mSource.mPathToRoot);
            this.mPathToRoot.add(this.mTop);
        }

        public int hashCode() {
            return HashUtils.hashJenkins((int)((Object)((Object)this.mTop)).hashCode(), (Object)((Object)((Object)this.mBot)).hashCode());
        }

        public boolean equals(Object object) {
            if (object instanceof AppDoubleDecker) {
                return ((Object)((Object)this.mTop)).equals((Object)((AppDoubleDecker)object).mTop) && ((Object)((Object)this.mBot)).equals((Object)((AppDoubleDecker)object).mBot);
            }
            return false;
        }

        public String toString() {
            return "(" + String.valueOf((Object)this.mTop) + "|" + String.valueOf((Object)this.mBot) + ")";
        }
    }
}

