/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class MonolithicImplicationChecker {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mManagedScript;

    public MonolithicImplicationChecker(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mServices = iUltimateServiceProvider;
        this.mManagedScript = managedScript;
    }

    public IncrementalPlicationChecker.Validity checkImplication(IPredicate iPredicate, boolean bl, IPredicate iPredicate2, boolean bl2) {
        return this.checkImplication(iPredicate.getFormula(), iPredicate.getClosedFormula(), bl, iPredicate2.getFormula(), iPredicate2.getClosedFormula(), bl2);
    }

    public IncrementalPlicationChecker.Validity checkImplication(Term term, Term term2, boolean bl, Term term3, Term term4, boolean bl2) {
        IncrementalPlicationChecker.Validity validity;
        if (bl && bl2 && (validity = this.dataflowBasedImplicationCheck(term, term3)) == IncrementalPlicationChecker.Validity.INVALID) {
            return validity;
        }
        if (this.mManagedScript.isLocked()) {
            this.mManagedScript.requestLockRelease();
        }
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.echo((Object)this, new QuotedObject("Start implication check"));
        this.mManagedScript.push((Object)this, 1);
        this.mManagedScript.assertTerm((Object)this, term2);
        this.mManagedScript.assertTerm((Object)this, SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)term4));
        validity = this.mManagedScript.checkSat((Object)this);
        this.mManagedScript.pop((Object)this, 1);
        this.mManagedScript.echo((Object)this, new QuotedObject("Finished implication check"));
        this.mManagedScript.unlock((Object)this);
        return IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)validity);
    }

    private IncrementalPlicationChecker.Validity dataflowBasedImplicationCheck(Term term, Term term2) {
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }
}

