/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PickShape;
import javax.media.j3d.Picking;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphPath;

public class BranchGroup
extends Group {
    public static final int ALLOW_DETACH = 17;

    void createRetained() {
        this.retained = new BranchGroupRetained();
        this.retained.setSource(this);
    }

    public void compile() {
        if (this.isLive()) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup0"));
        }
        if (!this.isCompiled()) {
            this.checkForCycle();
            ((BranchGroupRetained)this.retained).compile();
        }
    }

    public void detach() {
        if (this.isLiveOrCompiled()) {
            Group group;
            if (!this.getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("BranchGroup1"));
            }
            if (((BranchGroupRetained)this.retained).parent != null && !(group = (Group)((BranchGroupRetained)this.retained).parent.source).getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("BranchGroup2"));
            }
        }
        ((BranchGroupRetained)this.retained).detach();
    }

    public SceneGraphPath[] pickAll(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return Picking.pickAll(this, pickShape);
    }

    public SceneGraphPath[] pickAllSorted(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return Picking.pickAllSorted(this, pickShape);
    }

    public SceneGraphPath pickClosest(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return Picking.pickClosest(this, pickShape);
    }

    public SceneGraphPath pickAny(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return Picking.pickAny(this, pickShape);
    }

    public Node cloneNode(boolean bl) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.duplicateNode(this, bl);
        return branchGroup;
    }
}

