/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PetriCegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PetriCegarStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import java.util.Collection;

public class PetriCegarLoopStatisticsGenerator
extends StatisticsGeneratorWithStopwatches
implements IStatisticsDataProvider {
    private int mFlowIncreaseByBackfolding = 0;
    private final CegarLoopStatisticsGenerator mCegarLoopStatisticsGenerator;

    public PetriCegarLoopStatisticsGenerator(CegarLoopStatisticsGenerator cegarLoopStatisticsGenerator) {
        this.mCegarLoopStatisticsGenerator = cegarLoopStatisticsGenerator;
    }

    public Collection<String> getKeys() {
        return this.getBenchmarkType().getKeys();
    }

    public void reportFlowIncreaseByBackfolding(int n) {
        this.mFlowIncreaseByBackfolding += n;
    }

    public Object getValue(String string) {
        Number number;
        PetriCegarLoopStatisticsDefinitions petriCegarLoopStatisticsDefinitions = PetriCegarLoopStatisticsDefinitions.valueOf(string);
        switch (petriCegarLoopStatisticsDefinitions) {
            case EmptinessCheckTime: 
            case RemoveRedundantFlowTime: 
            case RemoveRedundantFlowUnfoldingTime: 
            case BackfoldingTime: 
            case BackfoldingUnfoldingTime: {
                try {
                    number = this.getElapsedTime(string);
                    break;
                }
                catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
                    throw new AssertionError((Object)("clock still running: " + string));
                }
            }
            case FlowIncreaseByBackfolding: {
                number = this.mFlowIncreaseByBackfolding;
                break;
            }
            case BasicCegarLoop: {
                StatisticsData statisticsData = new StatisticsData();
                statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)this.mCegarLoopStatisticsGenerator);
                number = statisticsData;
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return number;
    }

    public IStatisticsType getBenchmarkType() {
        return PetriCegarStatisticsType.getInstance();
    }

    public String[] getStopwatches() {
        return new String[]{PetriCegarLoopStatisticsDefinitions.BackfoldingTime.toString(), PetriCegarLoopStatisticsDefinitions.BackfoldingUnfoldingTime.toString(), PetriCegarLoopStatisticsDefinitions.EmptinessCheckTime.toString(), PetriCegarLoopStatisticsDefinitions.RemoveRedundantFlowTime.toString(), PetriCegarLoopStatisticsDefinitions.RemoveRedundantFlowUnfoldingTime.toString()};
    }
}

