/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RequiredMemoryModelFeatures {
    private boolean mMemoryStructureInfrastructureRequired;
    private final Set<CPrimitive.CPrimitives> mDataOnHeapRequired = new HashSet<CPrimitive.CPrimitives>();
    private final Set<CPrimitive.CPrimitives> mDataUncheckedWriteRequired;
    private final Set<CPrimitive.CPrimitives> mDataInitWriteRequired;
    private boolean mPointerOnHeapRequired;
    private boolean mPointerUncheckedWriteRequired;
    private boolean mPointerInitWriteRequired;
    private final Set<MemoryModelDeclarations> mRequiredMemoryStructureDeclarations = new HashSet<MemoryModelDeclarations>();
    private final Set<CPrimitive.CPrimitives> mDataOnHeapInitFunctionRequired;
    private boolean mPointerOnHeapInitFunctionRequired;
    private final Set<CPrimitive.CPrimitives> mDataOnHeapStoreFunctionRequired;
    private boolean mPointerOnHeapStoreFunctionRequired;
    private boolean mIsFrozen;
    private boolean mMemoryStructureInfrastructureRequiredHasBeenQueried;
    private final List<MemoryModelDeclarations> mMetaDataDeclarations;

    public RequiredMemoryModelFeatures(List<MemoryModelDeclarations> list) {
        this.mDataUncheckedWriteRequired = new HashSet<CPrimitive.CPrimitives>();
        this.mDataInitWriteRequired = new HashSet<CPrimitive.CPrimitives>();
        this.mDataOnHeapInitFunctionRequired = new HashSet<CPrimitive.CPrimitives>();
        this.mDataOnHeapStoreFunctionRequired = new HashSet<CPrimitive.CPrimitives>();
        this.mMetaDataDeclarations = list;
    }

    public boolean requireMemoryStructureInfrastructure() {
        if (this.mMemoryStructureInfrastructureRequired) {
            return false;
        }
        if (this.mMemoryStructureInfrastructureRequiredHasBeenQueried) assert (false) : "someone already asked if Memory Structure infrastructure was required and we said no";
        this.mMemoryStructureInfrastructureRequired = true;
        for (MemoryModelDeclarations memoryModelDeclarations : this.mMetaDataDeclarations) {
            this.require(memoryModelDeclarations);
        }
        return true;
    }

    public boolean reportPointerOnHeapRequired() {
        if (this.mPointerOnHeapRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.requireMemoryStructureInfrastructure();
        this.mPointerOnHeapRequired = true;
        return true;
    }

    public boolean reportPointerUncheckedWriteRequired() {
        if (this.mPointerUncheckedWriteRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.reportPointerOnHeapRequired();
        this.mPointerUncheckedWriteRequired = true;
        return true;
    }

    public boolean reportPointerInitWriteRequired() {
        if (this.mPointerInitWriteRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.reportPointerOnHeapRequired();
        this.mPointerInitWriteRequired = true;
        return true;
    }

    public boolean reportDataOnHeapRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataOnHeapRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.requireMemoryStructureInfrastructure();
        this.mDataOnHeapRequired.add(cPrimitives);
        return true;
    }

    public boolean reportUncheckedWriteRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataUncheckedWriteRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.reportDataOnHeapRequired(cPrimitives);
        this.mDataUncheckedWriteRequired.add(cPrimitives);
        return true;
    }

    public boolean reportInitWriteRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataInitWriteRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.reportDataOnHeapRequired(cPrimitives);
        this.mDataInitWriteRequired.add(cPrimitives);
        return true;
    }

    public boolean reportDataOnHeapInitFunctionRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataOnHeapInitFunctionRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.reportDataOnHeapRequired(cPrimitives);
        this.mDataOnHeapInitFunctionRequired.add(cPrimitives);
        return true;
    }

    public boolean reportPointerOnHeapInitFunctionRequired() {
        if (this.mPointerOnHeapInitFunctionRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.reportPointerOnHeapRequired();
        this.mPointerOnHeapInitFunctionRequired = true;
        return true;
    }

    public boolean reportDataOnHeapStoreFunctionRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataOnHeapStoreFunctionRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.reportDataOnHeapRequired(cPrimitives);
        this.mDataOnHeapStoreFunctionRequired.add(cPrimitives);
        return true;
    }

    public boolean reportPointerOnHeapStoreFunctionRequired() {
        if (this.mPointerOnHeapStoreFunctionRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.reportPointerOnHeapRequired();
        this.mPointerOnHeapStoreFunctionRequired = true;
        return true;
    }

    public boolean isPointerOnHeapRequired() {
        this.checkIsFrozen();
        return this.mPointerOnHeapRequired;
    }

    public boolean isPointerUncheckedWriteRequired() {
        this.checkIsFrozen();
        return this.mPointerUncheckedWriteRequired;
    }

    public boolean isPointerInitRequired() {
        this.checkIsFrozen();
        return this.mPointerInitWriteRequired;
    }

    public Set<CPrimitive.CPrimitives> getDataOnHeapRequired() {
        this.checkIsFrozen();
        return this.mDataOnHeapRequired;
    }

    public boolean isPointerOnHeapInitFunctionRequired() {
        this.checkIsFrozen();
        return this.mPointerOnHeapInitFunctionRequired;
    }

    public boolean isDataOnHeapInitFunctionRequired(CPrimitive.CPrimitives cPrimitives) {
        this.checkIsFrozen();
        return this.mDataOnHeapInitFunctionRequired.contains((Object)cPrimitives);
    }

    public boolean isPointerOnHeapStoreFunctionRequired() {
        this.checkIsFrozen();
        return this.mPointerOnHeapStoreFunctionRequired;
    }

    public boolean isDataOnHeapStoreFunctionRequired(CPrimitive.CPrimitives cPrimitives) {
        this.checkIsFrozen();
        return this.mDataOnHeapStoreFunctionRequired.contains((Object)cPrimitives);
    }

    public Set<CPrimitive.CPrimitives> getUncheckedWriteRequired() {
        this.checkIsFrozen();
        return this.mDataUncheckedWriteRequired;
    }

    public Set<CPrimitive.CPrimitives> getInitWriteRequired() {
        this.checkIsFrozen();
        return this.mDataInitWriteRequired;
    }

    public boolean isMemoryStructureInfrastructureRequired() {
        this.mMemoryStructureInfrastructureRequiredHasBeenQueried = true;
        return this.mMemoryStructureInfrastructureRequired;
    }

    public boolean require(MemoryModelDeclarations memoryModelDeclarations) {
        if (this.mRequiredMemoryStructureDeclarations.contains((Object)memoryModelDeclarations)) {
            return false;
        }
        this.checkNotFrozen();
        this.requireMemoryStructureInfrastructure();
        return this.mRequiredMemoryStructureDeclarations.add(memoryModelDeclarations);
    }

    public Set<MemoryModelDeclarations> getRequiredMemoryStructureDeclarations() {
        this.checkIsFrozen();
        return Collections.unmodifiableSet(this.mRequiredMemoryStructureDeclarations);
    }

    public void finish(TranslationSettings translationSettings) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (MemoryModelDeclarations memoryModelDeclarations : new HashSet<MemoryModelDeclarations>(this.mRequiredMemoryStructureDeclarations)) {
                bl |= memoryModelDeclarations.resolveDependencies(this, translationSettings);
            }
        }
        this.mIsFrozen = true;
    }

    private void checkIsFrozen() {
        if (!this.mIsFrozen) {
            throw new AssertionError((Object)"attempt to query before this has been frozen -- results might be wrong");
        }
    }

    private void checkNotFrozen() {
        if (this.mIsFrozen) {
            throw new AssertionError((Object)"attempt to modify, although this has been frozen already, note that if some Memory Structure feature relies on another one, this has to be declared inMemoryStructureDeclarations.resolveDependencies(..)perhaps we need to update a method there");
        }
    }

    Set<CPrimitive.CPrimitives> getDataOnHeapRequiredUnchecked() {
        return this.mDataOnHeapRequired;
    }

    boolean isPointerOnHeapRequiredUnchecked() {
        return this.mPointerOnHeapRequired;
    }
}

