/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.HITSWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.ScoringUtils;
import edu.uci.ics.jung.graph.Graph;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HITS<V, E>
extends HITSWithPriors<V, E> {
    public HITS(Graph<V, E> g, Transformer<E, Double> edge_weights, double alpha) {
        super(g, edge_weights, ScoringUtils.getHITSUniformRootPrior(g.getVertices()), alpha);
    }

    public HITS(Graph<V, E> g, double alpha) {
        super(g, ScoringUtils.getHITSUniformRootPrior(g.getVertices()), alpha);
    }

    public HITS(Graph<V, E> g) {
        this(g, 0.0);
    }

    public static class Scores {
        public double hub;
        public double authority;

        public Scores(double hub, double authority) {
            this.hub = hub;
            this.authority = authority;
        }

        public String toString() {
            return String.format("[h:%.4f,a:%.4f]", this.hub, this.authority);
        }
    }
}

