/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class SubTermFinder
extends NonRecursive {
    private final Predicate<Term> mPredicate;
    private final boolean mOnlyOutermost;
    private HashSet<Term> mResult;
    private HashSet<Term> mVisitedSubterms;

    private SubTermFinder(Predicate<Term> predicate, boolean bl) {
        this.mPredicate = predicate;
        this.mOnlyOutermost = bl;
    }

    private Set<Term> findMatchingSubterms(Term term) {
        if (term == null) {
            throw new IllegalArgumentException();
        }
        this.mResult = new HashSet();
        this.mVisitedSubterms = new HashSet();
        this.run((NonRecursive.Walker)new FindWalker(term));
        return this.mResult;
    }

    public static Set<Term> find(Term term, Predicate<Term> predicate, boolean bl) {
        return new SubTermFinder(predicate, bl).findMatchingSubterms(term);
    }

    class FindWalker
    extends NonRecursive.TermWalker {
        FindWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
            if (SubTermFinder.this.mPredicate.test((Term)constantTerm)) {
                SubTermFinder.this.mResult.add((Term)constantTerm);
            }
        }

        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            if (SubTermFinder.this.mPredicate.test((Term)annotatedTerm)) {
                SubTermFinder.this.mResult.add((Term)annotatedTerm);
                if (SubTermFinder.this.mOnlyOutermost) {
                    return;
                }
            }
            nonRecursive.enqueueWalker((NonRecursive.Walker)new FindWalker(annotatedTerm.getSubterm()));
        }

        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            if (SubTermFinder.this.mVisitedSubterms.contains(applicationTerm)) {
                return;
            }
            SubTermFinder.this.mVisitedSubterms.add((Term)applicationTerm);
            if (SubTermFinder.this.mPredicate.test((Term)applicationTerm)) {
                SubTermFinder.this.mResult.add((Term)applicationTerm);
                if (SubTermFinder.this.mOnlyOutermost) {
                    return;
                }
            }
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                nonRecursive.enqueueWalker((NonRecursive.Walker)new FindWalker(term));
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            throw new UnsupportedOperationException();
        }

        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            if (SubTermFinder.this.mPredicate.test((Term)quantifiedFormula)) {
                SubTermFinder.this.mResult.add((Term)quantifiedFormula);
                if (SubTermFinder.this.mOnlyOutermost) {
                    return;
                }
            }
            nonRecursive.enqueueWalker((NonRecursive.Walker)new FindWalker(quantifiedFormula.getSubformula()));
        }

        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
            if (SubTermFinder.this.mPredicate.test((Term)termVariable)) {
                SubTermFinder.this.mResult.add((Term)termVariable);
            }
        }

        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            throw new UnsupportedOperationException();
        }
    }
}

