/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.NormalFormTransformer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BoogieBooleanExpressionDecision
extends Decision<BoogieBooleanExpressionDecision> {
    private final Expression mExpression;
    private static final NormalFormTransformer<Expression> TRANSFORMER = new NormalFormTransformer((INormalFormable)new BoogieExpressionTransformer());

    private BoogieBooleanExpressionDecision(Expression expression) {
        this.mExpression = expression;
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    public static CDD create(Expression expression) {
        CDD cDD = new BoogieToCdd().createCdd(expression);
        return cDD;
    }

    public static CDD createWithoutReduction(Expression expression) {
        return CDD.create(new BoogieBooleanExpressionDecision(expression), CDD.TRUE_CHILDS);
    }

    public static CDD createTrue() {
        return CDD.TRUE;
    }

    @Override
    public BoogieBooleanExpressionDecision unprime(Set<String> set) {
        BoogieRemovePrimeIdentifierTransformer boogieRemovePrimeIdentifierTransformer = new BoogieRemovePrimeIdentifierTransformer(set);
        Expression expression = boogieRemovePrimeIdentifierTransformer.processExpression(this.mExpression);
        return new BoogieBooleanExpressionDecision(expression);
    }

    @Override
    public BoogieBooleanExpressionDecision prime(Set<String> set) {
        BoogiePrimeIdentifierTransformer boogiePrimeIdentifierTransformer = new BoogiePrimeIdentifierTransformer(set);
        Expression expression = boogiePrimeIdentifierTransformer.processExpression(this.mExpression);
        return new BoogieBooleanExpressionDecision(expression);
    }

    @Override
    public String toString(int n) {
        if (n != 0) {
            BoogieLocation boogieLocation = new BoogieLocation("", 0, 0, 0, 0);
            return BoogiePrettyPrinter.print((Expression)new UnaryExpression((ILocation)boogieLocation, UnaryExpression.Operator.LOGICNEG, this.mExpression));
        }
        return BoogiePrettyPrinter.print((Expression)this.mExpression);
    }

    @Override
    public String toSmtString(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toTexString(int n) {
        Object object = n == 0 ? this.mExpression : new UnaryExpression(null, UnaryExpression.Operator.LOGICNEG, this.mExpression);
        return BoogiePrettyPrinter.print((Expression)object);
    }

    @Override
    public String toBoogieString(int n) {
        return this.toString(n);
    }

    @Override
    public String toUppaalString(int n) {
        String string = this.toString(n);
        string = string.replaceAll("<=", "&lt;=");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">=", "&gt;=");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("&&", "&amp;&amp;");
        return string;
    }

    @Override
    public String toUppaalStringDOM(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVar() {
        throw new UnsupportedOperationException("getVar not supported by BoogieBooleanExpressionDecision (use getVars)!");
    }

    public Map<String, String> getVars() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BoogieIdentifierCollector boogieIdentifierCollector = new BoogieIdentifierCollector();
        List<IdentifierExpression> list = boogieIdentifierCollector.getIdentifiers(this.mExpression);
        for (IdentifierExpression identifierExpression : list) {
            hashMap.put(identifierExpression.getIdentifier(), null);
        }
        return hashMap;
    }

    @Override
    public int compareToSimilar(Decision<?> decision) {
        BoogieBooleanExpressionDecision boogieBooleanExpressionDecision = (BoogieBooleanExpressionDecision)decision;
        if (this.mExpression == null && boogieBooleanExpressionDecision.mExpression == null) {
            return 0;
        }
        if (this.mExpression == null && boogieBooleanExpressionDecision.mExpression != null) {
            return -1;
        }
        if (this.mExpression != null && boogieBooleanExpressionDecision.mExpression == null) {
            return 1;
        }
        String string = BoogiePrettyPrinter.print((Expression)this.mExpression);
        String string2 = BoogiePrettyPrinter.print((Expression)boogieBooleanExpressionDecision.mExpression);
        return string.compareTo(string2);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mExpression == null ? 0 : this.mExpression.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        String string;
        String string2;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BoogieBooleanExpressionDecision boogieBooleanExpressionDecision = (BoogieBooleanExpressionDecision)object;
        return !(this.mExpression == null ? boogieBooleanExpressionDecision.mExpression != null : !(string2 = BoogiePrettyPrinter.print((Expression)this.mExpression)).equals(string = BoogiePrettyPrinter.print((Expression)boogieBooleanExpressionDecision.mExpression)));
    }

    private static final class BoogieIdentifierCollector
    extends BoogieVisitor {
        private final ArrayList<IdentifierExpression> mIdentifiers = new ArrayList();

        private BoogieIdentifierCollector() {
        }

        protected void visit(IdentifierExpression identifierExpression) {
            this.mIdentifiers.add(identifierExpression);
        }

        public List<IdentifierExpression> getIdentifiers(Expression expression) {
            this.processExpression(expression);
            return this.mIdentifiers;
        }
    }

    private static final class BoogiePrimeIdentifierTransformer
    extends BoogieTransformer {
        private final Set<String> mIgnoredIds;

        private BoogiePrimeIdentifierTransformer(Set<String> set) {
            this.mIgnoredIds = set;
        }

        protected Expression processExpression(Expression expression) {
            if (expression instanceof IdentifierExpression) {
                String string = ((IdentifierExpression)expression).getIdentifier();
                if (this.mIgnoredIds.contains(string)) {
                    return expression;
                }
                if (string.startsWith("'")) {
                    return new IdentifierExpression(expression.getLocation(), string.replaceAll("'([a-zA-Z_])(\\w*)", "$1$2"));
                }
                return new IdentifierExpression(expression.getLocation(), string.replaceAll("([a-zA-Z_])(\\w*)", "$1$2'"));
            }
            return super.processExpression(expression);
        }
    }

    private static final class BoogieRemovePrimeIdentifierTransformer
    extends BoogieTransformer {
        private final Set<String> mIgnoredIds;

        private BoogieRemovePrimeIdentifierTransformer(Set<String> set) {
            this.mIgnoredIds = set;
        }

        protected Expression processExpression(Expression expression) {
            if (expression instanceof IdentifierExpression) {
                String string = ((IdentifierExpression)expression).getIdentifier();
                if (this.mIgnoredIds.contains(string)) {
                    return expression;
                }
                return new IdentifierExpression(expression.getLocation(), string.replaceAll("([a-zA-Z_])(\\w*)'", "$1$2"));
            }
            return super.processExpression(expression);
        }
    }

    private static final class BoogieToCdd
    extends GeneratedBoogieAstVisitor {
        private Deque<CDD> mOpenCDDs;

        private BoogieToCdd() {
        }

        public CDD createCdd(Expression expression) {
            this.mOpenCDDs = new ArrayDeque<CDD>();
            Expression expression2 = (Expression)TRANSFORMER.toNnf((Object)expression);
            expression2.accept((GeneratedBoogieAstVisitor)this);
            assert (this.mOpenCDDs.size() == 1);
            return this.mOpenCDDs.pop();
        }

        public boolean visit(QuantifierExpression quantifierExpression) {
            this.mOpenCDDs.push(CDD.create(new BoogieBooleanExpressionDecision((Expression)quantifierExpression), CDD.TRUE_CHILDS));
            return false;
        }

        public boolean visit(FunctionApplication functionApplication) {
            this.mOpenCDDs.push(CDD.create(new BoogieBooleanExpressionDecision((Expression)functionApplication), CDD.TRUE_CHILDS));
            return false;
        }

        public boolean visit(BinaryExpression binaryExpression) {
            switch (binaryExpression.getOperator()) {
                case BITVECCONCAT: 
                case ARITHPLUS: 
                case ARITHMINUS: 
                case ARITHMUL: 
                case ARITHDIV: 
                case ARITHMOD: {
                    throw new RuntimeException("Saw " + BoogiePrettyPrinter.print((Expression)binaryExpression) + " but expected boolean binary expression");
                }
                case COMPLT: 
                case COMPGT: 
                case COMPLEQ: 
                case COMPGEQ: 
                case COMPEQ: 
                case COMPNEQ: 
                case COMPPO: {
                    this.mOpenCDDs.push(CDD.create(new BoogieBooleanExpressionDecision((Expression)binaryExpression), CDD.TRUE_CHILDS));
                    return false;
                }
                case LOGICIFF: 
                case LOGICIMPLIES: 
                case LOGICAND: 
                case LOGICOR: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            binaryExpression.getLeft().accept((GeneratedBoogieAstVisitor)this);
            CDD cDD = this.mOpenCDDs.pop();
            binaryExpression.getRight().accept((GeneratedBoogieAstVisitor)this);
            CDD cDD2 = this.mOpenCDDs.pop();
            switch (binaryExpression.getOperator()) {
                case LOGICAND: {
                    this.mOpenCDDs.push(cDD.and(cDD2));
                    break;
                }
                case LOGICIMPLIES: {
                    this.mOpenCDDs.push(cDD.negate().or(cDD2));
                    break;
                }
                case LOGICIFF: {
                    this.mOpenCDDs.push(cDD.negate().and(cDD2.negate()).or(cDD.and(cDD2)));
                    break;
                }
                case LOGICOR: {
                    this.mOpenCDDs.push(cDD.or(cDD2));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return false;
        }

        public boolean visit(BooleanLiteral booleanLiteral) {
            if (booleanLiteral.getValue()) {
                this.mOpenCDDs.push(CDD.TRUE);
            } else {
                this.mOpenCDDs.push(CDD.FALSE);
            }
            return super.visit(booleanLiteral);
        }

        public boolean visit(IdentifierExpression identifierExpression) {
            this.mOpenCDDs.push(CDD.create(new BooleanDecision(identifierExpression.getIdentifier()), CDD.TRUE_CHILDS));
            return super.visit(identifierExpression);
        }

        public boolean visit(UnaryExpression unaryExpression) {
            switch (unaryExpression.getOperator()) {
                case ARITHNEGATIVE: 
                case OLD: {
                    throw new RuntimeException("Saw " + BoogiePrettyPrinter.print((Expression)unaryExpression) + " but expected boolean unary expression");
                }
                case LOGICNEG: {
                    unaryExpression.getExpr().accept((GeneratedBoogieAstVisitor)this);
                    this.mOpenCDDs.push(this.mOpenCDDs.pop().negate());
                    return false;
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

