/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiIndexArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DualJunctionAvt
extends DualJunctionQuantifierElimination {
    private final boolean mAllowCaseDistinctions;

    public DualJunctionAvt(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, boolean bl) {
        super(managedScript, iUltimateServiceProvider);
        this.mAllowCaseDistinctions = bl;
    }

    @Override
    public String getName() {
        return "array value transformation";
    }

    @Override
    public String getAcronym() {
        return "AVT";
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask eliminationTask) {
        boolean bl = this.inexpensivePreinvestigation(eliminationTask);
        if (!bl) {
            return null;
        }
        for (TermVariable termVariable : eliminationTask.getEliminatees()) {
            AvtReplacementInformation avtReplacementInformation = this.findReplacement(eliminationTask, termVariable);
            if (avtReplacementInformation == null || !avtReplacementInformation.getIndicesOfSubsequentArrayWrites().isEmpty() && !this.mAllowCaseDistinctions) continue;
            return this.doElimination(eliminationTask, termVariable, avtReplacementInformation);
        }
        return null;
    }

    private DualJunctionQuantifierElimination.EliminationResult doElimination(EliminationTask eliminationTask, TermVariable termVariable, AvtReplacementInformation avtReplacementInformation) {
        Object object;
        ArrayIndex arrayIndex3;
        MultiIndexArrayUpdate multiIndexArrayUpdate = avtReplacementInformation.getMiau();
        ArrayIndex arrayIndex2 = multiIndexArrayUpdate.getMultiDimensionalNestedStore().getIndices().get(avtReplacementInformation.getPositionOfWriteWhereEliminateeIsWritten());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (ArrayIndex arrayIndex3 : avtReplacementInformation.getIndicesOfSubsequentArrayWrites()) {
            object = this.constructDualFiniteJunctionForCoincidingIndexCase(eliminationTask.getQuantifier(), multiIndexArrayUpdate, arrayIndex2, arrayIndex3, avtReplacementInformation.getPositionOfWriteWhereEliminateeIsWritten(), avtReplacementInformation.getOtherDualFiniteJuncts());
            arrayList.add((Term)object);
        }
        arrayIndex3 = this.constructDualFiniteJunctionForCaseForDefaultCase(eliminationTask.getQuantifier(), eliminationTask.getTerm(), termVariable, avtReplacementInformation.getReplacement(), arrayIndex2, avtReplacementInformation.getIndicesOfSubsequentArrayWrites());
        arrayList.add((Term)arrayIndex3);
        Term term = QuantifierUtils.applyCorrespondingFiniteConnective(this.mScript, eliminationTask.getQuantifier(), arrayList);
        object = new EliminationTask(eliminationTask.getQuantifier(), eliminationTask.getEliminatees(), term, eliminationTask.getContext());
        return new DualJunctionQuantifierElimination.EliminationResult((EliminationTask)object, Collections.emptySet());
    }

    private boolean inexpensivePreinvestigation(EliminationTask eliminationTask) {
        Term[] termArray;
        Term[] termArray2 = termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            MultiIndexArrayUpdate multiIndexArrayUpdate = MultiIndexArrayUpdate.of(this.mScript, term);
            if (multiIndexArrayUpdate != null && QuantifierUtils.getDerOperator(eliminationTask.getQuantifier()).equals((Object)multiIndexArrayUpdate.getRelationSymbol())) {
                int n3 = multiIndexArrayUpdate.getMultiDimensionalNestedStore().getIndices().size() - 1;
                while (n3 >= 0) {
                    Term term2 = multiIndexArrayUpdate.getMultiDimensionalNestedStore().getValues().get(n3);
                    if (DataStructureUtils.haveNonEmptyIntersection(Arrays.asList(term2.getFreeVars()), eliminationTask.getEliminatees())) {
                        return true;
                    }
                    --n3;
                }
            }
            ++n2;
        }
        return false;
    }

    private Term constructDualFiniteJunctionForCoincidingIndexCase(int n, MultiIndexArrayUpdate multiIndexArrayUpdate, ArrayIndex arrayIndex, ArrayIndex arrayIndex2, int n2, List<Term> list) {
        MultiIndexArrayUpdate multiIndexArrayUpdate2 = multiIndexArrayUpdate.removeOneIndex(n2);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(DualJunctionAvt.constructDerRelationForIndices(this.mScript, n, arrayIndex, arrayIndex2));
        arrayList.addAll(list);
        arrayList.add(multiIndexArrayUpdate2.toTerm(this.mScript));
        return QuantifierUtils.applyDualFiniteConnective(this.mScript, n, arrayList);
    }

    private Term constructDualFiniteJunctionForCaseForDefaultCase(int n, Term term, TermVariable termVariable, Term term2, ArrayIndex arrayIndex, List<ArrayIndex> list) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (ArrayIndex object2 : list) {
            arrayList.add(this.constructAntiDerRelationForIndices(this.mScript, n, arrayIndex, object2));
        }
        Map<TermVariable, Term> map = Collections.singletonMap(termVariable, term2);
        arrayList.add(Substitution.apply(this.mMgdScript, map, term));
        return QuantifierUtils.applyDualFiniteConnective(this.mScript, n, arrayList);
    }

    public static Term constructDerRelationForIndices(Script script, int n, ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        if (n == 0) {
            return ArrayIndex.constructIndexEquality(script, arrayIndex, arrayIndex2);
        }
        if (n == 1) {
            return ArrayIndex.constructIndexNotEquals(script, arrayIndex, arrayIndex2);
        }
        throw new AssertionError((Object)"IllegalQuantifier");
    }

    public Term constructAntiDerRelationForIndices(Script script, int n, ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        if (n == 0) {
            return ArrayIndex.constructIndexNotEquals(script, arrayIndex, arrayIndex2);
        }
        if (n == 1) {
            return ArrayIndex.constructIndexEquality(script, arrayIndex, arrayIndex2);
        }
        throw new AssertionError((Object)"IllegalQuantifier");
    }

    private AvtReplacementInformation findReplacement(EliminationTask eliminationTask, TermVariable termVariable) {
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        int n = 0;
        while (n < termArray.length) {
            MultiIndexArrayUpdate multiIndexArrayUpdate = MultiIndexArrayUpdate.of(this.mScript, termArray[n]);
            if (multiIndexArrayUpdate != null && QuantifierUtils.getDerOperator(eliminationTask.getQuantifier()).equals((Object)multiIndexArrayUpdate.getRelationSymbol())) {
                int n2 = multiIndexArrayUpdate.getMultiDimensionalNestedStore().getIndices().size() - 1;
                while (n2 >= 0) {
                    Term term = multiIndexArrayUpdate.getMultiDimensionalNestedStore().getValues().get(n2);
                    if (Arrays.asList(term.getFreeVars()).contains(termVariable)) {
                        ArrayIndex arrayIndex = multiIndexArrayUpdate.getMultiDimensionalNestedStore().getIndices().get(n2);
                        Term term2 = new MultiDimensionalSelect(multiIndexArrayUpdate.getNewArray(), arrayIndex).toTerm(this.mScript);
                        Term term3 = QuantifierUtils.applyDerOperator(this.mScript, eliminationTask.getQuantifier(), term, term2);
                        Object object = new DualJunctionDer.DerHelperSbr().solveForSubject(this.mMgdScript, eliminationTask.getQuantifier(), termVariable, term3, (Set)eliminationTask.getContext().getBoundByAncestors());
                        if (object != null) {
                            assert (((SolvedBinaryRelation)object).getLeftHandSide() == termVariable);
                            List list = DataStructureUtils.copyAllButOne(Arrays.asList(termArray), (int)n);
                            return new AvtReplacementInformation(multiIndexArrayUpdate, n2, list, ((SolvedBinaryRelation)object).getRightHandSide());
                        }
                    }
                    --n2;
                }
            }
            ++n;
        }
        return null;
    }

    private static class AvtReplacementInformation {
        private final MultiIndexArrayUpdate mMiau;
        private final int mPositionOfWriteWhereEliminateeIsWritten;
        private final List<ArrayIndex> mIndicesOfSubsequentArrayWrites;
        private final List<Term> mOtherDualFiniteJuncts;
        private final Term mReplacement;

        public AvtReplacementInformation(MultiIndexArrayUpdate multiIndexArrayUpdate, int n, List<Term> list, Term term) {
            this.mMiau = multiIndexArrayUpdate;
            this.mPositionOfWriteWhereEliminateeIsWritten = n;
            this.mIndicesOfSubsequentArrayWrites = this.indicesOfSubsequentArrayWrites(n, multiIndexArrayUpdate);
            this.mOtherDualFiniteJuncts = list;
            this.mReplacement = term;
        }

        private List<ArrayIndex> indicesOfSubsequentArrayWrites(int n, MultiIndexArrayUpdate multiIndexArrayUpdate) {
            ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>();
            int n2 = n + 1;
            while (n2 < multiIndexArrayUpdate.getMultiDimensionalNestedStore().getIndices().size()) {
                ArrayIndex arrayIndex = multiIndexArrayUpdate.getMultiDimensionalNestedStore().getIndices().get(n2);
                arrayList.add(arrayIndex);
                ++n2;
            }
            return arrayList;
        }

        public MultiIndexArrayUpdate getMiau() {
            return this.mMiau;
        }

        public int getPositionOfWriteWhereEliminateeIsWritten() {
            return this.mPositionOfWriteWhereEliminateeIsWritten;
        }

        public List<ArrayIndex> getIndicesOfSubsequentArrayWrites() {
            return this.mIndicesOfSubsequentArrayWrites;
        }

        public List<Term> getOtherDualFiniteJuncts() {
            return this.mOtherDualFiniteJuncts;
        }

        public Term getReplacement() {
            return this.mReplacement;
        }
    }
}

