/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IcfgEdgeIterator
implements Iterator<IcfgEdge> {
    private final Deque<IcfgEdge> mWorklist;
    private final Set<IcfgEdge> mFinished = new HashSet<IcfgEdge>();

    public <T extends IcfgEdge> IcfgEdgeIterator(T t) {
        this(Collections.singleton(t));
    }

    public <T extends IcfgEdge> IcfgEdgeIterator(Collection<T> collection) {
        this.mWorklist = new ArrayDeque<IcfgEdge>();
        this.mWorklist.addAll(collection);
        this.mFinished.addAll(this.mWorklist);
    }

    public IcfgEdgeIterator(IIcfg<?> iIcfg) {
        this(iIcfg.getInitialNodes().stream().flatMap(icfgLocation -> icfgLocation.getOutgoingEdges().stream()).collect(Collectors.toSet()));
    }

    @Override
    public boolean hasNext() {
        return !this.mWorklist.isEmpty();
    }

    @Override
    public IcfgEdge next() {
        IcfgEdge icfgEdge = this.mWorklist.removeFirst();
        IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getTarget();
        if (icfgLocation == null) {
            assert (false) : "Dangling edge";
            return icfgEdge;
        }
        icfgLocation.getOutgoingEdges().stream().filter(this.mFinished::add).forEachOrdered(this.mWorklist::add);
        return icfgEdge;
    }

    public Stream<IcfgEdge> asStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
    }
}

