/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;

public class OccurrenceCounter
extends NonRecursive {
    public void count(Term term) {
        this.run(new CountWalker(term));
    }

    public void reset(Term term) {
        this.run(new ResetWalker(term));
    }

    private static class CountWalker
    extends NonRecursive.TermWalker {
        public CountWalker(Term term) {
            super(term);
        }

        @Override
        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
        }

        @Override
        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            nonRecursive.enqueueWalker(new CountWalker(annotatedTerm.getSubterm()));
        }

        @Override
        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            OccurrenceCounter occurrenceCounter = (OccurrenceCounter)nonRecursive;
            if (++applicationTerm.mTmpCtr == 1) {
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray[n2];
                    occurrenceCounter.enqueueWalker(new CountWalker(term));
                    ++n2;
                }
            }
        }

        @Override
        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            throw new InternalError("Term should be unletted before counting");
        }

        @Override
        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            OccurrenceCounter occurrenceCounter = (OccurrenceCounter)nonRecursive;
            if (++quantifiedFormula.mTmpCtr == 1) {
                occurrenceCounter.enqueueWalker(new CountWalker(quantifiedFormula.getSubformula()));
            }
        }

        @Override
        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            OccurrenceCounter occurrenceCounter = (OccurrenceCounter)nonRecursive;
            if (++lambdaTerm.mTmpCtr == 1) {
                occurrenceCounter.enqueueWalker(new CountWalker(lambdaTerm.getSubterm()));
            }
        }

        @Override
        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
            ++termVariable.mTmpCtr;
        }

        @Override
        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            OccurrenceCounter occurrenceCounter = (OccurrenceCounter)nonRecursive;
            if (++matchTerm.mTmpCtr == 1) {
                occurrenceCounter.enqueueWalker(new CountWalker(matchTerm.getDataTerm()));
                Term[] termArray = matchTerm.getCases();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray[n2];
                    occurrenceCounter.enqueueWalker(new CountWalker(term));
                    ++n2;
                }
            }
        }
    }

    private static class ResetWalker
    extends NonRecursive.TermWalker {
        public ResetWalker(Term term) {
            super(term);
        }

        @Override
        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
        }

        @Override
        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            nonRecursive.enqueueWalker(new ResetWalker(annotatedTerm.getSubterm()));
        }

        @Override
        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            OccurrenceCounter occurrenceCounter = (OccurrenceCounter)nonRecursive;
            if (applicationTerm.mTmpCtr != 0) {
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray[n2];
                    occurrenceCounter.enqueueWalker(new ResetWalker(term));
                    ++n2;
                }
                applicationTerm.mTmpCtr = 0;
            }
        }

        @Override
        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            throw new InternalError("Term should be unletted before counting");
        }

        @Override
        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            OccurrenceCounter occurrenceCounter = (OccurrenceCounter)nonRecursive;
            if (lambdaTerm.mTmpCtr != 0) {
                occurrenceCounter.enqueueWalker(new ResetWalker(lambdaTerm.getSubterm()));
                lambdaTerm.mTmpCtr = 0;
            }
        }

        @Override
        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            OccurrenceCounter occurrenceCounter = (OccurrenceCounter)nonRecursive;
            if (quantifiedFormula.mTmpCtr != 0) {
                occurrenceCounter.enqueueWalker(new ResetWalker(quantifiedFormula.getSubformula()));
                quantifiedFormula.mTmpCtr = 0;
            }
        }

        @Override
        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
            termVariable.mTmpCtr = 0;
        }

        @Override
        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            OccurrenceCounter occurrenceCounter = (OccurrenceCounter)nonRecursive;
            if (matchTerm.mTmpCtr != 0) {
                occurrenceCounter.enqueueWalker(new ResetWalker(matchTerm.getDataTerm()));
                Term[] termArray = matchTerm.getCases();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray[n2];
                    occurrenceCounter.enqueueWalker(new ResetWalker(term));
                    ++n2;
                }
            }
            matchTerm.mTmpCtr = 0;
        }
    }
}

