/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.annotations.IRSDependenciesAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.annotations.RCFGUnrollWalkerAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.ObserverDispatcher;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.RCFGWalker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class RCFGWalkerUnroller
extends RCFGWalker {
    protected static final String MAIN_PROCEDURE_NAME = "main";
    protected int mUnrollings;
    protected HashMap<IcfgEdge, ARTEdge> mGraph;
    protected List<List<ARTEdge>> mPaths;
    protected Stack<IcfgEdge> mCalls;
    protected Stack<IcfgEdge> mNestedLoops;
    protected Stack<HashMap<IcfgEdge, ARTEdge>> mGraphs;
    protected List<List<IcfgEdge>> mFinalPaths;
    protected List<IcfgEdge> mCurrentPath;

    public RCFGWalkerUnroller(ObserverDispatcher observerDispatcher, ILogger iLogger, int n) {
        super(observerDispatcher, iLogger);
        this.mUnrollings = n;
    }

    @Override
    public void startFrom(Collection<IcfgEdge> collection) {
        this.init();
        IcfgEdge icfgEdge = this.searchMainEdge(collection);
        if (icfgEdge == null) {
            this.mLogger.error((Object)"No main procedure found");
            return;
        }
        this.process(icfgEdge, new ArrayList<ARTEdge>());
        this.finish();
    }

    public List<List<IcfgEdge>> getPaths() {
        return this.mFinalPaths;
    }

    public List<IcfgEdge> getCurrentPrefix() {
        return this.mCurrentPath;
    }

    protected void init() {
        this.mFinalPaths = null;
        this.mGraph = new HashMap();
        this.mPaths = new ArrayList<List<ARTEdge>>();
        this.mCalls = new Stack();
        this.mNestedLoops = new Stack();
        this.mGraphs = new Stack();
        this.mCurrentPath = new ArrayList<IcfgEdge>();
    }

    protected void finish() {
        this.mFinalPaths = new ArrayList<List<IcfgEdge>>();
        for (List<ARTEdge> list : this.mPaths) {
            ArrayList<IcfgEdge> arrayList = new ArrayList<IcfgEdge>();
            for (ARTEdge aRTEdge : list) {
                arrayList.add(aRTEdge.mBacking);
            }
            this.mFinalPaths.add(arrayList);
        }
        this.mLogger.info((Object)("Processed " + this.mFinalPaths.size() + " traces"));
        this.mGraph = null;
        this.mPaths = null;
        this.mCalls = null;
        this.mGraphs = null;
        this.mNestedLoops = null;
        this.mCurrentPath = null;
    }

    protected void printPath(List<ARTEdge> list) {
        this.mLogger.debug((Object)list.get(0).getSource());
        for (ARTEdge aRTEdge : list) {
            this.mLogger.debug((Object)aRTEdge.mBacking);
            this.mLogger.debug((Object)aRTEdge.getTarget());
        }
    }

    protected IcfgEdge searchMainEdge(Collection<IcfgEdge> collection) {
        this.mLogger.debug((Object)"Searching for procedure \"main\"");
        for (IcfgEdge icfgEdge : collection) {
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)icfgEdge.getTarget();
            this.mLogger.debug((Object)("Candidate: \"" + boogieIcfgLocation.getProcedure() + "\""));
            if (!boogieIcfgLocation.getProcedure().equalsIgnoreCase(MAIN_PROCEDURE_NAME)) continue;
            this.mLogger.debug((Object)"Found match");
            return icfgEdge;
        }
        return null;
    }

    public void process(IcfgEdge icfgEdge, List<ARTEdge> list) {
        String string2;
        ARTEdge aRTEdge = this.createEdge(icfgEdge);
        if (aRTEdge.getAnnotation() == null) {
            this.findLoopEntryExit((IcfgLocation)icfgEdge.getTarget());
        }
        this.mLogger.debug((Object)("processing: " + String.valueOf(aRTEdge)));
        if (aRTEdge.isVisited(this.mUnrollings)) {
            this.mLogger.debug((Object)"--reached unrolling limit");
            this.mLogger.debug((Object)"");
            return;
        }
        aRTEdge.visit();
        if (icfgEdge instanceof Call) {
            this.mCalls.push(icfgEdge);
            this.mLogger.debug((Object)("--push (call) " + String.valueOf(icfgEdge)));
            this.mLogger.debug((Object)("----old mGraph: " + String.valueOf(this.mGraph.values())));
            this.mLogger.debug((Object)"----new mGraph: fresh");
            this.mGraphs.push(this.mGraph);
            this.mGraph = new HashMap();
            if (this.isMaxCallDepth(icfgEdge)) {
                this.mLogger.debug((Object)"--reached unrolling limit (call)");
                this.mLogger.debug((Object)"");
                return;
            }
        } else if (icfgEdge instanceof Return) {
            this.mCalls.pop();
            string2 = this.mGraph.values().toString();
            this.mGraph = this.mGraphs.pop();
            aRTEdge.mLastGraphState = this.mGraph;
            this.mLogger.debug((Object)("--pop (return) " + String.valueOf(icfgEdge)));
            this.mLogger.debug((Object)("----old mGraph: " + string2));
            this.mLogger.debug((Object)("----new mGraph: " + String.valueOf(this.mGraph.values())));
        }
        if (aRTEdge.isNestedLoopEntry()) {
            this.mLogger.debug((Object)("--push (nestedLoop) " + String.valueOf(icfgEdge)));
            this.mNestedLoops.push(icfgEdge);
            if (this.isMaxLoopDepth(aRTEdge)) {
                this.mLogger.debug((Object)"--reached unrolling limit (nestedLoop)");
                this.mLogger.debug((Object)("----mNestedLoops: " + String.valueOf(this.mNestedLoops)));
                this.mNestedLoops.pop();
                this.mLogger.debug((Object)("----pop mNestedLoops: " + String.valueOf(this.mNestedLoops)));
                this.mLogger.debug((Object)"");
                return;
            }
            this.mLogger.debug((Object)("----old mGraph: " + String.valueOf(this.mGraph.values())));
            this.mLogger.debug((Object)"----new mGraph: fresh");
            this.mGraphs.push(this.mGraph);
            this.mGraph = new HashMap();
        } else if (aRTEdge.isNestedLoopExit()) {
            this.mNestedLoops.push(icfgEdge);
            string2 = this.mGraph.values().toString();
            this.mGraph = this.mGraphs.pop();
            aRTEdge.mLastGraphState = this.mGraph;
            this.mLogger.debug((Object)("--push (nestedLoop) " + String.valueOf(icfgEdge)));
            this.mLogger.debug((Object)("----old mGraph: " + string2));
            this.mLogger.debug((Object)("----new mGraph: " + String.valueOf(this.mGraph.values())));
        }
        list.add(aRTEdge);
        this.mCurrentPath.add(aRTEdge.mBacking);
        this.pre(aRTEdge.mBacking);
        this.pre((IcfgLocation)aRTEdge.mBacking.getTarget());
        if (aRTEdge.getTarget().getOutgoingEdges().isEmpty()) {
            this.mPaths.add(new ArrayList<ARTEdge>(list));
            this.mLogger.debug((Object)"");
            this.mLogger.debug((Object)("Trace: " + this.traceToString(list)));
            this.mLogger.debug((Object)("mCalls: " + String.valueOf(this.mCalls)));
            this.mLogger.debug((Object)("mNestedLoops: " + String.valueOf(this.mNestedLoops)));
            this.mLogger.debug((Object)"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ End @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            this.mLogger.debug((Object)"");
            this.programExitReached();
            return;
        }
        for (String string2 : aRTEdge.getTarget().getOutgoingEdges()) {
            if (this.isFeasible((IcfgEdge)string2)) {
                this.process((IcfgEdge)string2, list);
                this.post(aRTEdge.mBacking);
                this.post((IcfgLocation)aRTEdge.mBacking.getTarget());
                continue;
            }
            this.mLogger.debug((Object)("--infeasible: " + String.valueOf(string2)));
        }
        this.backtrack(aRTEdge, list);
    }

    protected void backtrack(ARTEdge aRTEdge, List<ARTEdge> list) {
        this.mLogger.debug((Object)"--backtracking--");
        int n = list.size() - 1;
        while (n >= 0) {
            String string;
            ARTEdge aRTEdge2 = list.get(n);
            this.mLogger.debug((Object)("----remove from trace prefix: " + String.valueOf(aRTEdge2)));
            list.remove(n);
            this.mCurrentPath.remove(n);
            if (aRTEdge2.isNestedLoopExit()) {
                this.mNestedLoops.pop();
                this.mGraphs.push(this.mGraph);
                string = this.mGraph.values().toString();
                this.mGraph = aRTEdge2.mLastGraphState;
                this.mLogger.debug((Object)("----pop (nestedLoopExit) " + String.valueOf(aRTEdge2.mBacking)));
                this.mLogger.debug((Object)("------old mGraph: " + string));
                this.mLogger.debug((Object)("------new mGraph: " + String.valueOf(this.mGraph.values())));
            } else if (aRTEdge2.isNestedLoopEntry()) {
                this.mNestedLoops.pop();
                string = this.mGraph.values().toString();
                this.mGraph = this.mGraphs.pop();
                this.mLogger.debug((Object)("----pop (nestedLoopEntry) " + String.valueOf(aRTEdge2.mBacking)));
                this.mLogger.debug((Object)("------old mGraph: " + string));
                this.mLogger.debug((Object)("------new mGraph: " + String.valueOf(this.mGraph.values())));
            }
            if (aRTEdge2.mBacking instanceof Return) {
                this.mCalls.push((IcfgEdge)((Return)aRTEdge2.mBacking).getCorrespondingCall());
                this.mGraphs.push(this.mGraph);
                string = this.mGraph.values().toString();
                this.mGraph = aRTEdge2.mLastGraphState;
                this.mLogger.debug((Object)("----push (return) " + String.valueOf(aRTEdge2.mBacking)));
                this.mLogger.debug((Object)("------old mGraph: " + string));
                this.mLogger.debug((Object)("------new mGraph: " + String.valueOf(this.mGraph.values())));
            } else if (aRTEdge2.mBacking instanceof Call) {
                this.mCalls.pop();
                string = this.mGraph.values().toString();
                this.mGraph = this.mGraphs.pop();
                this.mLogger.debug((Object)("----pop (call) " + String.valueOf(aRTEdge2.mBacking)));
                this.mLogger.debug((Object)("------old mGraph: " + string));
                this.mLogger.debug((Object)("------new mGraph: " + String.valueOf(this.mGraph.values())));
            }
            this.mLogger.debug((Object)("----change visit counter in mGraph: " + String.valueOf(aRTEdge2.mBacking)));
            if (!this.mGraph.containsKey(aRTEdge2.mBacking)) {
                this.mLogger.debug((Object)("------not in current mGraph (so visit is 0): " + String.valueOf(aRTEdge2.mBacking)));
            } else {
                --this.mGraph.get((Object)aRTEdge2.mBacking).mVisited;
            }
            if (aRTEdge.equals(aRTEdge2)) break;
            --n;
        }
        this.mLogger.debug((Object)("--trace prefix: " + this.traceToString(list)));
        this.mLogger.debug((Object)("--mCalls: " + String.valueOf(this.mCalls)));
        this.mLogger.debug((Object)("--mNestedLoops: " + String.valueOf(this.mNestedLoops)));
        this.mLogger.debug((Object)"--end backtracking--");
        this.mLogger.debug((Object)"");
    }

    protected void findLoopEntryExit(IcfgLocation icfgLocation) {
        if (LoopEntryAnnotation.getAnnotation((IElement)icfgLocation) != null) {
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                if (!((IcfgLocation)icfgEdge.getTarget()).equals((Object)icfgLocation)) continue;
                this.addAnnotation(icfgEdge, icfgLocation, true, true);
                return;
            }
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                IcfgEdge icfgEdge2 = this.findBackedge(icfgEdge, icfgLocation, new HashSet<IcfgEdge>());
                if (icfgEdge2 == null) continue;
                this.addAnnotation(icfgEdge, icfgLocation, true, false);
                this.addAnnotation(icfgEdge2, icfgLocation, false, true);
            }
        }
    }

    protected void addAnnotation(IcfgEdge icfgEdge, IcfgLocation icfgLocation, boolean bl, boolean bl2) {
        new RCFGUnrollWalkerAnnotation(icfgLocation, bl, bl2).addAnnotation((IElement)icfgEdge);
    }

    protected IcfgEdge findBackedge(IcfgEdge icfgEdge, IcfgLocation icfgLocation, HashSet<IcfgEdge> hashSet) {
        if (((IcfgLocation)icfgEdge.getTarget()).equals((Object)icfgLocation)) {
            return icfgEdge;
        }
        hashSet.add(icfgEdge);
        for (IcfgEdge icfgEdge2 : ((IcfgLocation)icfgEdge.getTarget()).getOutgoingEdges()) {
            IcfgEdge icfgEdge3;
            if (hashSet.contains(icfgEdge2) || (icfgEdge3 = this.findBackedge(icfgEdge2, icfgLocation, hashSet)) == null || !((IcfgLocation)icfgEdge3.getTarget()).equals((Object)icfgLocation)) continue;
            return icfgEdge3;
        }
        return null;
    }

    protected boolean isMaxCallDepth(IcfgEdge icfgEdge) {
        int n = 0;
        for (IcfgEdge icfgEdge2 : this.mCalls) {
            if (!icfgEdge.equals(icfgEdge2)) continue;
            ++n;
        }
        return n > this.mUnrollings;
    }

    protected boolean isMaxLoopDepth(ARTEdge aRTEdge) {
        int n = 0;
        for (IcfgEdge icfgEdge : this.mNestedLoops) {
            if (!aRTEdge.mBacking.equals(icfgEdge)) continue;
            ++n;
        }
        return n > this.mUnrollings;
    }

    protected boolean isFeasible(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof Summary) {
            return false;
        }
        if (icfgEdge instanceof Return) {
            if (this.mCalls.isEmpty()) {
                return false;
            }
            return ((Return)icfgEdge).getCorrespondingCall().equals(this.mCalls.peek());
        }
        return true;
    }

    protected String traceToString(List<ARTEdge> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ARTEdge aRTEdge : list) {
            stringBuilder.append(aRTEdge.mBacking);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    protected ARTEdge createEdge(IcfgEdge icfgEdge) {
        ARTEdge aRTEdge;
        if (this.mGraph.containsKey(icfgEdge)) {
            aRTEdge = this.mGraph.get(icfgEdge);
        } else {
            aRTEdge = new ARTEdge(icfgEdge);
            this.mGraph.put(icfgEdge, aRTEdge);
        }
        return aRTEdge;
    }

    private static class ARTEdge {
        private final IcfgEdge mBacking;
        private int mVisited;
        private HashMap<IcfgEdge, ARTEdge> mLastGraphState;

        public ARTEdge(IcfgEdge icfgEdge) {
            this.mBacking = icfgEdge;
            this.mVisited = 1;
        }

        public void visit() {
            ++this.mVisited;
        }

        public boolean isVisited(int n) {
            return this.mVisited > n;
        }

        public IcfgLocation getTarget() {
            return (IcfgLocation)this.mBacking.getTarget();
        }

        public IcfgLocation getSource() {
            return (IcfgLocation)this.mBacking.getSource();
        }

        public String toString() {
            if (this.isLoopEntry() && this.isLoopExit()) {
                return this.mBacking.toString() + " (visited=" + this.mVisited + ", isLoopEntry&Exit, honda=" + String.valueOf(this.getLoopHead()) + ")";
            }
            if (this.isLoopEntry()) {
                return this.mBacking.toString() + " (visited=" + this.mVisited + ", isLoopEntry, honda=" + String.valueOf(this.getLoopHead()) + ")";
            }
            if (this.isLoopExit()) {
                return this.mBacking.toString() + " (visited=" + this.mVisited + ", isLoopExit, honda=" + String.valueOf(this.getLoopHead()) + ")";
            }
            return this.mBacking.toString() + " (visited=" + this.mVisited + ")";
        }

        private boolean isLoopEntry() {
            RCFGUnrollWalkerAnnotation rCFGUnrollWalkerAnnotation = this.getAnnotation();
            if (rCFGUnrollWalkerAnnotation != null) {
                return rCFGUnrollWalkerAnnotation.isLoopEntry();
            }
            return false;
        }

        private boolean isLoopExit() {
            RCFGUnrollWalkerAnnotation rCFGUnrollWalkerAnnotation = this.getAnnotation();
            if (rCFGUnrollWalkerAnnotation != null) {
                return rCFGUnrollWalkerAnnotation.isLoopExit();
            }
            return false;
        }

        private boolean isNestedLoopEntry() {
            RCFGUnrollWalkerAnnotation rCFGUnrollWalkerAnnotation = this.getAnnotation();
            if (rCFGUnrollWalkerAnnotation != null) {
                return !rCFGUnrollWalkerAnnotation.isLoopExit() && rCFGUnrollWalkerAnnotation.isLoopEntry();
            }
            return false;
        }

        private boolean isNestedLoopExit() {
            RCFGUnrollWalkerAnnotation rCFGUnrollWalkerAnnotation = this.getAnnotation();
            if (rCFGUnrollWalkerAnnotation != null) {
                return rCFGUnrollWalkerAnnotation.isLoopExit() && !rCFGUnrollWalkerAnnotation.isLoopEntry();
            }
            return false;
        }

        private IcfgLocation getLoopHead() {
            RCFGUnrollWalkerAnnotation rCFGUnrollWalkerAnnotation = this.getAnnotation();
            if (rCFGUnrollWalkerAnnotation != null) {
                return rCFGUnrollWalkerAnnotation.getHonda();
            }
            return null;
        }

        private RCFGUnrollWalkerAnnotation getAnnotation() {
            return (RCFGUnrollWalkerAnnotation)((Object)IRSDependenciesAnnotation.getAnnotation((IElement)this.mBacking, IRSDependenciesAnnotation.class));
        }
    }
}

