/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeRun;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.GetRandomDftaBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.IsIncluded;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.difference.Difference;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.difference.LazyDifference;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.isTotal;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.Minimize;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Optional;

public final class IsEquivalent<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>> {
    private TreeRun<LETTER, STATE> mCounterexample;
    private String mExitMessage;
    private final ITreeAutomatonBU<LETTER, STATE> mFirstOperand;
    private final boolean mResult;
    private final ITreeAutomatonBU<LETTER, STATE> mSecondOperand;

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> IsEquivalent(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU2) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mFirstOperand = iTreeAutomatonBU;
        this.mSecondOperand = iTreeAutomatonBU2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.checkEquivalence(SF);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        assert (this.mExitMessage != null) : "Unknown problem with exit message.";
        return this.mExitMessage;
    }

    public Optional<TreeRun<LETTER, STATE>> getCounterexample() {
        if (this.mResult) {
            return Optional.empty();
        }
        return Optional.of(this.mCounterexample);
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    private <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> boolean checkEquivalence(SF SF) throws AutomataOperationCanceledException {
        this.mLogger.debug((Object)"Starting to compute isIncluded(first, second).");
        if (!this.checkInclusion(SF, this.mFirstOperand, this.mSecondOperand)) {
            this.mExitMessage = "The first operand recognizes a word not recognized by the second one.";
            return false;
        }
        if (this.mServices.getProgressAwareTimer() != null && this.isCancellationRequested()) {
            this.mLogger.debug((Object)"Stopped after isIncluded(first, second).");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        this.mLogger.debug((Object)"Starting to compute isIncluded(second, first).");
        if (!this.checkInclusion(SF, this.mSecondOperand, this.mFirstOperand)) {
            this.mExitMessage = "The second operand recognizes a word not recognized by the first one.";
            return false;
        }
        this.mExitMessage = "The operands are equivalent";
        return true;
    }

    private <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> boolean checkInclusion(SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU2) throws AutomataOperationCanceledException {
        IsIncluded<LETTER, STATE> isIncluded = new IsIncluded<LETTER, STATE>(this.mServices, SF, iTreeAutomatonBU, iTreeAutomatonBU2);
        if (!isIncluded.getResult().booleanValue()) {
            this.mCounterexample = isIncluded.getCounterexample().get();
            return false;
        }
        return true;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    public static void main(String[] stringArray) throws AutomataOperationCanceledException {
        AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices((IUltimateServiceProvider)new ToolchainStorage());
        StringFactory stringFactory = new StringFactory();
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[2] = 4;
        nArray[3] = 3;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[2] = 2;
        nArray3[3] = 1;
        int[] nArray4 = nArray3;
        GetRandomDftaBU getRandomDftaBU = new GetRandomDftaBU(automataLibraryServices, 4, nArray2, nArray4, 0.2, 41L);
        TreeAutomatonBU treeAutomatonBU = getRandomDftaBU.getResult();
        Object object = new Minimize(automataLibraryServices, stringFactory, treeAutomatonBU).getResult();
        GetRandomDftaBU getRandomDftaBU2 = new GetRandomDftaBU(automataLibraryServices, 4, nArray2, nArray4, 0.2, 10007L);
        TreeAutomatonBU treeAutomatonBU2 = getRandomDftaBU2.getResult();
        IsEquivalent isEquivalent = new IsEquivalent(automataLibraryServices, stringFactory, treeAutomatonBU, object);
        GetRandomDftaBU getRandomDftaBU3 = new GetRandomDftaBU(automataLibraryServices, 4, nArray2, nArray4, 0.2, 71L);
        TreeAutomatonBU treeAutomatonBU3 = getRandomDftaBU3.getResult();
        assert (new IsEquivalent(automataLibraryServices, stringFactory, new LazyDifference(automataLibraryServices, stringFactory, treeAutomatonBU, treeAutomatonBU2).getResult(), new Difference(automataLibraryServices, stringFactory, treeAutomatonBU, treeAutomatonBU2).getResult()).getResult().booleanValue());
        assert (new IsEquivalent(automataLibraryServices, stringFactory, new LazyDifference(automataLibraryServices, stringFactory, treeAutomatonBU, treeAutomatonBU3).getResult(), new Difference(automataLibraryServices, stringFactory, treeAutomatonBU, treeAutomatonBU3).getResult()).getResult().booleanValue());
        assert (!new isTotal(automataLibraryServices, treeAutomatonBU).getResult().booleanValue());
        assert (!new isTotal(automataLibraryServices, treeAutomatonBU2).getResult().booleanValue());
        assert (!new isTotal(automataLibraryServices, treeAutomatonBU3).getResult().booleanValue());
        if (isEquivalent.getResult().booleanValue()) {
            System.out.println("Is equivalent.");
        } else {
            System.out.println("Is not equivalent, counterexample:");
            System.out.println(isEquivalent.getCounterexample().get());
        }
    }
}

