/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.MultipleDataOption;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SimulationPerformance {
    public static final int NO_COUNTING_RESULT = -1;
    public static final long NO_TIME_RESULT = -1L;
    private final LinkedHashMap<CountingMeasure, Integer> mCountingMeasures;
    private final boolean mIsUsingSccs;
    private String mName;
    private boolean mOutOfMemory;
    private final SimulationOrMinimizationType mSimType;
    private boolean mTimedOut;
    private final LinkedHashMap<TimeMeasure, List<Long>> mTimeMeasures;
    private final LinkedHashMap<TimeMeasure, Long> mTimeMeasureStartTimes;

    public SimulationPerformance(SimulationOrMinimizationType simulationOrMinimizationType, boolean bl) {
        this.mSimType = simulationOrMinimizationType;
        this.mTimeMeasures = new LinkedHashMap();
        this.mTimeMeasureStartTimes = new LinkedHashMap();
        this.mCountingMeasures = new LinkedHashMap();
        this.mIsUsingSccs = bl;
        this.mTimedOut = false;
        this.mOutOfMemory = false;
        this.mName = "";
    }

    public static StatisticsType convertCountingMeasureToStatistic(CountingMeasure countingMeasure) {
        if (countingMeasure.equals((Object)CountingMeasure.BUCHI_STATES)) {
            return StatisticsType.STATES_INPUT;
        }
        if (countingMeasure.equals((Object)CountingMeasure.RESULT_STATES)) {
            return StatisticsType.STATES_OUTPUT;
        }
        if (countingMeasure.equals((Object)CountingMeasure.REMOVED_STATES)) {
            return StatisticsType.STATES_REDUCTION_ABSOLUTE;
        }
        return StatisticsType.valueOf(countingMeasure.name());
    }

    public static StatisticsType convertTimeMeasureToStatistic(TimeMeasure timeMeasure) {
        if (timeMeasure.equals((Object)TimeMeasure.OVERALL)) {
            return StatisticsType.TIME_SIMULATION_OLD;
        }
        return StatisticsType.valueOf(timeMeasure.name());
    }

    public static SimulationPerformance createOutOfMemoryPerformance(SimulationOrMinimizationType simulationOrMinimizationType, boolean bl) {
        SimulationPerformance simulationPerformance = new SimulationPerformance(simulationOrMinimizationType, bl);
        simulationPerformance.outOfMemory();
        return simulationPerformance;
    }

    public static SimulationPerformance createTimedOutPerformance(SimulationOrMinimizationType simulationOrMinimizationType, boolean bl) {
        SimulationPerformance simulationPerformance = new SimulationPerformance(simulationOrMinimizationType, bl);
        simulationPerformance.timeOut();
        return simulationPerformance;
    }

    public void addAllMeasures(SimulationPerformance simulationPerformance) {
        LinkedHashMap<CountingMeasure, Integer> linkedHashMap = simulationPerformance.getCountingMeasures();
        LinkedHashMap<TimeMeasure, List<Long>> linkedHashMap2 = simulationPerformance.getTimeMeasures();
        for (Map.Entry<TimeMeasure, List<Long>> entry : linkedHashMap2.entrySet()) {
            for (Long l : entry.getValue()) {
                this.addTimeMeasureValue(entry.getKey(), l);
            }
        }
        for (Map.Entry<Enum, Object> entry : linkedHashMap.entrySet()) {
            int n;
            int n2 = n = this.getCountingMeasureResult((CountingMeasure)entry.getKey());
            n2 = n != -1 ? (n2 += ((Integer)entry.getValue()).intValue()) : (Integer)entry.getValue();
            if (n2 == -1 || n2 == n) continue;
            this.setCountingMeasure((CountingMeasure)entry.getKey(), n2);
        }
    }

    public void addTimeMeasureValue(TimeMeasure timeMeasure, long l) {
        if (!this.mTimeMeasures.containsKey((Object)timeMeasure)) {
            this.mTimeMeasures.put(timeMeasure, new LinkedList());
        }
        this.mTimeMeasures.get((Object)timeMeasure).add(l);
    }

    public AutomataOperationStatistics exportToAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        this.exportToExistingAutomataOperationStatistics(automataOperationStatistics);
        return automataOperationStatistics;
    }

    public void exportToExistingAutomataOperationStatistics(AutomataOperationStatistics automataOperationStatistics) {
        automataOperationStatistics.addKeyValuePair(StatisticsType.HAS_TIMED_OUT, this.hasTimedOut());
        automataOperationStatistics.addKeyValuePair(StatisticsType.IS_OUT_OF_MEMORY, this.isOutOfMemory());
        automataOperationStatistics.addKeyValuePair(StatisticsType.IS_USING_SCCS, this.isUsingSccs());
        for (TimeMeasure timeMeasure : this.getTimeMeasures().keySet()) {
            long l = this.getTimeMeasureResult(timeMeasure, MultipleDataOption.ADDITIVE);
            if (l == -1L) continue;
            automataOperationStatistics.addKeyValuePair(SimulationPerformance.convertTimeMeasureToStatistic(timeMeasure), l);
        }
    }

    public int getCountingMeasureResult(CountingMeasure countingMeasure) {
        if (!this.mCountingMeasures.containsKey((Object)countingMeasure)) {
            return -1;
        }
        return this.mCountingMeasures.get((Object)countingMeasure);
    }

    public LinkedHashMap<CountingMeasure, Integer> getCountingMeasures() {
        return this.mCountingMeasures;
    }

    public String getName() {
        return this.mName;
    }

    public SimulationOrMinimizationType getSimType() {
        return this.mSimType;
    }

    public long getTimeMeasureResult(TimeMeasure timeMeasure, MultipleDataOption multipleDataOption) {
        List<Long> list = this.mTimeMeasures.get((Object)timeMeasure);
        if (list == null || list.isEmpty()) {
            return -1L;
        }
        long l = 0L;
        for (long l2 : list) {
            if (l2 == -1L) continue;
            if (multipleDataOption.equals((Object)MultipleDataOption.ADDITIVE) || multipleDataOption.equals((Object)MultipleDataOption.AVERAGE)) {
                l += l2;
                continue;
            }
            if (multipleDataOption.equals((Object)MultipleDataOption.MAXIMUM)) {
                if (l2 <= l) continue;
                l = l2;
                continue;
            }
            if (!multipleDataOption.equals((Object)MultipleDataOption.MINIMIUM) || l2 >= l) continue;
            l = l2;
        }
        if (multipleDataOption.equals((Object)MultipleDataOption.AVERAGE)) {
            l = Math.round(((double)l + 0.0) / (double)list.size());
        }
        if (l <= 0L) {
            return -1L;
        }
        return l;
    }

    public List<Long> getTimeMeasureResults(TimeMeasure timeMeasure) {
        return this.mTimeMeasures.get((Object)timeMeasure);
    }

    public LinkedHashMap<TimeMeasure, List<Long>> getTimeMeasures() {
        return this.mTimeMeasures;
    }

    public boolean hasTimedOut() {
        return this.mTimedOut;
    }

    public void increaseCountingMeasure(CountingMeasure countingMeasure) {
        if (!this.mCountingMeasures.containsKey((Object)countingMeasure)) {
            this.mCountingMeasures.put(countingMeasure, 1);
        } else {
            int n = this.mCountingMeasures.get((Object)countingMeasure);
            this.mCountingMeasures.put(countingMeasure, n + 1);
        }
    }

    public boolean isOutOfMemory() {
        return this.mOutOfMemory;
    }

    public boolean isUsingSccs() {
        return this.mIsUsingSccs;
    }

    public void outOfMemory() {
        this.mOutOfMemory = true;
    }

    public void setCountingMeasure(CountingMeasure countingMeasure, int n) {
        if (n != 0) {
            this.mCountingMeasures.put(countingMeasure, n);
        }
    }

    public void setName(String string) {
        this.mName = string;
    }

    public void startTimeMeasure(TimeMeasure timeMeasure) {
        long l = System.currentTimeMillis();
        this.mTimeMeasureStartTimes.put(timeMeasure, l);
    }

    public long stopTimeMeasure(TimeMeasure timeMeasure) {
        long l = System.currentTimeMillis();
        long l2 = this.mTimeMeasureStartTimes.get((Object)timeMeasure);
        if (!this.mTimeMeasureStartTimes.containsKey((Object)timeMeasure)) {
            l2 = 0L;
        }
        long l3 = l - l2;
        this.saveTimeMeasureResult(timeMeasure, l3);
        return l3;
    }

    public void timeOut() {
        this.mTimedOut = true;
    }

    private void saveTimeMeasureResult(TimeMeasure timeMeasure, long l) {
        List<Long> list = this.mTimeMeasures.get((Object)timeMeasure);
        if (list == null) {
            list = new LinkedList<Long>();
            this.mTimeMeasures.put(timeMeasure, list);
        }
        list.add(l);
    }
}

