/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class GhostUpdate
extends CodeStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(GhostUpdate.class);
    String identifier;
    Expression expr;

    public GhostUpdate(String string, Expression expression) {
        this.identifier = string;
        this.expr = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid GhostUpdate: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GhostUpdate").append('[');
        stringBuffer.append(this.identifier);
        stringBuffer.append(',').append(this.expr);
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Expression getExpr() {
        return this.expr;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.expr);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((CodeStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.expr != null) {
            this.expr.accept(aCSLVisitor);
        }
    }

    @Override
    public CodeStatement accept(ACSLTransformer aCSLTransformer) {
        CodeStatement codeStatement = aCSLTransformer.transform(this);
        if (codeStatement != this) {
            return codeStatement;
        }
        Expression expression = null;
        if (this.expr != null) {
            expression = this.expr.accept(aCSLTransformer);
        }
        if (this.expr != expression) {
            return new GhostUpdate(this.identifier, expression);
        }
        return this;
    }
}

