/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.NonDeclaringTermTransferrer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TermTransferrer
extends NonDeclaringTermTransferrer {
    protected final HistoryRecordingScript mOldScript;
    protected final HistoryRecordingScript mNewScript;
    protected final Map<Term, Term> mTransferMapping;

    public TermTransferrer(Script script, Script script2) {
        this(script, script2, new HashMap<Term, Term>(), false);
    }

    public TermTransferrer(Script script, Script script2, Map<Term, Term> map, boolean bl) {
        super(script2, bl);
        this.mOldScript = Objects.requireNonNull(HistoryRecordingScript.extractHistoryRecordingScript(script), "no HistoryRecordingScript");
        this.mNewScript = Objects.requireNonNull(HistoryRecordingScript.extractHistoryRecordingScript(script2), "no HistoryRecordingScript");
        this.mTransferMapping = map;
    }

    public Map<Term, Term> getTransferMapping() {
        return this.mTransferMapping;
    }

    @Override
    protected void convert(Term term) {
        Term term2 = this.mTransferMapping.get(term);
        if (term2 != null) {
            this.setResult(term2);
        } else {
            super.convert(term);
        }
    }

    @Override
    public Sort transferSort(Sort sort) {
        String string = sort.getName();
        if (!sort.isInternal() && !this.mNewScript.getSymbolTable().containsKey(string)) {
            ISmtDeclarable iSmtDeclarable = this.mOldScript.getSymbolTable().get(string);
            iSmtDeclarable.defineOrDeclare((Script)this.mNewScript);
        }
        return super.transferSort(sort);
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        String string = functionSymbol.getName();
        if (!functionSymbol.isIntern() && !this.mNewScript.getSymbolTable().containsKey(string)) {
            ISmtDeclarable iSmtDeclarable = this.mOldScript.getSymbolTable().get(string);
            iSmtDeclarable.defineOrDeclare((Script)this.mNewScript);
        }
        super.convertApplicationTerm(applicationTerm, termArray);
    }

    @Override
    public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
        TermVariable[] termVariableArray = new TermVariable[letTerm.getVariables().length];
        int n = 0;
        while (n < letTerm.getVariables().length) {
            termVariableArray[n] = this.mTransferMapping.containsKey(letTerm.getVariables()[n]) ? (TermVariable)this.mTransferMapping.get(letTerm.getVariables()[n]) : this.transferTermVariable(letTerm.getVariables()[n]);
            ++n;
        }
        Term term2 = this.mNewScript.let(termVariableArray, termArray, term);
        this.setResult(term2);
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        TermVariable[] termVariableArray = new TermVariable[quantifiedFormula.getVariables().length];
        int n = 0;
        while (n < quantifiedFormula.getVariables().length) {
            termVariableArray[n] = this.mTransferMapping.containsKey(quantifiedFormula.getVariables()[n]) ? (TermVariable)this.mTransferMapping.get(quantifiedFormula.getVariables()[n]) : this.transferTermVariable(quantifiedFormula.getVariables()[n]);
            ++n;
        }
        Term term2 = this.mNewScript.quantifier(quantifiedFormula.getQuantifier(), termVariableArray, term, new Term[0][]);
        this.setResult(term2);
    }
}

