/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprGroundLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprQuantifiedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackDecisionLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class EprPredicate {
    private final int mArity;
    private final FunctionSymbol mFunctionSymbol;
    protected final SortedSet<TermVariable> mSignature;
    final EprTheory mEprTheory;
    private final HashMap<EprClause, HashSet<ClauseEprLiteral>> mQuantifiedOccurences = new HashMap();
    private final HashMap<EprClause, HashSet<ClauseEprLiteral>> mGroundOccurences = new HashMap();
    private final HashSet<EprGroundPredicateAtom> mDPLLAtoms = new HashSet();
    private final HashMap<TermTuple, EprGroundPredicateAtom> mPointToAtom = new HashMap();
    private final HashMap<TermTuple, EprQuantifiedPredicateAtom> mTermTupleToAtom = new HashMap();
    private DawgState<ApplicationTerm, EprTheory.TriBool> mCurrentDecision;

    public EprPredicate(FunctionSymbol functionSymbol, EprTheory eprTheory) {
        this.mFunctionSymbol = functionSymbol;
        this.mArity = functionSymbol.getParameterSorts().length;
        this.mEprTheory = eprTheory;
        TreeSet treeSet = new TreeSet(EprHelpers.getColumnNamesComparator());
        int n = 0;
        while (n < this.mArity) {
            String string = this.mFunctionSymbol.getName() + "_" + n;
            treeSet.add(this.mEprTheory.getTheory().createFreshTermVariable(string, functionSymbol.getParameterSorts()[n]));
            ++n;
        }
        this.mSignature = treeSet;
        this.mCurrentDecision = this.mEprTheory.getDawgFactory().createConstantDawg(this.mSignature, EprTheory.TriBool.UNKNOWN);
    }

    public void addQuantifiedOccurence(ClauseEprQuantifiedLiteral clauseEprQuantifiedLiteral, EprClause eprClause) {
        HashSet<ClauseEprLiteral> hashSet = this.mQuantifiedOccurences.get(eprClause);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.mQuantifiedOccurences.put(eprClause, hashSet);
        }
        hashSet.add(clauseEprQuantifiedLiteral);
    }

    private HashMap<EprClause, HashSet<ClauseEprLiteral>> getQuantifiedOccurences() {
        return this.mQuantifiedOccurences;
    }

    public EprTheory getEprTheory() {
        return this.mEprTheory;
    }

    public DawgState<ApplicationTerm, EprTheory.TriBool> getDawg() {
        return this.mCurrentDecision;
    }

    public SortedSet<TermVariable> getSignature() {
        return this.mSignature;
    }

    public void setDawg(DawgState<ApplicationTerm, EprTheory.TriBool> dawgState) {
        this.mCurrentDecision = dawgState;
    }

    public void addGroundOccurence(ClauseEprGroundLiteral clauseEprGroundLiteral, EprClause eprClause) {
        HashSet<ClauseEprLiteral> hashSet = this.mGroundOccurences.get(eprClause);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.mGroundOccurences.put(eprClause, hashSet);
        }
        hashSet.add(clauseEprGroundLiteral);
    }

    private HashMap<EprClause, HashSet<ClauseEprLiteral>> getGroundOccurences() {
        return this.mGroundOccurences;
    }

    public HashMap<EprClause, HashSet<ClauseEprLiteral>> getAllEprClauseOccurences() {
        HashMap<EprClause, HashSet<ClauseEprLiteral>> hashMap = this.getQuantifiedOccurences();
        HashMap<EprClause, HashSet<ClauseEprLiteral>> hashMap2 = this.getGroundOccurences();
        HashMap<EprClause, HashSet<ClauseEprLiteral>> hashMap3 = new HashMap<EprClause, HashSet<ClauseEprLiteral>>(hashMap);
        for (Map.Entry<EprClause, HashSet<ClauseEprLiteral>> entry : hashMap2.entrySet()) {
            if (hashMap3.containsKey(entry.getKey())) {
                hashMap3.get(entry.getKey()).addAll((Collection<ClauseEprLiteral>)entry.getValue());
                continue;
            }
            hashMap3.put(entry.getKey(), entry.getValue());
        }
        return hashMap3;
    }

    public void addDPLLAtom(EprGroundPredicateAtom eprGroundPredicateAtom) {
        this.mDPLLAtoms.add(eprGroundPredicateAtom);
    }

    public HashSet<EprGroundPredicateAtom> getDPLLAtoms() {
        return this.mDPLLAtoms;
    }

    private EprGroundPredicateAtom getAtomForPoint(TermTuple termTuple, Theory theory, int n, SourceAnnotation sourceAnnotation) {
        assert (termTuple.getFreeVars().size() == 0) : "Use getAtomForTermTuple, if tt is quantified";
        EprGroundPredicateAtom eprGroundPredicateAtom = this.mPointToAtom.get(termTuple);
        if (eprGroundPredicateAtom == null) {
            ApplicationTerm applicationTerm = (ApplicationTerm)theory.term(this.mFunctionSymbol, termTuple.terms);
            int n2 = applicationTerm.hashCode();
            eprGroundPredicateAtom = this instanceof EprEqualityPredicate ? new EprGroundEqualityAtom(applicationTerm, n2, n, (EprEqualityPredicate)this, sourceAnnotation) : new EprGroundPredicateAtom(applicationTerm, n2, n, this, sourceAnnotation);
            this.mPointToAtom.put(termTuple, eprGroundPredicateAtom);
            this.addDPLLAtom(eprGroundPredicateAtom);
        }
        return eprGroundPredicateAtom;
    }

    private EprQuantifiedPredicateAtom getAtomForQuantifiedTermTuple(TermTuple termTuple, Theory theory, int n, SourceAnnotation sourceAnnotation) {
        assert (termTuple.getFreeVars().size() > 0) : "Use getAtomForPoint, if tt is ground";
        EprQuantifiedPredicateAtom eprQuantifiedPredicateAtom = this.mTermTupleToAtom.get(termTuple);
        if (eprQuantifiedPredicateAtom == null) {
            ApplicationTerm applicationTerm = (ApplicationTerm)theory.term(this.mFunctionSymbol, termTuple.terms);
            eprQuantifiedPredicateAtom = this instanceof EprEqualityPredicate ? new EprQuantifiedEqualityAtom(applicationTerm, 0, n, (EprEqualityPredicate)this, sourceAnnotation) : new EprQuantifiedPredicateAtom(applicationTerm, 0, n, this, sourceAnnotation);
            this.mTermTupleToAtom.put(termTuple, eprQuantifiedPredicateAtom);
        }
        return eprQuantifiedPredicateAtom;
    }

    public EprPredicateAtom getAtomForTermTuple(TermTuple termTuple, Theory theory, int n, SourceAnnotation sourceAnnotation) {
        if (termTuple.getFreeVars().size() > 0) {
            return this.getAtomForQuantifiedTermTuple(termTuple, theory, n, sourceAnnotation);
        }
        return this.getAtomForPoint(termTuple, theory, n, sourceAnnotation);
    }

    public String toString() {
        String string = "EprPred: " + this.mFunctionSymbol.getName();
        if (string.contains("AUX")) {
            return "EprPred: (AUX " + this.hashCode() + ")";
        }
        return string;
    }

    public DecideStackEntry getNextDecision() {
        EprTheory.TriBool triBool = this instanceof EprEqualityPredicate ? EprTheory.TriBool.TRUE : EprTheory.TriBool.FALSE;
        DawgState<ApplicationTerm, EprTheory.TriBool> dawgState = this.mEprTheory.getDawgFactory().createMapped(this.getDawg(), triBool2 -> triBool2 == EprTheory.TriBool.UNKNOWN ? triBool : EprTheory.TriBool.UNKNOWN);
        if (DawgFactory.isConstantValue(dawgState, EprTheory.TriBool.UNKNOWN)) {
            return null;
        }
        return new DecideStackDecisionLiteral(this, dawgState);
    }

    public void notifyAboutClauseDisposal(EprClause eprClause) {
        this.mQuantifiedOccurences.remove(eprClause);
        this.mGroundOccurences.remove(eprClause);
    }

    public int getArity() {
        return this.mArity;
    }

    public FunctionSymbol getFunctionSymbol() {
        return this.mFunctionSymbol;
    }

    public SortedSet<TermVariable> getTermVariablesForArguments() {
        return this.mSignature;
    }

    public Sort[] getSorts() {
        return this.mFunctionSymbol.getParameterSorts();
    }
}

