/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.symboltable;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BoogieSymbolTable {
    private final Map<DeclarationInformation.StorageClass, Map<String, Map<String, Declaration>>> mSymbolTable = new LinkedHashMap<DeclarationInformation.StorageClass, Map<String, Map<String, Declaration>>>();

    protected void addProcedureOrFunction(String string, Procedure procedure) {
        Map<String, Declaration> map = this.getProcedureMap(procedure);
        if (map.containsKey(string)) {
            throw new IllegalArgumentException("procedure declared twice: " + string);
        }
        map.put(string, (Declaration)procedure);
    }

    protected void addProcedureOrFunction(String string, FunctionDeclaration functionDeclaration) {
        this.addSymbol(DeclarationInformation.StorageClass.PROC_FUNC, null, string, (Declaration)functionDeclaration);
    }

    protected void addInParams(String string, String string2, Procedure procedure) {
        if (BoogieSymbolTable.isImplementation(procedure)) {
            this.addSymbol(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string, string2, (Declaration)procedure);
        } else {
            this.addSymbol(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string, string2, (Declaration)procedure);
        }
    }

    protected void addInParams(String string, String string2, FunctionDeclaration functionDeclaration) {
        this.addSymbol(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string, string2, (Declaration)functionDeclaration);
    }

    protected void addOutParams(String string, String string2, Procedure procedure) {
        if (BoogieSymbolTable.isImplementation(procedure)) {
            this.addSymbol(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, string, string2, (Declaration)procedure);
        } else {
            this.addSymbol(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string, string2, (Declaration)procedure);
        }
    }

    protected void addOutParams(String string, String string2, FunctionDeclaration functionDeclaration) {
        this.addSymbol(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string, string2, (Declaration)functionDeclaration);
    }

    protected void addLocalVariable(String string, String string2, Declaration declaration) {
        this.addSymbol(DeclarationInformation.StorageClass.LOCAL, string, string2, declaration);
    }

    protected void addGlobalVariable(String string, Declaration declaration) {
        this.addSymbol(DeclarationInformation.StorageClass.GLOBAL, null, string, declaration);
    }

    private Map<String, Declaration> getProcedureMap(Procedure procedure) {
        if (BoogieSymbolTable.isImplementation(procedure)) {
            return this.getMap(DeclarationInformation.StorageClass.IMPLEMENTATION, DeclarationInformation.StorageClass.IMPLEMENTATION.toString());
        }
        return this.getMap(DeclarationInformation.StorageClass.PROC_FUNC, DeclarationInformation.StorageClass.PROC_FUNC.toString());
    }

    private static boolean isImplementation(Procedure procedure) {
        return procedure.getSpecification() == null;
    }

    private void addSymbol(DeclarationInformation.StorageClass storageClass, String string, String string2, Declaration declaration) {
        if (string == null) {
            string = storageClass.toString();
        }
        this.AssertIsEmpty(storageClass, string, string2);
        this.getMap(storageClass, string).put(string2, declaration);
    }

    private void AssertIsEmpty(DeclarationInformation.StorageClass storageClass, String string, String string2) {
        assert (!this.getMap(storageClass, string).containsKey(string2)) : "duplicate symbol " + string2;
    }

    private Map<String, Declaration> getMap(DeclarationInformation.StorageClass storageClass, String string) {
        string = this.checkScopeName(storageClass, string);
        switch (storageClass) {
            case GLOBAL: 
            case QUANTIFIED: 
            case IMPLEMENTATION: 
            case PROC_FUNC: {
                if (!this.mSymbolTable.containsKey(storageClass)) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap();
                    LinkedHashMap linkedHashMap2 = new LinkedHashMap();
                    linkedHashMap.put(string, linkedHashMap2);
                    this.mSymbolTable.put(storageClass, linkedHashMap);
                }
                return this.mSymbolTable.get(storageClass).get(string);
            }
            case PROC_FUNC_INPARAM: 
            case PROC_FUNC_OUTPARAM: 
            case IMPLEMENTATION_INPARAM: 
            case IMPLEMENTATION_OUTPARAM: 
            case LOCAL: {
                Map<Object, Object> map;
                if (!this.mSymbolTable.containsKey(storageClass)) {
                    map = new LinkedHashMap();
                    LinkedHashMap linkedHashMap = new LinkedHashMap();
                    map.put(string, linkedHashMap);
                    this.mSymbolTable.put(storageClass, map);
                }
                if (!(map = this.mSymbolTable.get(storageClass)).containsKey(string)) {
                    map.put(string, new LinkedHashMap());
                }
                return (Map)map.get(string);
            }
        }
        throw new UnsupportedOperationException(String.format("Extend this method for the new scope %s", storageClass));
    }

    private Collection<String> getSymbolNames(DeclarationInformation.StorageClass storageClass, String string) {
        string = this.checkScopeName(storageClass, string);
        if (!this.mSymbolTable.containsKey(storageClass)) {
            return new ArrayList<String>();
        }
        Map<String, Declaration> map = this.getMap(storageClass, string);
        if (map == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        return arrayList;
    }

    private String checkScopeName(DeclarationInformation.StorageClass storageClass, String string) {
        switch (storageClass) {
            case GLOBAL: 
            case IMPLEMENTATION: 
            case PROC_FUNC: {
                return storageClass.toString();
            }
        }
        if (string == null) {
            throw new IllegalArgumentException("scopeName must be non-null");
        }
        return string;
    }

    public List<Declaration> getFunctionOrProcedureDeclaration(String string) {
        DeclarationInformation.StorageClass[] storageClassArray = new DeclarationInformation.StorageClass[]{DeclarationInformation.StorageClass.IMPLEMENTATION, DeclarationInformation.StorageClass.PROC_FUNC};
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        DeclarationInformation.StorageClass[] storageClassArray2 = storageClassArray;
        int n = storageClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeclarationInformation.StorageClass storageClass = storageClassArray2[n2];
            Declaration declaration = this.getDeclaration(string, storageClass, null);
            if (declaration != null) {
                arrayList.add(declaration);
            }
            ++n2;
        }
        return arrayList;
    }

    public Map<String, Declaration> getGlobalVariables() {
        return new HashMap<String, Declaration>(this.getMap(DeclarationInformation.StorageClass.GLOBAL, null));
    }

    public Map<String, Declaration> getLocalVariables(String string) {
        assert (string != null);
        HashMap<String, Declaration> hashMap = new HashMap<String, Declaration>(this.getMap(DeclarationInformation.StorageClass.LOCAL, string));
        hashMap.putAll(this.getMap(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string));
        hashMap.putAll(this.getMap(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, string));
        hashMap.putAll(this.getMap(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        hashMap.putAll(this.getMap(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string));
        return hashMap;
    }

    public Declaration getDeclaration(String string, DeclarationInformation.StorageClass storageClass, String string2) {
        return this.getMap(storageClass, string2).get(string);
    }

    public Declaration getDeclaration(IdentifierExpression identifierExpression) {
        return this.getDeclaration(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation().getStorageClass(), identifierExpression.getDeclarationInformation().getProcedure());
    }

    public IBoogieType getTypeForVariableSymbol(String string, DeclarationInformation.StorageClass storageClass, String string2) {
        Declaration declaration = this.getDeclaration(string, storageClass, string2);
        if (declaration == null) {
            return null;
        }
        return this.findType(declaration, string);
    }

    private IBoogieType findType(Declaration declaration, String string) {
        if (declaration instanceof VariableDeclaration) {
            return this.findType(((VariableDeclaration)declaration).getVariables(), string);
        }
        if (declaration instanceof Procedure) {
            Procedure procedure = (Procedure)declaration;
            IBoogieType iBoogieType = this.findType(procedure.getInParams(), string);
            if (iBoogieType != null) {
                return iBoogieType;
            }
            iBoogieType = this.findType(procedure.getOutParams(), string);
            if (iBoogieType != null) {
                return iBoogieType;
            }
        }
        return null;
    }

    private IBoogieType findType(VarList[] varListArray, String string) {
        VarList[] varListArray2 = varListArray;
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray2[n2];
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string2 = stringArray[n4];
                if (string2.equals(string)) {
                    return varList.getType().getBoogieType();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public String prettyPrintSymbolTable() {
        CharSequence charSequence2;
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Declaration> map = this.getMap(DeclarationInformation.StorageClass.GLOBAL, null);
        for (String object2 : map.keySet()) {
            stringBuilder.append(" * ").append(object2).append(" : ").append(this.getTypeForVariableSymbol(object2, DeclarationInformation.StorageClass.GLOBAL, null)).append("\n");
        }
        HashSet<String> hashSet = new HashSet<String>(this.getSymbolNames(DeclarationInformation.StorageClass.IMPLEMENTATION, null));
        hashSet.addAll(this.getSymbolNames(DeclarationInformation.StorageClass.PROC_FUNC, null));
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        for (CharSequence charSequence2 : hashSet) {
            List<Declaration> list = this.getFunctionOrProcedureDeclaration((String)charSequence2);
            for (Declaration declaration : list) {
                if (declaration instanceof FunctionDeclaration) {
                    stringBuilder2.append(" * ").append((String)charSequence2).append(" := ").append(declaration).append("\n");
                    this.appendLocals(stringBuilder2, (String)charSequence2);
                    continue;
                }
                Procedure procedure = (Procedure)declaration;
                if (BoogieSymbolTable.isImplementation(procedure)) {
                    stringBuilder4.append(" * ").append(this.prettyPrintProcedureSignature(declaration)).append("\n");
                    this.appendLocals(stringBuilder4, (String)charSequence2);
                    continue;
                }
                stringBuilder3.append(" * ").append(this.prettyPrintProcedureSignature(declaration)).append("\n");
                if (list.size() != 1) continue;
                this.appendLocals(stringBuilder3, (String)charSequence2);
            }
        }
        charSequence2 = new StringBuilder();
        if (stringBuilder.length() > 0) {
            ((StringBuilder)charSequence2).append("Globals\n");
            ((StringBuilder)charSequence2).append((CharSequence)stringBuilder);
            ((StringBuilder)charSequence2).append("\n");
        }
        if (stringBuilder3.length() > 0) {
            ((StringBuilder)charSequence2).append("Procedures\n");
            ((StringBuilder)charSequence2).append((CharSequence)stringBuilder3);
            ((StringBuilder)charSequence2).append("\n");
        }
        if (stringBuilder4.length() > 0) {
            ((StringBuilder)charSequence2).append("Implementations\n");
            ((StringBuilder)charSequence2).append((CharSequence)stringBuilder4);
            ((StringBuilder)charSequence2).append("\n");
        }
        if (stringBuilder2.length() > 0) {
            ((StringBuilder)charSequence2).append("Functions\n");
            ((StringBuilder)charSequence2).append((CharSequence)stringBuilder2);
            ((StringBuilder)charSequence2).append("\n");
        }
        return ((StringBuilder)charSequence2).toString();
    }

    private void appendLocals(StringBuilder stringBuilder, String string) {
        this.appendLocals(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, stringBuilder, string);
        this.appendLocals(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, stringBuilder, string);
        this.appendLocals(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, stringBuilder, string);
        this.appendLocals(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, stringBuilder, string);
        this.appendLocals(DeclarationInformation.StorageClass.LOCAL, stringBuilder, string);
    }

    private void appendLocals(DeclarationInformation.StorageClass storageClass, StringBuilder stringBuilder, String string) {
        Collection<String> collection = this.getSymbolNames(storageClass, string);
        if (collection.isEmpty()) {
            return;
        }
        for (String string2 : collection) {
            IBoogieType iBoogieType = this.getTypeForVariableSymbol(string2, storageClass, string);
            stringBuilder.append("  * ").append(this.shorten(storageClass)).append(" ").append(string2).append(" : ").append(iBoogieType).append("\n");
        }
    }

    private String shorten(DeclarationInformation.StorageClass storageClass) {
        return switch (storageClass) {
            case DeclarationInformation.StorageClass.GLOBAL -> "G";
            case DeclarationInformation.StorageClass.IMPLEMENTATION -> "IMPL";
            case DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM -> "I_IN";
            case DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM -> "I_OUT";
            case DeclarationInformation.StorageClass.LOCAL -> "LOC";
            case DeclarationInformation.StorageClass.PROC_FUNC -> "PF";
            case DeclarationInformation.StorageClass.PROC_FUNC_INPARAM -> "PF_IN";
            case DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM -> "PF_OUT";
            case DeclarationInformation.StorageClass.QUANTIFIED -> "Q";
            default -> throw new MatchException(null, null);
        };
    }

    private String prettyPrintProcedureSignature(Declaration declaration) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        try {
            return prettyPrinter.process(declaration).toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "";
        }
    }

    private static final class PrettyPrinter
    extends BoogieVisitor {
        private StringBuilder mBuilder;

        private PrettyPrinter() {
        }

        public StringBuilder process(Declaration declaration) {
            this.mBuilder = new StringBuilder();
            this.processDeclaration(declaration);
            this.mBuilder.replace(this.mBuilder.length() - 9, this.mBuilder.length(), "");
            return this.mBuilder;
        }

        protected void visit(Procedure procedure) {
            this.mBuilder.append(procedure.getIdentifier());
        }

        protected void visit(FunctionDeclaration functionDeclaration) {
            this.mBuilder.append(functionDeclaration.getIdentifier());
        }

        protected VarList[] processVarLists(VarList[] varListArray) {
            this.mBuilder.append("(");
            VarList[] varListArray2 = super.processVarLists(varListArray);
            if (varListArray.length > 0) {
                this.mBuilder.replace(this.mBuilder.length() - 2, this.mBuilder.length(), "");
            }
            this.mBuilder.append(") returns ");
            return varListArray2;
        }

        protected VarList processVarList(VarList varList) {
            String[] stringArray = varList.getIdentifiers();
            if (stringArray.length > 0) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    this.mBuilder.append(string).append(" : ").append(varList.getType().getBoogieType()).append(", ");
                    ++n2;
                }
            }
            return super.processVarList(varList);
        }

        protected Body processBody(Body body) {
            return body;
        }

        protected Expression processExpression(Expression expression) {
            return expression;
        }
    }
}

