/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtCommandUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LoggingScriptForNonIncrementalBenchmarks
extends WrapperScript {
    private final PrintTerm mTermPrinter = new PrintTerm();
    private final String mBaseFilename;
    private final String mDirectory;
    protected final LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> mCommandStack;

    public LoggingScriptForNonIncrementalBenchmarks(Script script, String string, String string2) {
        super(script);
        this.mBaseFilename = string;
        this.mDirectory = string2;
        this.mCommandStack = new LinkedList();
        this.mCommandStack.push(new ArrayList());
    }

    protected LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> deepCopyOfCommandStack() {
        LinkedList linkedList = new LinkedList();
        for (ArrayList arrayList : this.mCommandStack) {
            linkedList.add(new ArrayList());
            linkedList.getLast().addAll(arrayList);
        }
        return linkedList;
    }

    protected void addToCurrentAssertionStack(SmtCommandUtils.ISmtCommand<?> iSmtCommand) {
        this.mCommandStack.getLast().add(iSmtCommand);
    }

    private void resetAssertionStack() {
        this.mCommandStack.clear();
        this.mCommandStack.add(new ArrayList());
    }

    private static void printCommandStack(PrintWriter printWriter, List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> list) {
        for (ArrayList<SmtCommandUtils.ISmtCommand<?>> arrayList : list) {
            for (SmtCommandUtils.ISmtCommand<?> iSmtCommand : arrayList) {
                printWriter.print(iSmtCommand.toString() + System.lineSeparator());
            }
        }
    }

    protected void writeCommandStackToFile(File file, List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> list) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)("Unable to write file " + file.getAbsolutePath()));
        }
        PrintWriter printWriter = new PrintWriter(fileWriter);
        LoggingScriptForNonIncrementalBenchmarks.printCommandStack(printWriter, list);
        printWriter.close();
    }

    protected File constructFile(String string) {
        String string2 = this.mDirectory + File.separator + this.mBaseFilename + string + ".smt2";
        File file = new File(string2);
        return file;
    }

    private static final Term formatTerm(Term term) {
        return term;
    }

    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(set-logic " + string + ")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetLogicCommand(string));
        this.mScript.setLogic(string);
    }

    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(set-logic " + logics.name() + ")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetLogicCommand(logics.name()));
        this.mScript.setLogic(logics);
    }

    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(set-option ");
        printWriter.print(string);
        printWriter.print(' ');
        printWriter.print(PrintTerm.quoteObjectIfString((Object)object));
        printWriter.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetOptionCommand(string, object));
        this.mScript.setOption(string, object);
    }

    public void setInfo(String string, Object object) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(set-info ");
        printWriter.print(string);
        printWriter.print(' ');
        printWriter.print(PrintTerm.quoteObjectIfString((Object)object));
        printWriter.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetOptionCommand(string, object));
        this.mScript.setInfo(string, object);
    }

    public void declareSort(String string, int n) throws SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(declare-sort ");
        printWriter.print(PrintTerm.quoteIdentifier((String)string));
        printWriter.print(' ');
        printWriter.print(n);
        printWriter.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.DeclareSortCommand(string, n));
        this.mScript.declareSort(string, n);
    }

    public void defineSort(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(define-sort ");
        printWriter.print(PrintTerm.quoteIdentifier((String)string));
        printWriter.print(" (");
        String string2 = "";
        Sort[] sortArray2 = sortArray;
        int n = sortArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sort sort2 = sortArray2[n2];
            printWriter.print(string2);
            this.mTermPrinter.append((Appendable)printWriter, sort2);
            string2 = " ";
            ++n2;
        }
        printWriter.print(") ");
        this.mTermPrinter.append((Appendable)printWriter, sort);
        printWriter.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.DefineSortCommand(string, sortArray, sort));
        this.mScript.defineSort(string, sortArray, sort);
    }

    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(declare-fun ");
        printWriter.print(PrintTerm.quoteIdentifier((String)string));
        printWriter.print(" (");
        String string2 = "";
        Sort[] sortArray2 = sortArray;
        int n = sortArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sort sort2 = sortArray2[n2];
            printWriter.print(string2);
            this.mTermPrinter.append((Appendable)printWriter, sort2);
            string2 = " ";
            ++n2;
        }
        printWriter.print(") ");
        this.mTermPrinter.append((Appendable)printWriter, sort);
        printWriter.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.DeclareFunCommand(string, sortArray, sort));
        this.mScript.declareFun(string, sortArray, sort);
    }

    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(define-fun ");
        printWriter.print(PrintTerm.quoteIdentifier((String)string));
        printWriter.print(" (");
        String string2 = "(";
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray2[n2];
            printWriter.print(string2);
            printWriter.print(termVariable);
            printWriter.print(' ');
            this.mTermPrinter.append((Appendable)printWriter, termVariable.getSort());
            printWriter.print(')');
            string2 = " (";
            ++n2;
        }
        printWriter.print(") ");
        this.mTermPrinter.append((Appendable)printWriter, sort);
        printWriter.print(' ');
        this.mTermPrinter.append((Appendable)printWriter, LoggingScriptForNonIncrementalBenchmarks.formatTerm(term));
        printWriter.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.DefineFunCommand(string, termVariableArray, sort, term));
        this.mScript.defineFun(string, termVariableArray, sort, term);
    }

    public void push(int n) throws SMTLIBException {
        int n2 = 0;
        while (n2 < n) {
            this.mCommandStack.add(new ArrayList());
            ++n2;
        }
        this.mScript.push(n);
    }

    public void pop(int n) throws SMTLIBException {
        int n2 = 0;
        while (n2 < n) {
            this.mCommandStack.removeLast();
            ++n2;
        }
        this.mScript.pop(n);
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.AssertCommand(term));
        return this.mScript.assertTerm(term);
    }

    public Script.LBool checkSat() throws SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(check-sat)");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.CheckSatCommand());
        return this.mScript.checkSat();
    }

    public Term[] getAssertions() throws SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(get-assertions)");
        System.out.println("Logging script will ignore the get-assertions command.");
        return this.mScript.getAssertions();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(get-proof)");
        System.out.println("Logging script will ignore the get-proof command.");
        return this.mScript.getProof();
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(get-unsat-core)");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.GetUnsatCoreCommand());
        return this.mScript.getUnsatCore();
    }

    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(get-value (");
        String string = "";
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            printWriter.print(string);
            this.mTermPrinter.append((Appendable)printWriter, LoggingScriptForNonIncrementalBenchmarks.formatTerm(term));
            string = " ";
            ++n2;
        }
        printWriter.println("))");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.GetValueCommand(termArray));
        return this.mScript.getValue(termArray);
    }

    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(get-assignment)");
        System.out.println("Logging script will ignore the get-assignment command.");
        return this.mScript.getAssignment();
    }

    public Object getOption(String string) throws UnsupportedOperationException {
        System.out.println("Logging script will ignore the get-option command.");
        return this.mScript.getOption(string);
    }

    public Object getInfo(String string) throws UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(get-info " + string + ")");
        System.out.println("Logging script will ignore the get-info command.");
        return this.mScript.getInfo(string);
    }

    public Term simplify(Term term) throws SMTLIBException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(simplify ");
        this.mTermPrinter.append((Appendable)printWriter, term);
        printWriter.println(")");
        System.out.println("Logging script will ignore the simplify command.");
        return this.mScript.simplify(term);
    }

    public void reset() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(reset)");
        this.resetAssertionStack();
        this.mScript.reset();
    }

    public Term[] getInterpolants(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(get-interpolants");
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            printWriter.print(' ');
            this.mTermPrinter.append((Appendable)printWriter, term);
            ++n2;
        }
        printWriter.println(')');
        System.out.println("Logging script will ignore the get-interpolants command.");
        return this.mScript.getInterpolants(termArray);
    }

    public Term[] getInterpolants(Term[] termArray, int[] nArray) throws SMTLIBException, UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(get-interpolants ");
        this.mTermPrinter.append((Appendable)printWriter, termArray[0]);
        int n = 1;
        while (n < termArray.length) {
            int n2 = nArray[n - 1];
            while (nArray[n] < n2) {
                printWriter.print(')');
                n2 = nArray[n2 - 1];
            }
            printWriter.print(' ');
            if (nArray[n] == n) {
                printWriter.print('(');
            }
            this.mTermPrinter.append((Appendable)printWriter, termArray[n]);
            ++n;
        }
        printWriter.println(')');
        System.out.println("Logging script will ignore the get-interpolants command.");
        return this.mScript.getInterpolants(termArray, nArray);
    }

    public void exit() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(exit)");
        printWriter.flush();
        printWriter.close();
        System.out.println("Logging script will ignore the exit command.");
        this.mScript.exit();
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("(get-model)");
        System.out.println("Logging script will ignore the get-model command.");
        return this.mScript.getModel();
    }

    public Iterable<Term[]> checkAllsat(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintTerm printTerm = new PrintTerm();
        printWriter.print("(check-allsat (");
        String string = "";
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            printWriter.print(string);
            printTerm.append((Appendable)printWriter, term);
            string = " ";
            ++n2;
        }
        printWriter.println("))");
        System.out.println("Logging script will ignore the check-allsat command.");
        return this.mScript.checkAllsat(termArray);
    }

    public Term[] findImpliedEquality(Term[] termArray, Term[] termArray2) {
        Term term;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintTerm printTerm = new PrintTerm();
        printWriter.print("(find-implied-equality (");
        String string = "";
        Term[] termArray3 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term = termArray3[n2];
            printWriter.print(string);
            printTerm.append((Appendable)printWriter, term);
            string = " ";
            ++n2;
        }
        printWriter.print(") (");
        string = "";
        termArray3 = termArray;
        n = termArray.length;
        n2 = 0;
        while (n2 < n) {
            term = termArray3[n2];
            printWriter.print(string);
            printTerm.append((Appendable)printWriter, term);
            string = " ";
            ++n2;
        }
        printWriter.println("))");
        System.out.println("Logging script will ignore the find-implied-equality command.");
        return this.mScript.findImpliedEquality(termArray, termArray2);
    }

    public QuotedObject echo(QuotedObject quotedObject) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("(echo ");
        printWriter.print(quotedObject);
        printWriter.println(')');
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.EchoCommand(quotedObject));
        return this.mScript.echo(quotedObject);
    }

    public void comment(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("; ");
        printWriter.println(string);
        System.out.println("Logging script will ignore the comment command.");
    }

    public Script.LBool checkSatAssuming(Term ... termArray) throws SMTLIBException {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }

    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }

    public void resetAssertions() {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }
}

