/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class BitvecLiteral
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(BitvecLiteral.class);
    String value;
    int length;

    public BitvecLiteral(ILocation iLocation, String string, int n) {
        super(iLocation);
        this.value = string;
        this.length = n;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BitvecLiteral: " + String.valueOf((Object)this);
    }

    public BitvecLiteral(ILocation iLocation, IBoogieType iBoogieType, String string, int n) {
        super(iLocation, iBoogieType);
        this.value = string;
        this.length = n;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BitvecLiteral: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BitvecLiteral").append('[');
        stringBuffer.append(this.value);
        stringBuffer.append(',').append(this.length);
        return stringBuffer.append(']').toString();
    }

    public String getValue() {
        return this.value;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        generatedBoogieAstVisitor.visit(this);
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        return this;
    }
}

