/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.InstClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.SubstitutionHelper;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.dawg.Dawg;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class InstantiationManager {
    private final Clausifier mClausifier;
    private final QuantifierTheory mQuantTheory;
    private final EMatching mEMatching;
    private final Map<QuantClause, Map<List<Term>, InstClause>> mClauseInstances;
    private final InstanceValue mDefaultValueForLitDawgs;
    private final List<InstanceValue> mRelevantValuesForCheckpoint;
    private int mSubsAgeForFinalCheck = 0;

    public InstantiationManager(QuantifierTheory quantifierTheory) {
        this.mQuantTheory = quantifierTheory;
        this.mClausifier = quantifierTheory.getClausifier();
        this.mEMatching = quantifierTheory.getEMatching();
        this.mClauseInstances = new HashMap<QuantClause, Map<List<Term>, InstClause>>();
        this.mDefaultValueForLitDawgs = this.mQuantTheory.mUseUnknownTermValueInDawgs ? InstanceValue.UNKNOWN_TERM : InstanceValue.ONE_UNDEF;
        this.mRelevantValuesForCheckpoint = new ArrayList<InstanceValue>();
        this.mRelevantValuesForCheckpoint.add(InstanceValue.FALSE);
        this.mRelevantValuesForCheckpoint.add(InstanceValue.ONE_UNDEF);
        if (this.mQuantTheory.mInstantiationMethod == QuantifierTheory.InstantiationMethod.E_MATCHING_EAGER || this.mQuantTheory.mInstantiationMethod == QuantifierTheory.InstantiationMethod.E_MATCHING_LAZY) {
            this.mRelevantValuesForCheckpoint.add(InstanceValue.OTHER);
        } else if (this.mQuantTheory.mPropagateNewTerms) {
            this.mRelevantValuesForCheckpoint.add(InstanceValue.UNKNOWN_TERM);
        }
    }

    public void addClause(QuantClause quantClause) {
        this.mClauseInstances.put(quantClause, new LinkedHashMap());
    }

    public void removeClause(QuantClause quantClause) {
        assert (this.mClauseInstances.containsKey(quantClause));
        this.mClauseInstances.remove(quantClause);
    }

    public void removeAllInstClauses() {
        for (Map<List<Term>, InstClause> map : this.mClauseInstances.values()) {
            map.clear();
        }
    }

    public void resetInterestingTerms() {
        for (QuantClause quantClause : this.mQuantTheory.getQuantClauses()) {
            quantClause.clearInterestingTerms();
        }
    }

    public void resetSubsAgeForFinalCheck() {
        this.mSubsAgeForFinalCheck = 0;
    }

    public Set<InstClause> findConflictAndUnitInstancesWithEMatching() {
        Object object;
        Object object2;
        LinkedHashSet<InstClause> linkedHashSet = new LinkedHashSet<InstClause>();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<QuantClause> arrayList = new ArrayList<QuantClause>();
        arrayList.addAll(this.mQuantTheory.getQuantClauses());
        for (QuantClause object3 : arrayList) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return Collections.emptySet();
            }
            if (object3.hasTrueGroundLits()) continue;
            object2 = this.computeClauseDawg(object3);
            for (InstantiationInfo instantiationInfo : this.getRelevantSubsFromDawg(object3, (Dawg<Term, InstantiationInfo>)object2)) {
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                object = instantiationInfo.getSubs();
                InstanceValue instanceValue = instantiationInfo.getInstValue();
                if (instanceValue == InstanceValue.FALSE) {
                    InstClause instClause = this.computeClauseInstance(object3, (List<Term>)object, QuantifierTheory.InstanceOrigin.CONFLICT);
                    if (instClause == null) continue;
                    linkedHashSet.add(instClause);
                    continue;
                }
                assert (instanceValue == InstanceValue.ONE_UNDEF || instanceValue == InstanceValue.UNKNOWN_TERM);
                if (!linkedHashMap.containsKey(object3)) {
                    linkedHashMap.put(object3, new ArrayList());
                }
                ((Collection)linkedHashMap.get(object3)).add(object);
            }
        }
        if (linkedHashSet.isEmpty()) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                object2 = (QuantClause)entry.getKey();
                for (List list : (Collection)entry.getValue()) {
                    if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return Collections.emptySet();
                    }
                    object = this.computeClauseInstance((QuantClause)object2, list, QuantifierTheory.InstanceOrigin.CONFLICT);
                    if (object == null) continue;
                    linkedHashSet.add((InstClause)object);
                }
            }
        }
        return linkedHashSet;
    }

    public Set<InstClause> findConflictAndUnitInstances() {
        Object object;
        Object object2;
        LinkedHashSet<InstClause> linkedHashSet = new LinkedHashSet<InstClause>();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<QuantClause> arrayList = new ArrayList<QuantClause>();
        arrayList.addAll(this.mQuantTheory.getQuantClauses());
        for (QuantClause object3 : arrayList) {
            if (this.mClausifier.getEngine().isTerminationRequested()) {
                return null;
            }
            if (object3.hasTrueGroundLits()) continue;
            object3.updateInterestingTermsAllVars();
            object2 = this.computeAllSubstitutions(object3);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                if (this.mClausifier.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                object = this.evaluateClauseInstance(object3, list);
                if (object == InstanceValue.IRRELEVANT) continue;
                if (object == InstanceValue.FALSE) {
                    InstClause instClause = this.computeClauseInstance(object3, list, QuantifierTheory.InstanceOrigin.CONFLICT);
                    if (instClause == null) continue;
                    linkedHashSet.add(instClause);
                    continue;
                }
                assert (object == InstanceValue.ONE_UNDEF || object == InstanceValue.UNKNOWN_TERM);
                if (!linkedHashMap.containsKey(object3)) {
                    linkedHashMap.put(object3, new ArrayList());
                }
                ((Collection)linkedHashMap.get(object3)).add(list);
            }
        }
        if (linkedHashSet.isEmpty()) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                object2 = (QuantClause)entry.getKey();
                for (List list : (Collection)entry.getValue()) {
                    if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return Collections.emptySet();
                    }
                    object = this.computeClauseInstance((QuantClause)object2, list, QuantifierTheory.InstanceOrigin.CONFLICT);
                    if (object == null) continue;
                    linkedHashSet.add((InstClause)object);
                }
            }
        }
        return linkedHashSet;
    }

    public Set<InstClause> computeEMatchingInstances() {
        LinkedHashSet<InstClause> linkedHashSet = new LinkedHashSet<InstClause>();
        ArrayList<QuantClause> arrayList = new ArrayList<QuantClause>();
        arrayList.addAll(this.mQuantTheory.getQuantClauses());
        block0: for (QuantClause quantClause : arrayList) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return Collections.emptySet();
            }
            if (quantClause.hasTrueGroundLits()) continue;
            Dawg<Term, InstantiationInfo> dawg = Dawg.createConst(quantClause.getVars().length, new InstantiationInfo(InstanceValue.FALSE, new ArrayList<Term>()));
            QuantLiteral[] quantLiteralArray = quantClause.getQuantLits();
            int n = quantLiteralArray.length;
            int n2 = 0;
            while (n2 < n) {
                QuantLiteral quantLiteral = quantLiteralArray[n2];
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                Dawg<Object, InstantiationInfo> dawg2 = null;
                QuantLiteral quantLiteral2 = quantLiteral.getAtom();
                if (this.mEMatching.isUsingEmatching(quantLiteral) || this.mEMatching.isPartiallyUsingEmatching(quantLiteral)) {
                    Object object;
                    if (this.mQuantTheory.mPropagateNewAux && quantLiteral2 instanceof QuantEquality && QuantUtil.isAuxApplication(object = ((QuantEquality)quantLiteral2).getLhs())) {
                        dawg2 = Dawg.createConst(quantClause.getVars().length, new InstantiationInfo(InstanceValue.ONE_UNDEF, new ArrayList<Term>()));
                    }
                    if (dawg2 == null) {
                        object = this.mEMatching.getSubstitutionInfos(quantLiteral2);
                        Dawg<Term, EMatching.SubstitutionInfo> dawg3 = this.getRepresentativeSubsDawg((Dawg<Term, EMatching.SubstitutionInfo>)object);
                        dawg2 = dawg3.map(substitutionInfo -> substitutionInfo.equals(this.mEMatching.getEmptySubs()) && !QuantUtil.isVarEq(quantLiteral.getAtom()) ? new InstantiationInfo(InstanceValue.IRRELEVANT, new ArrayList<Term>()) : new InstantiationInfo(InstanceValue.ONE_UNDEF, this.getTermSubsFromSubsInfo(quantLiteral, (EMatching.SubstitutionInfo)substitutionInfo)));
                    }
                } else if (quantLiteral.mIsArithmetical) {
                    dawg2 = Dawg.createConst(quantClause.getVars().length, new InstantiationInfo(InstanceValue.ONE_UNDEF, new ArrayList<Term>()));
                }
                if (dawg2 == null) continue block0;
                dawg = dawg.combine(dawg2, (instantiationInfo, instantiationInfo2) -> this.combineForCheckpoint((InstantiationInfo)instantiationInfo, (InstantiationInfo)instantiationInfo2));
                ++n2;
            }
            for (InstantiationInfo instantiationInfo3 : this.getRelevantSubsFromDawg(quantClause, dawg)) {
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                InstClause instClause = this.computeClauseInstance(quantClause, instantiationInfo3.getSubs(), QuantifierTheory.InstanceOrigin.EMATCHING);
                if (instClause == null) continue;
                linkedHashSet.add(instClause);
            }
        }
        return linkedHashSet;
    }

    private Dawg<Term, EMatching.SubstitutionInfo> getRepresentativeSubsDawg(Dawg<Term, EMatching.SubstitutionInfo> dawg) {
        return dawg.mapKeys(term -> this.mQuantTheory.getRepresentativeTerm((Term)term), (substitutionInfo, substitutionInfo2) -> this.mapToFirstChecked((EMatching.SubstitutionInfo)substitutionInfo, (EMatching.SubstitutionInfo)substitutionInfo2));
    }

    public Set<InstClause> instantiateSomeNotSat() {
        Object object;
        ArrayList<QuantClause> arrayList = new ArrayList<QuantClause>();
        for (QuantClause object22 : this.mQuantTheory.getQuantClauses()) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return Collections.emptySet();
            }
            if (object22.hasTrueGroundLits()) continue;
            assert (this.mClauseInstances.containsKey(object22));
            for (Map.Entry entry : this.mClauseInstances.get(object22).entrySet()) {
                object = (InstClause)entry.getValue();
                if (object == null) continue;
                int n = ((InstClause)object).countAndSetUndefLits();
                assert (n == -1 || n == 0);
                if (n != 0) continue;
                this.mQuantTheory.getLogger().info("Conflict on existing clause instance hasn't been detected in checkpoint(): ", object);
                return Collections.singleton(object);
            }
            arrayList.add(object22);
        }
        HashMap<QuantClause, List[]> hashMap = new HashMap<QuantClause, List[]>();
        int n = 0;
        for (QuantClause quantClause : arrayList) {
            if (this.mClausifier.getEngine().isTerminationRequested()) {
                return null;
            }
            quantClause.updateInterestingTermsAllVars();
            object = this.sortInterestingTermsByAge(quantClause.getInterestingTerms());
            n = Math.max(n, ((Pair)object).getSecond());
            hashMap.put(quantClause, (List[])((Pair)object).getFirst());
        }
        this.mQuantTheory.getLogger().debug("Quant: Max term age %d", n);
        while (this.mSubsAgeForFinalCheck <= n) {
            Object object2;
            this.mQuantTheory.getLogger().debug("Searching for instances of age %d", this.mSubsAgeForFinalCheck);
            if (this.mClausifier.getEngine().isTerminationRequested()) {
                return null;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList arrayList3 = new ArrayList();
            object = new ArrayList<Object>();
            for (QuantClause quantClause : arrayList) {
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                Set<List<Term>> set = this.computeSubstitutionsForAge((List[])hashMap.get(quantClause), this.mSubsAgeForFinalCheck);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object object3;
                    Pair<InstanceValue, Boolean> pair;
                    object2 = (List)iterator.next();
                    assert (this.getMaxAge((List<Term>)object2) == this.mSubsAgeForFinalCheck);
                    if (this.mClausifier.getEngine().isTerminationRequested()) {
                        return null;
                    }
                    if (this.mClauseInstances.containsKey(quantClause) && this.mClauseInstances.get(quantClause).containsKey(object2) || (pair = this.evaluateNewClauseInstanceFinalCheck(quantClause, (List<Term>)object2)).getFirst() == InstanceValue.TRUE) continue;
                    if (pair.getFirst() == InstanceValue.FALSE || pair.getFirst() == InstanceValue.ONE_UNDEF) {
                        int n2;
                        assert (pair.getSecond().booleanValue());
                        object3 = this.computeClauseInstance(quantClause, (List<Term>)object2, QuantifierTheory.InstanceOrigin.ENUMERATION);
                        if (object3 == null || (n2 = ((InstClause)object3).countAndSetUndefLits()) < 0) continue;
                        this.mQuantTheory.getLogger().debug("Found inst of age %d", this.mSubsAgeForFinalCheck);
                        return Collections.singleton(object3);
                    }
                    object3 = new Pair<QuantClause, Object>(quantClause, object2);
                    if (pair.getFirst() == InstanceValue.UNKNOWN_TERM) {
                        assert (!pair.getSecond().booleanValue());
                        arrayList3.add(object3);
                        continue;
                    }
                    assert (pair.getFirst() == InstanceValue.OTHER);
                    if (pair.getSecond().booleanValue()) {
                        arrayList2.add(object3);
                        continue;
                    }
                    object.add(object3);
                }
            }
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            arrayList4.addAll(arrayList3);
            arrayList4.addAll(arrayList2);
            arrayList4.addAll((Collection<Object>)object);
            for (Object object4 : arrayList4) {
                int n3;
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                object2 = this.computeClauseInstance((QuantClause)((Pair)object4).getFirst(), (List)((Pair)object4).getSecond(), QuantifierTheory.InstanceOrigin.ENUMERATION);
                if (object2 == null || (n3 = ((InstClause)object2).countAndSetUndefLits()) < 0) continue;
                this.mQuantTheory.getLogger().debug("Found inst of age %d", this.mSubsAgeForFinalCheck);
                return Collections.singleton(object2);
            }
            ++this.mSubsAgeForFinalCheck;
        }
        return null;
    }

    private Pair<List<Term>[], Integer> sortInterestingTermsByAge(Map<Term, Term>[] mapArray) {
        ArrayList[] arrayListArray = new ArrayList[mapArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < arrayListArray.length) {
            arrayListArray[n2] = this.sortInterestingTermsByAge(mapArray[n2].values());
            assert (!arrayListArray[n2].isEmpty());
            n = Math.max(n, this.getTermAge((Term)arrayListArray[n2].get(arrayListArray[n2].size() - 1)));
            ++n2;
        }
        return new Pair<ArrayList[], Integer>(arrayListArray, n);
    }

    private List<Term> sortInterestingTermsByAge(Collection<Term> collection) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.addAll(collection);
        Collections.sort(arrayList, new Comparator<Term>(){

            @Override
            public int compare(Term term, Term term2) {
                return InstantiationManager.this.getTermAge(term) - InstantiationManager.this.getTermAge(term2);
            }
        });
        return arrayList;
    }

    private Set<List<Term>> computeSubstitutionsForAge(List<Term>[] listArray, int n) {
        int n2 = listArray.length;
        LinkedHashMap<ArrayList<Object>, Integer> linkedHashMap = new LinkedHashMap<ArrayList<Object>, Integer>();
        linkedHashMap.put(new ArrayList(n2), 0);
        int n3 = 0;
        while (n3 < n2) {
            assert (!listArray[n3].isEmpty());
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            block1: for (Map.Entry entry : linkedHashMap.entrySet()) {
                if (this.mClausifier.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                int n4 = (Integer)entry.getValue();
                for (Term term : listArray[n3]) {
                    int n5 = this.getTermAge(term);
                    if (n5 > n) continue block1;
                    if (n3 == n2 - 1 && n4 != n && n5 != n) continue;
                    ArrayList<Term> arrayList = new ArrayList<Term>(n2);
                    arrayList.addAll((Collection)entry.getKey());
                    arrayList.add(term);
                    int n6 = (Integer)entry.getValue() > n5 ? (Integer)entry.getValue() : n5;
                    linkedHashMap2.put(arrayList, n6);
                }
            }
            linkedHashMap.clear();
            linkedHashMap.putAll(linkedHashMap2);
            ++n3;
        }
        return linkedHashMap.keySet();
    }

    private int getTermAge(Term term) {
        CCTerm cCTerm = this.mClausifier.getCCTerm(term);
        return cCTerm != null ? cCTerm.getAge() : 0;
    }

    private int getMaxAge(List<Term> list) {
        int n = 0;
        for (Term term : list) {
            n = Math.max(n, this.getTermAge(term));
        }
        return n;
    }

    private Dawg<Term, InstantiationInfo> computeClauseDawg(QuantClause quantClause) {
        Object object;
        int n = quantClause.getVars().length;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Dawg<Term, InstantiationInfo> dawg = Dawg.createConst(quantClause.getVars().length, new InstantiationInfo(InstanceValue.IRRELEVANT, arrayList));
        InstanceValue instanceValue = InstanceValue.FALSE;
        Object object2 = quantClause.getGroundLits();
        int n2 = ((Literal[])object2).length;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            instanceValue = ((Literal)object).getAtom().getDecideStatus() == object ? this.combineForCheckpoint(instanceValue, InstanceValue.TRUE) : (((Literal)object).getAtom().getDecideStatus() == ((Literal)object).negate() ? this.combineForCheckpoint(instanceValue, InstanceValue.FALSE) : this.combineForCheckpoint(instanceValue, InstanceValue.ONE_UNDEF));
            if (instanceValue == InstanceValue.IRRELEVANT) break;
            ++n3;
        }
        object = Dawg.createConst(n, new InstantiationInfo(instanceValue, arrayList));
        if (instanceValue != InstanceValue.IRRELEVANT) {
            Object object32;
            BiFunction<InstantiationInfo, InstantiationInfo, InstantiationInfo> biFunction = (instantiationInfo, instantiationInfo2) -> this.combineForCheckpoint((InstantiationInfo)instantiationInfo, (InstantiationInfo)instantiationInfo2);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(quantClause.getQuantLits().length);
            object2 = new ArrayList(quantClause.getQuantLits().length);
            ArrayList<Object> arrayList3 = new ArrayList<Object>(quantClause.getQuantLits().length);
            Object object4 = quantClause.getQuantLits();
            int n4 = ((QuantLiteral[])object4).length;
            int n5 = 0;
            while (n5 < n4) {
                object32 = object4[n5];
                if (object == dawg || this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return dawg;
                }
                if (((QuantLiteral)object32).isArithmetical()) {
                    object2.add(object32);
                } else if (this.mEMatching.isUsingEmatching((QuantLiteral)object32)) {
                    Dawg<Term, InstantiationInfo> dawg2 = this.computeEMatchingLitDawg((QuantLiteral)object32);
                    object = ((Dawg)object).combine(dawg2, biFunction);
                } else if (this.mEMatching.isPartiallyUsingEmatching((QuantLiteral)object32)) {
                    arrayList3.add(object32);
                } else {
                    arrayList2.add(object32);
                }
                ++n5;
            }
            if (object != dawg && !arrayList3.isEmpty()) {
                for (Object object32 : arrayList3) {
                    if (object == dawg || this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return dawg;
                    }
                    Dawg<Term, EMatching.SubstitutionInfo> dawg3 = this.mEMatching.getSubstitutionInfos(((QuantLiteral)object32).getAtom());
                    object4 = this.getRepresentativeSubsDawg(dawg3);
                    object = ((Dawg)object).combine(object4, (arg_0, arg_1) -> this.lambda$5((QuantLiteral)object32, arg_0, arg_1));
                }
            }
            if (object != dawg && !arrayList2.isEmpty()) {
                for (Object object32 : arrayList2) {
                    if (object == dawg || this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return dawg;
                    }
                    object = ((Dawg)object).mapWithKey((arg_0, arg_1) -> this.lambda$6((QuantLiteral)object32, arg_0, arg_1));
                }
            }
            if (object != dawg && !object2.isEmpty()) {
                object32 = this.computeSubsForArithmetical(quantClause, (Collection<QuantLiteral>)object2, (Dawg<Term, InstantiationInfo>)object);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    QuantLiteral quantLiteral = (QuantLiteral)iterator.next();
                    if (object == dawg || this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return dawg;
                    }
                    object4 = this.computeArithLitDawg(quantLiteral, (Term[][])object32);
                    object = ((Dawg)object).combine(object4, biFunction);
                }
            }
        }
        return object;
    }

    private InstanceValue combineForCheckpoint(InstanceValue instanceValue, InstanceValue instanceValue2) {
        return instanceValue.combine(instanceValue2).keepOnlyRelevant(this.mRelevantValuesForCheckpoint);
    }

    private InstantiationInfo combineForCheckpoint(InstantiationInfo instantiationInfo, InstantiationInfo instantiationInfo2) {
        InstanceValue instanceValue = this.combineForCheckpoint(instantiationInfo.getInstValue(), instantiationInfo2.getInstValue());
        if (instanceValue == InstanceValue.IRRELEVANT) {
            return new InstantiationInfo(instanceValue, new ArrayList<Term>());
        }
        List<Term> list = this.combineSubs(instantiationInfo.getSubs(), instantiationInfo2.getSubs());
        return new InstantiationInfo(instanceValue, list);
    }

    private List<Term> combineSubs(List<Term> list, List<Term> list2) {
        assert (list.isEmpty() || list2.isEmpty() || list.size() == list2.size());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (list.isEmpty()) {
            arrayList.addAll(list2);
        } else if (list2.isEmpty()) {
            arrayList.addAll(list);
        } else {
            int n = 0;
            while (n < list.size()) {
                if (list.get(n) == null) {
                    arrayList.add(list2.get(n));
                } else {
                    arrayList.add(list.get(n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    private boolean isUsedValueForCheckpoint(InstanceValue instanceValue) {
        if (instanceValue == InstanceValue.IRRELEVANT) {
            return true;
        }
        for (InstanceValue instanceValue2 : this.mRelevantValuesForCheckpoint) {
            if (instanceValue != instanceValue2) continue;
            return true;
        }
        return false;
    }

    private Dawg<Term, InstantiationInfo> computeEMatchingLitDawg(QuantLiteral quantLiteral) {
        assert (this.mEMatching.isUsingEmatching(quantLiteral));
        Dawg<Term, EMatching.SubstitutionInfo> dawg = this.mEMatching.getSubstitutionInfos(quantLiteral.getAtom());
        Dawg<Term, EMatching.SubstitutionInfo> dawg2 = this.getRepresentativeSubsDawg(dawg);
        Function<EMatching.SubstitutionInfo, InstantiationInfo> function = substitutionInfo -> new InstantiationInfo(this.evaluateLitForEMatchingSubsInfo(quantLiteral, (EMatching.SubstitutionInfo)substitutionInfo), this.getTermSubsFromSubsInfo(quantLiteral, (EMatching.SubstitutionInfo)substitutionInfo));
        return dawg2.map(function);
    }

    private EMatching.SubstitutionInfo mapToFirstChecked(EMatching.SubstitutionInfo substitutionInfo, EMatching.SubstitutionInfo substitutionInfo2) {
        return substitutionInfo;
    }

    private List<Term> getTermSubsFromSubsInfo(QuantLiteral quantLiteral, EMatching.SubstitutionInfo substitutionInfo) {
        int n = quantLiteral.getClause().getVars().length;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (!substitutionInfo.equals(this.mEMatching.getEmptySubs())) {
            List<CCTerm> list = substitutionInfo.getVarSubs();
            assert (list.size() == n);
            int n2 = 0;
            while (n2 < n) {
                CCTerm cCTerm = list.get(n2);
                arrayList.add(cCTerm == null ? null : cCTerm.getFlatTerm());
                ++n2;
            }
        }
        return arrayList;
    }

    private InstanceValue evaluateLitForEMatchingSubsInfo(QuantLiteral quantLiteral, EMatching.SubstitutionInfo substitutionInfo) {
        InstanceValue instanceValue;
        QuantLiteral quantLiteral2 = quantLiteral.getAtom();
        if (substitutionInfo.equals(this.mEMatching.getEmptySubs())) {
            if (this.mQuantTheory.mPropagateNewAux && !this.mQuantTheory.mPropagateNewTerms && quantLiteral2 instanceof QuantEquality && QuantUtil.isAuxApplication(((QuantEquality)quantLiteral2).getLhs())) {
                return InstanceValue.ONE_UNDEF;
            }
            return this.mDefaultValueForLitDawgs;
        }
        if (quantLiteral2 instanceof QuantBoundConstraint) {
            Map<Term, Term> map = this.buildSharedMapFromCCMap(substitutionInfo.getEquivalentCCTerms());
            instanceValue = this.evaluateBoundConstraintKnownShared((QuantBoundConstraint)quantLiteral2, map);
        } else {
            QuantEquality quantEquality = (QuantEquality)quantLiteral2;
            instanceValue = this.evaluateCCEqualityKnownShared(quantEquality, substitutionInfo.getEquivalentCCTerms());
            if ((instanceValue == InstanceValue.ONE_UNDEF || instanceValue == InstanceValue.UNKNOWN_TERM) && quantEquality.getLhs().getSort().isNumericSort()) {
                Map<Term, Term> map = this.buildSharedMapFromCCMap(substitutionInfo.getEquivalentCCTerms());
                instanceValue = this.evaluateLAEqualityKnownShared(quantEquality, map);
            }
        }
        if (quantLiteral.isNegated()) {
            instanceValue = instanceValue.negate();
        }
        return instanceValue;
    }

    private InstantiationInfo evaluateLitForPartialEMatchingSubsInfo(QuantLiteral quantLiteral, InstantiationInfo instantiationInfo, EMatching.SubstitutionInfo substitutionInfo) {
        InstanceValue instanceValue = this.mDefaultValueForLitDawgs;
        TermVariable[] termVariableArray = quantLiteral.getClause().getVars();
        List<Term> list = instantiationInfo.getSubs();
        if (instantiationInfo.getInstValue() != InstanceValue.IRRELEVANT && !list.isEmpty()) {
            Object object;
            Object object2;
            HashMap<Term, CCTerm> hashMap = new HashMap<Term, CCTerm>();
            hashMap.putAll(substitutionInfo.getEquivalentCCTerms());
            int n = 0;
            while (n < termVariableArray.length) {
                object2 = this.mClausifier.getCCTerm(list.get(n));
                if (object2 != null) {
                    Object object3 = object = substitutionInfo.equals(this.mEMatching.getEmptySubs()) ? null : substitutionInfo.getVarSubs().get(n);
                    if (object != null) {
                        assert (((CCTerm)object).getRepresentative().equals(((CCTerm)object2).getRepresentative()));
                    } else {
                        hashMap.put((Term)termVariableArray[n], (CCTerm)object2);
                    }
                }
                ++n;
            }
            QuantLiteral quantLiteral2 = quantLiteral.getAtom();
            if (quantLiteral2 instanceof QuantBoundConstraint) {
                object2 = this.buildSharedMapFromCCMap(hashMap);
                instanceValue = this.evaluateBoundConstraintKnownShared((QuantBoundConstraint)quantLiteral2, (Map<Term, Term>)object2);
            } else {
                object2 = (QuantEquality)quantLiteral2;
                instanceValue = this.evaluateCCEqualityKnownShared((QuantEquality)object2, (Map<Term, CCTerm>)hashMap);
                if ((instanceValue == InstanceValue.ONE_UNDEF || instanceValue == InstanceValue.UNKNOWN_TERM) && ((QuantEquality)object2).getLhs().getSort().isNumericSort()) {
                    object = this.buildSharedMapFromCCMap(hashMap);
                    instanceValue = this.evaluateLAEqualityKnownShared((QuantEquality)object2, (Map<Term, Term>)object);
                }
            }
            if (quantLiteral.isNegated()) {
                instanceValue = instanceValue.negate();
            }
        }
        return new InstantiationInfo(instanceValue, instanceValue == InstanceValue.IRRELEVANT ? new ArrayList() : this.getTermSubsFromSubsInfo(quantLiteral, substitutionInfo));
    }

    private InstanceValue evaluateLitInstance(QuantLiteral quantLiteral, List<Term> list) {
        InstanceValue instanceValue = this.mDefaultValueForLitDawgs;
        boolean bl = quantLiteral.isNegated();
        QuantLiteral quantLiteral2 = quantLiteral.getAtom();
        if (quantLiteral2 instanceof QuantEquality) {
            QuantEquality quantEquality = (QuantEquality)quantLiteral2;
            instanceValue = this.evaluateCCEquality(quantEquality, list);
            if ((instanceValue == InstanceValue.ONE_UNDEF || instanceValue == InstanceValue.UNKNOWN_TERM) && quantEquality.getLhs().getSort().isNumericSort()) {
                instanceValue = this.evaluateLAEquality(quantEquality, list);
            }
        } else {
            instanceValue = this.evaluateBoundConstraint((QuantBoundConstraint)quantLiteral2, list);
        }
        if (bl) {
            instanceValue = instanceValue.negate();
        }
        return instanceValue;
    }

    private Dawg<Term, InstantiationInfo> computeArithLitDawg(QuantLiteral quantLiteral, Term[][] termArray) {
        Object object;
        TermVariable termVariable;
        int n;
        int n2;
        QuantLiteral quantLiteral2 = quantLiteral.getAtom();
        int n3 = quantLiteral.getClause().getVars().length;
        TermVariable[] termVariableArray = quantLiteral2.getTerm().getFreeVars();
        assert (termVariableArray.length == 1 || termVariableArray.length == 2);
        TermVariable termVariable2 = termVariableArray[0];
        TermVariable termVariable3 = termVariableArray.length == 2 ? termVariableArray[1] : null;
        int n4 = quantLiteral.getClause().getVarIndex(termVariableArray[0]);
        int n5 = n2 = termVariable3 == null ? n4 : quantLiteral.getClause().getVarIndex(termVariableArray[1]);
        if (termVariable3 != null && n2 > n4) {
            n = n4;
            n4 = n2;
            n2 = n;
            termVariable = termVariable2;
            termVariable2 = termVariable3;
            termVariable3 = termVariable;
        }
        n = termVariable3 == null ? 1 : termArray[n2].length;
        termVariable = new LinkedHashMap();
        int n6 = n3 - n4 - 1;
        Dawg<Object, InstantiationInfo> dawg = null;
        int n7 = 0;
        while (n7 < n) {
            Term term = termVariable3 != null ? termArray[n2][n7] : null;
            object = new ArrayList();
            int n8 = 0;
            while (n8 < n3) {
                object.add(null);
                ++n8;
            }
            object.set(n2, term);
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            Term[] termArray2 = termArray[n4];
            int n9 = termArray2.length;
            int n10 = 0;
            while (n10 < n9) {
                Term term2 = termArray2[n10];
                InstanceValue instanceValue = InstanceValue.ONE_UNDEF;
                HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
                hashMap.put((Term)termVariable2, term2);
                if (termVariable3 != null) {
                    hashMap.put((Term)termVariable3, term);
                }
                instanceValue = quantLiteral2 instanceof QuantBoundConstraint ? this.evaluateBoundConstraintKnownShared((QuantBoundConstraint)quantLiteral2, hashMap) : this.evaluateLAEqualityKnownShared((QuantEquality)quantLiteral2, hashMap);
                if (quantLiteral.isNegated()) {
                    instanceValue = instanceValue.negate();
                }
                long l = System.nanoTime();
                if (instanceValue != this.mDefaultValueForLitDawgs) {
                    object.set(n4, term2);
                    Dawg dawg2 = Dawg.createConst(n6, new InstantiationInfo(instanceValue, new ArrayList<Term>((Collection<Term>)object)));
                    linkedHashMap.put(term2, dawg2);
                }
                this.mQuantTheory.addDawgTime(System.nanoTime() - l);
                ++n10;
            }
            long l = System.nanoTime();
            Dawg<Term, InstantiationInfo> dawg3 = Dawg.createDawg(linkedHashMap, Dawg.createConst(n6, new InstantiationInfo(this.mDefaultValueForLitDawgs, new ArrayList<Term>())));
            if (termVariable3 != null) {
                termVariable.put(term, this.createAncestorDawg(dawg3, n4 - n2 - 1));
            } else {
                dawg = dawg3;
            }
            this.mQuantTheory.addDawgTime(System.nanoTime() - l);
            ++n7;
        }
        long l = System.nanoTime();
        if (termVariable3 != null) {
            dawg = Dawg.createDawg(termVariable, Dawg.createConst(quantLiteral.getClause().getVars().length - n2 - 1, new InstantiationInfo(this.mDefaultValueForLitDawgs, new ArrayList<Term>())));
        }
        object = this.createAncestorDawg(dawg, n2);
        this.mQuantTheory.addDawgTime(System.nanoTime() - l);
        return object;
    }

    private Dawg<Term, InstantiationInfo> createAncestorDawg(Dawg<Term, InstantiationInfo> dawg, int n) {
        Dawg<Term, InstantiationInfo> dawg2 = dawg;
        int n2 = 0;
        while (n2 < n) {
            dawg2 = Dawg.createDawg(Collections.emptyMap(), dawg2);
            ++n2;
        }
        return dawg2;
    }

    private Collection<InstantiationInfo> getRelevantSubsFromDawg(QuantClause quantClause, Dawg<Term, InstantiationInfo> dawg) {
        ArrayList<InstantiationInfo> arrayList = new ArrayList<InstantiationInfo>();
        for (InstantiationInfo instantiationInfo : dawg.values()) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return Collections.emptySet();
            }
            List<Term> list = instantiationInfo.getSubs();
            InstanceValue instanceValue = instantiationInfo.getInstValue();
            if (instanceValue == InstanceValue.IRRELEVANT || list.isEmpty()) continue;
            boolean bl = true;
            int n = 0;
            while (n < list.size()) {
                if (list.get(n) == null) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            arrayList.add(instantiationInfo);
        }
        return arrayList;
    }

    private Map<Term, Term> buildSharedMapFromCCMap(Map<Term, CCTerm> map) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry<Term, CCTerm> entry : map.entrySet()) {
            CCTerm cCTerm = entry.getValue();
            Term term = cCTerm.getFlatTerm();
            hashMap.put(entry.getKey(), term);
        }
        return hashMap;
    }

    private MutableAffineTerm buildMutableAffineTerm(Polynomial polynomial, Map<Term, Term> map) {
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        for (Map.Entry<Map<Term, Integer>, Rational> entry : polynomial.getSummands().entrySet()) {
            Polynomial polynomial2 = new Polynomial();
            polynomial2.add(entry.getValue());
            for (Map.Entry<Term, Integer> entry2 : entry.getKey().entrySet()) {
                Term term;
                if (entry2.getKey().getFreeVars().length == 0) {
                    term = entry2.getKey();
                } else {
                    term = map.get(entry2.getKey());
                    if (term == null) {
                        return null;
                    }
                }
                int n = 0;
                while (n < entry2.getValue()) {
                    polynomial2.mul(new Polynomial(term));
                    ++n;
                }
            }
            MutableAffineTerm object2 = this.mClausifier.toMutableAffineTerm(polynomial2);
            if (object2 == null) {
                return null;
            }
            mutableAffineTerm.add(entry.getValue(), object2);
        }
        return mutableAffineTerm;
    }

    private Term[][] computeSubsForArithmetical(QuantClause quantClause, Collection<QuantLiteral> collection, Dawg<Term, InstantiationInfo> dawg) {
        TermVariable[] termVariableArray = quantClause.getVars();
        int n = termVariableArray.length;
        TermVariable[] termVariableArray2 = new TermVariable[n];
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            if (!quantClause.getGroundBounds(termVariable).isEmpty() || !quantClause.getVarBounds(termVariable).isEmpty()) {
                termVariableArray2[n2] = termVariable;
            }
            ++n2;
        }
        LinkedHashSet[] linkedHashSetArray = new LinkedHashSet[n];
        int n3 = 0;
        while (n3 < n) {
            linkedHashSetArray[n3] = new LinkedHashSet();
            if (termVariableArray2[n3] != null) {
                linkedHashSetArray[n3].addAll(quantClause.getGroundBounds(termVariableArray2[n3]));
            }
            ++n3;
        }
        for (Dawg.Entry<Term, InstantiationInfo> entry : dawg.entrySet()) {
            if (entry.getValue().getInstValue() == InstanceValue.IRRELEVANT) continue;
            int n4 = 0;
            while (n4 < n) {
                if (termVariableArray2[n4] != null) {
                    linkedHashSetArray[n4].add(entry.getKey().get(n4));
                }
                ++n4;
            }
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            int n5 = 0;
            while (n5 < termVariableArray2.length) {
                TermVariable termVariable = termVariableArray2[n5];
                if (termVariable != null) {
                    for (TermVariable termVariable2 : quantClause.getVarBounds(termVariable)) {
                        int n6 = quantClause.getVarIndex(termVariable2);
                        bl = linkedHashSetArray[n5].addAll(linkedHashSetArray[n6]);
                    }
                }
                ++n5;
            }
        }
        Term[][] termArrayArray = new Term[n][];
        int n7 = 0;
        while (n7 < n) {
            termArrayArray[n7] = linkedHashSetArray[n7].toArray(new Term[linkedHashSetArray[n7].size()]);
            ++n7;
        }
        return termArrayArray;
    }

    private Set<List<Term>> computeAllSubstitutions(QuantClause quantClause) {
        int n = quantClause.getVars().length;
        LinkedHashSet<List<Term>> linkedHashSet = new LinkedHashSet<List<Term>>();
        linkedHashSet.add(new ArrayList(n));
        int n2 = 0;
        while (n2 < n) {
            LinkedHashSet linkedHashSet2 = new LinkedHashSet();
            for (List list : linkedHashSet) {
                if (this.mClausifier.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                assert (!quantClause.getInterestingTerms()[n2].isEmpty());
                for (Term term : quantClause.getInterestingTerms()[n2].values()) {
                    ArrayList<Term> arrayList = new ArrayList<Term>(n);
                    arrayList.addAll(list);
                    arrayList.add(term);
                    linkedHashSet2.add(arrayList);
                }
            }
            linkedHashSet.clear();
            linkedHashSet.addAll(linkedHashSet2);
            ++n2;
        }
        return linkedHashSet;
    }

    private InstanceValue evaluateClauseInstance(QuantClause quantClause, List<Term> list) {
        ILiteral iLiteral;
        InstanceValue instanceValue = InstanceValue.FALSE;
        ILiteral[] iLiteralArray = quantClause.getGroundLits();
        int n = iLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            iLiteral = iLiteralArray[n2];
            if (iLiteral.getAtom().getDecideStatus() == iLiteral) {
                return this.combineForCheckpoint(instanceValue, InstanceValue.TRUE);
            }
            if (iLiteral.getAtom().getDecideStatus() == null) {
                instanceValue = this.combineForCheckpoint(instanceValue, InstanceValue.ONE_UNDEF);
            } else assert (iLiteral.getAtom().getDecideStatus() != iLiteral);
            ++n2;
        }
        if (instanceValue == InstanceValue.IRRELEVANT) {
            return instanceValue;
        }
        iLiteralArray = quantClause.getQuantLits();
        n = iLiteralArray.length;
        n2 = 0;
        while (n2 < n) {
            iLiteral = iLiteralArray[n2];
            InstanceValue instanceValue2 = this.evaluateLitInstance((QuantLiteral)iLiteral, list);
            if ((instanceValue = this.combineForCheckpoint(instanceValue, instanceValue2)) == InstanceValue.IRRELEVANT) {
                return instanceValue;
            }
            ++n2;
        }
        return instanceValue;
    }

    private Pair<InstanceValue, Boolean> evaluateNewClauseInstanceFinalCheck(QuantClause quantClause, List<Term> list) {
        assert (!this.mClauseInstances.containsKey(quantClause) || !this.mClauseInstances.get(quantClause).containsKey(list));
        InstanceValue instanceValue = InstanceValue.FALSE;
        Literal[] literalArray = quantClause.getGroundLits();
        int n = literalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Literal literal = literalArray[n2];
            assert (literal.getAtom().getDecideStatus() != null);
            if (literal.getAtom().getDecideStatus() == literal) {
                return new Pair<InstanceValue, Object>(InstanceValue.TRUE, null);
            }
            ++n2;
        }
        boolean bl = true;
        QuantLiteral[] quantLiteralArray = quantClause.getQuantLits();
        int n3 = quantLiteralArray.length;
        n = 0;
        while (n < n3) {
            QuantLiteral quantLiteral = quantLiteralArray[n];
            InstanceValue instanceValue2 = this.evaluateLitInstance(quantLiteral, list);
            if (instanceValue2 == InstanceValue.UNKNOWN_TERM) {
                bl = false;
            }
            if ((instanceValue = instanceValue.combine(instanceValue2)) == InstanceValue.TRUE) {
                return new Pair<InstanceValue, Object>(instanceValue, null);
            }
            ++n;
        }
        return new Pair<InstanceValue, Boolean>(instanceValue, bl);
    }

    private InstClause computeClauseInstance(QuantClause quantClause, List<Term> list, QuantifierTheory.InstanceOrigin instanceOrigin) {
        InstClause instClause;
        assert (this.mClauseInstances.containsKey(quantClause));
        if (this.mClauseInstances.get(quantClause).containsKey(list)) {
            return this.mClauseInstances.get(quantClause).get(list);
        }
        LinkedHashMap<TermVariable, Term> linkedHashMap = new LinkedHashMap<TermVariable, Term>();
        int n = 0;
        while (n < list.size()) {
            linkedHashMap.put(quantClause.getVars()[n], list.get(n));
            ++n;
        }
        SubstitutionHelper substitutionHelper = new SubstitutionHelper(this.mQuantTheory, quantClause.getGroundLits(), quantClause.getQuantLits(), quantClause.getQuantSource(), linkedHashMap);
        SubstitutionHelper.SubstitutionResult substitutionResult = substitutionHelper.substituteInClause();
        if (substitutionResult.isTriviallyTrue()) {
            instClause = null;
        } else {
            assert (substitutionResult.isGround());
            this.mQuantTheory.getLogger().debug("Quant: instantiating quant clause %s results in %s", quantClause, Arrays.asList(substitutionResult.mGroundLits));
            instClause = new InstClause(quantClause, list, Arrays.asList(substitutionResult.mGroundLits), -1, instanceOrigin, substitutionResult.mSimplified);
        }
        this.mClauseInstances.get(quantClause).put(list, instClause);
        ++this.mQuantTheory.mNumInstancesProduced;
        if (instanceOrigin.equals((Object)QuantifierTheory.InstanceOrigin.CONFLICT)) {
            ++this.mQuantTheory.mNumInstancesProducedConfl;
        } else if (instanceOrigin.equals((Object)QuantifierTheory.InstanceOrigin.EMATCHING)) {
            ++this.mQuantTheory.mNumInstancesProducedEM;
        } else if (instanceOrigin.equals((Object)QuantifierTheory.InstanceOrigin.ENUMERATION)) {
            ++this.mQuantTheory.mNumInstancesProducedEnum;
        }
        this.recordSubstAgeForStats(this.getMaxAge(list), instanceOrigin.equals((Object)QuantifierTheory.InstanceOrigin.ENUMERATION));
        return instClause;
    }

    private InstanceValue evaluateCCEqualityKnownShared(QuantEquality quantEquality, Map<Term, CCTerm> map) {
        CCTerm cCTerm = quantEquality.getLhs().getFreeVars().length == 0 ? this.mClausifier.getCCTerm(quantEquality.getLhs()) : map.get(quantEquality.getLhs());
        CCTerm cCTerm2 = quantEquality.getRhs().getFreeVars().length == 0 ? this.mClausifier.getCCTerm(quantEquality.getRhs()) : map.get(quantEquality.getRhs());
        if (cCTerm != null && cCTerm2 != null) {
            if (this.mQuantTheory.getCClosure().isEqSet(cCTerm, cCTerm2)) {
                return InstanceValue.TRUE;
            }
            if (this.mQuantTheory.getCClosure().isDiseqSet(cCTerm, cCTerm2)) {
                return InstanceValue.FALSE;
            }
            return InstanceValue.ONE_UNDEF;
        }
        return this.mDefaultValueForLitDawgs;
    }

    private InstanceValue evaluateCCEquality(QuantEquality quantEquality, List<Term> list) {
        QuantClause quantClause = quantEquality.getClause();
        TermFinder termFinder = new TermFinder(quantClause.getVars(), list);
        Term term = termFinder.findEquivalentShared(quantEquality.getLhs());
        Term term2 = termFinder.findEquivalentShared(quantEquality.getRhs());
        if (term != null && term2 != null) {
            CCTerm cCTerm = this.mClausifier.getCCTerm(term);
            CCTerm cCTerm2 = this.mClausifier.getCCTerm(term2);
            if (cCTerm != null && cCTerm2 != null) {
                if (this.mQuantTheory.getCClosure().isEqSet(cCTerm, cCTerm2)) {
                    return InstanceValue.TRUE;
                }
                if (this.mQuantTheory.getCClosure().isDiseqSet(cCTerm, cCTerm2)) {
                    return InstanceValue.FALSE;
                }
            }
            return InstanceValue.ONE_UNDEF;
        }
        return this.mDefaultValueForLitDawgs;
    }

    private InstanceValue evaluateLAEqualityKnownShared(QuantEquality quantEquality, Map<Term, Term> map) {
        Polynomial polynomial = new Polynomial(quantEquality.getLhs());
        polynomial.add(Rational.MONE, quantEquality.getRhs());
        MutableAffineTerm mutableAffineTerm = this.buildMutableAffineTerm(polynomial, map);
        if (mutableAffineTerm != null) {
            InfinitesimalNumber infinitesimalNumber = this.mQuantTheory.mLinArSolve.getUpperBound(mutableAffineTerm);
            mutableAffineTerm.negate();
            InfinitesimalNumber infinitesimalNumber2 = this.mQuantTheory.mLinArSolve.getUpperBound(mutableAffineTerm);
            if (infinitesimalNumber.signum() == 0 && infinitesimalNumber2.signum() == 0) {
                return InstanceValue.TRUE;
            }
            if (infinitesimalNumber.signum() < 0 || infinitesimalNumber2.signum() < 0) {
                return InstanceValue.FALSE;
            }
            return InstanceValue.ONE_UNDEF;
        }
        return this.mDefaultValueForLitDawgs;
    }

    private InstanceValue evaluateLAEquality(QuantEquality quantEquality, List<Term> list) {
        Polynomial polynomial = new Polynomial(quantEquality.getLhs());
        polynomial.add(Rational.MONE, quantEquality.getRhs());
        QuantClause quantClause = quantEquality.getClause();
        TermFinder termFinder = new TermFinder(quantClause.getVars(), list);
        Polynomial polynomial2 = termFinder.findEquivalentAffine(polynomial);
        if (polynomial2 == null) {
            return this.mDefaultValueForLitDawgs;
        }
        MutableAffineTerm mutableAffineTerm = this.mClausifier.toMutableAffineTerm(polynomial2);
        if (mutableAffineTerm == null) {
            return this.mDefaultValueForLitDawgs;
        }
        InfinitesimalNumber infinitesimalNumber = this.mQuantTheory.mLinArSolve.getUpperBound(mutableAffineTerm);
        polynomial2.mul(Rational.MONE);
        InfinitesimalNumber infinitesimalNumber2 = this.mQuantTheory.mLinArSolve.getUpperBound(mutableAffineTerm);
        if (infinitesimalNumber.signum() == 0 && infinitesimalNumber2.signum() == 0) {
            return InstanceValue.TRUE;
        }
        if (infinitesimalNumber.signum() < 0 || infinitesimalNumber2.signum() < 0) {
            return InstanceValue.FALSE;
        }
        return InstanceValue.ONE_UNDEF;
    }

    private InstanceValue evaluateBoundConstraintKnownShared(QuantBoundConstraint quantBoundConstraint, Map<Term, Term> map) {
        MutableAffineTerm mutableAffineTerm = this.buildMutableAffineTerm(quantBoundConstraint.getAffineTerm(), map);
        if (mutableAffineTerm == null) {
            return this.mDefaultValueForLitDawgs;
        }
        InfinitesimalNumber infinitesimalNumber = this.mQuantTheory.mLinArSolve.getUpperBound(mutableAffineTerm);
        if (infinitesimalNumber.lesseq(InfinitesimalNumber.ZERO)) {
            return InstanceValue.TRUE;
        }
        mutableAffineTerm.negate();
        InfinitesimalNumber infinitesimalNumber2 = this.mQuantTheory.mLinArSolve.getUpperBound(mutableAffineTerm);
        if (infinitesimalNumber2.less(InfinitesimalNumber.ZERO)) {
            return InstanceValue.FALSE;
        }
        return InstanceValue.ONE_UNDEF;
    }

    private InstanceValue evaluateBoundConstraint(QuantBoundConstraint quantBoundConstraint, List<Term> list) {
        TermFinder termFinder = new TermFinder(quantBoundConstraint.getClause().getVars(), list);
        Polynomial polynomial = termFinder.findEquivalentAffine(quantBoundConstraint.getAffineTerm());
        if (polynomial == null) {
            return this.mDefaultValueForLitDawgs;
        }
        MutableAffineTerm mutableAffineTerm = this.mClausifier.toMutableAffineTerm(polynomial);
        if (mutableAffineTerm == null) {
            return this.mDefaultValueForLitDawgs;
        }
        InfinitesimalNumber infinitesimalNumber = this.mQuantTheory.mLinArSolve.getUpperBound(mutableAffineTerm);
        if (infinitesimalNumber.lesseq(InfinitesimalNumber.ZERO)) {
            return InstanceValue.TRUE;
        }
        mutableAffineTerm.mul(Rational.MONE);
        InfinitesimalNumber infinitesimalNumber2 = this.mQuantTheory.mLinArSolve.getUpperBound(mutableAffineTerm);
        if (infinitesimalNumber2.less(InfinitesimalNumber.ZERO)) {
            return InstanceValue.FALSE;
        }
        return InstanceValue.ONE_UNDEF;
    }

    private void recordSubstAgeForStats(int n, boolean bl) {
        int n2;
        assert (n >= 0);
        int n3 = n2 = 32 - Integer.numberOfLeadingZeros(n);
        this.mQuantTheory.mNumInstancesOfAge[n3] = this.mQuantTheory.mNumInstancesOfAge[n3] + 1;
        if (bl) {
            int n4 = n2;
            this.mQuantTheory.mNumInstancesOfAgeEnum[n4] = this.mQuantTheory.mNumInstancesOfAgeEnum[n4] + 1;
        }
    }

    private /* synthetic */ InstantiationInfo lambda$5(QuantLiteral quantLiteral, InstantiationInfo instantiationInfo, EMatching.SubstitutionInfo substitutionInfo) {
        return this.combineForCheckpoint(instantiationInfo, this.evaluateLitForPartialEMatchingSubsInfo(quantLiteral, instantiationInfo, substitutionInfo));
    }

    private /* synthetic */ InstantiationInfo lambda$6(QuantLiteral quantLiteral, List list, InstantiationInfo instantiationInfo) {
        return this.combineForCheckpoint(instantiationInfo, new InstantiationInfo(this.evaluateLitInstance(quantLiteral, list), instantiationInfo.getSubs()));
    }

    private static enum InstanceValue {
        TRUE,
        FALSE,
        ONE_UNDEF,
        UNKNOWN_TERM,
        OTHER,
        IRRELEVANT;


        private InstanceValue combine(InstanceValue instanceValue) {
            if (this == IRRELEVANT || instanceValue == IRRELEVANT) {
                return IRRELEVANT;
            }
            if (this == TRUE || instanceValue == TRUE) {
                return TRUE;
            }
            if (this == FALSE) {
                return instanceValue;
            }
            if (instanceValue == FALSE) {
                return this;
            }
            return OTHER;
        }

        private InstanceValue negate() {
            if (this == TRUE) {
                return FALSE;
            }
            if (this == FALSE) {
                return TRUE;
            }
            return this;
        }

        private InstanceValue keepOnlyRelevant(List<InstanceValue> list) {
            for (InstanceValue instanceValue : list) {
                if (this != instanceValue) continue;
                return this;
            }
            return IRRELEVANT;
        }
    }

    private class InstantiationInfo {
        private final InstanceValue mValue;
        private final List<Term> mSubs;

        private InstantiationInfo(InstanceValue instanceValue, List<Term> list) {
            this.mValue = instanceValue;
            this.mSubs = list;
        }

        InstanceValue getInstValue() {
            return this.mValue;
        }

        List<Term> getSubs() {
            return this.mSubs;
        }

        public String toString() {
            return "InstInfo: [" + String.valueOf((Object)this.mValue) + String.valueOf(this.mSubs) + "]";
        }

        public int hashCode() {
            return this.mSubs.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof InstantiationInfo) {
                InstantiationInfo instantiationInfo = (InstantiationInfo)object;
                return this.mValue == instantiationInfo.getInstValue() && this.mSubs.equals(instantiationInfo.getSubs());
            }
            return false;
        }
    }

    private class TermFinder
    extends NonRecursive {
        private final List<TermVariable> mVars;
        private final List<Term> mSubstitution;
        private final Map<Term, Term> mTerms;

        TermFinder(TermVariable[] termVariableArray, List<Term> list) {
            this.mVars = Arrays.asList(termVariableArray);
            this.mSubstitution = list;
            this.mTerms = new HashMap<Term, Term>();
        }

        Term findEquivalentShared(Term term) {
            this.enqueueWalker(new FindTerm(term));
            this.run();
            return this.mTerms.get(term);
        }

        Polynomial findEquivalentAffine(Polynomial polynomial) {
            for (Map<Term, Integer> map : polynomial.getSummands().keySet()) {
                for (Term term : map.keySet()) {
                    this.enqueueWalker(new FindTerm(term));
                }
            }
            this.run();
            return this.buildEquivalentAffine(polynomial);
        }

        private Polynomial buildEquivalentAffine(Polynomial polynomial) {
            Polynomial polynomial2 = new Polynomial();
            for (Map.Entry<Map<Term, Integer>, Rational> entry : polynomial.getSummands().entrySet()) {
                Polynomial polynomial3 = new Polynomial();
                polynomial3.add(Rational.ONE);
                for (Map.Entry<Term, Integer> entry2 : entry.getKey().entrySet()) {
                    Term term = this.mTerms.get(entry2.getKey());
                    if (term == null) {
                        return null;
                    }
                    Polynomial polynomial4 = new Polynomial(term);
                    int n = 0;
                    while (n < entry2.getValue()) {
                        polynomial3.mul(polynomial4);
                        ++n;
                    }
                }
                polynomial2.add(entry.getValue(), polynomial3);
            }
            return polynomial2;
        }

        class FindSharedAffine
        implements NonRecursive.Walker {
            private final Term mTerm;
            private final Polynomial mSmtAff;

            FindSharedAffine(Term term, Polynomial polynomial) {
                this.mTerm = term;
                this.mSmtAff = polynomial;
            }

            public void walk(NonRecursive nonRecursive) {
                Polynomial polynomial = TermFinder.this.buildEquivalentAffine(this.mSmtAff);
                if (polynomial != null) {
                    Term term = polynomial.toTerm(this.mTerm.getSort());
                    CCTerm cCTerm = ((TermFinder)TermFinder.this).InstantiationManager.this.mQuantTheory.getCClosure().getCCTermRep(term);
                    if (cCTerm != null) {
                        TermFinder.this.mTerms.put(this.mTerm, cCTerm.getFlatTerm());
                    }
                }
            }
        }

        class FindSharedAppTerm
        implements NonRecursive.Walker {
            private final Term mTerm;
            private final FunctionSymbol mFunc;
            private final Term[] mParams;

            public FindSharedAppTerm(Term term, FunctionSymbol functionSymbol, Term[] termArray) {
                this.mTerm = term;
                this.mFunc = functionSymbol;
                this.mParams = termArray;
            }

            public void walk(NonRecursive nonRecursive) {
                Object object;
                Term[] termArray = new Term[this.mParams.length];
                int n = 0;
                while (n < this.mParams.length) {
                    object = TermFinder.this.mTerms.get(this.mParams[n]);
                    if (object == null) {
                        return;
                    }
                    termArray[n] = object;
                    ++n;
                }
                Term term = ((TermFinder)TermFinder.this).InstantiationManager.this.mClausifier.getTheory().term(this.mFunc, termArray);
                object = ((TermFinder)TermFinder.this).InstantiationManager.this.mQuantTheory.getCClosure().getCCTermRep(term);
                if (object != null) {
                    TermFinder.this.mTerms.put(this.mTerm, ((CCTerm)object).getFlatTerm());
                }
            }
        }

        class FindTerm
        implements NonRecursive.Walker {
            private final Term mTerm;

            public FindTerm(Term term) {
                this.mTerm = term;
            }

            public void walk(NonRecursive nonRecursive) {
                block4: {
                    FunctionSymbol functionSymbol;
                    block7: {
                        block6: {
                            block5: {
                                if (TermFinder.this.mTerms.containsKey(this.mTerm)) break block4;
                                if (this.mTerm.getFreeVars().length != 0) break block5;
                                TermFinder.this.mTerms.put(this.mTerm, this.mTerm);
                                break block4;
                            }
                            if (!(this.mTerm instanceof TermVariable)) break block6;
                            TermFinder.this.mTerms.put(this.mTerm, TermFinder.this.mSubstitution.get(TermFinder.this.mVars.indexOf(this.mTerm)));
                            break block4;
                        }
                        assert (this.mTerm instanceof ApplicationTerm);
                        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTerm;
                        functionSymbol = applicationTerm.getFunction();
                        if (!Clausifier.needCCTerm((Term)applicationTerm)) break block7;
                        Term[] termArray = applicationTerm.getParameters();
                        TermFinder.this.enqueueWalker(new FindSharedAppTerm(this.mTerm, functionSymbol, termArray));
                        Term[] termArray2 = termArray;
                        int n = termArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Term term = termArray2[n2];
                            TermFinder.this.enqueueWalker(new FindTerm(term));
                            ++n2;
                        }
                        break block4;
                    }
                    if (functionSymbol.getName() != "+" && functionSymbol.getName() != "*" && functionSymbol.getName() != "-") break block4;
                    Polynomial polynomial = new Polynomial(this.mTerm);
                    TermFinder.this.enqueueWalker(new FindSharedAffine(this.mTerm, polynomial));
                    for (Map<Term, Integer> map : polynomial.getSummands().keySet()) {
                        for (Term term : map.keySet()) {
                            TermFinder.this.enqueueWalker(new FindTerm(term));
                        }
                    }
                }
            }
        }
    }
}

