/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ScopedIdentityHashMap<K, V>
extends AbstractMap<K, V> {
    IdentityHashMap<K, V> mMap = new IdentityHashMap();
    IdentityHashMap<K, V>[] mHistory = new IdentityHashMap[5];
    int mCurScope = -1;

    private IdentityHashMap<K, V> undoMap() {
        return this.mHistory[this.mCurScope];
    }

    private void recordUndo(K k, V v) {
        IdentityHashMap<K, V> identityHashMap;
        if (this.mCurScope != -1 && !(identityHashMap = this.undoMap()).containsKey(k)) {
            identityHashMap.put(k, v);
        }
    }

    private void undoEntry(Map.Entry<K, V> entry) {
        if (entry.getValue() == null) {
            this.mMap.remove(entry.getKey());
        } else {
            this.mMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void beginScope() {
        if (this.mCurScope == this.mHistory.length - 1) {
            this.mHistory = (IdentityHashMap[])ScopeUtils.grow((Object[])this.mHistory);
        }
        this.mHistory[++this.mCurScope] = new IdentityHashMap();
    }

    public void endScope() {
        for (Map.Entry<K, V> entry : this.undoMap().entrySet()) {
            this.undoEntry(entry);
        }
        this.mHistory[this.mCurScope--] = null;
        if (ScopeUtils.shouldShrink((Object[])this.mHistory)) {
            this.mHistory = (IdentityHashMap[])ScopeUtils.shrink((Object[])this.mHistory);
        }
    }

    public Iterable<Map.Entry<K, V>> currentScopeEntries() {
        if (this.mCurScope == -1) {
            return this.entrySet();
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedIdentityHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        final Object k = this.mLast.getKey();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return k;
                            }

                            @Override
                            public V getValue() {
                                return ((this).this).ScopedIdentityHashMap.this.mMap.get(k);
                            }

                            @Override
                            public V setValue(V v) {
                                return ((this).this).ScopedIdentityHashMap.this.mMap.put(k, v);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedIdentityHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedIdentityHashMap.this.undoMap().size();
            }
        };
    }

    public Iterable<K> currentScopeKeys() {
        if (this.mCurScope == -1) {
            return this.keySet();
        }
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedIdentityHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public K next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast.getKey();
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedIdentityHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedIdentityHashMap.this.undoMap().size();
            }
        };
    }

    public Iterable<V> currentScopeValues() {
        if (this.mCurScope == -1) {
            return this.values();
        }
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedIdentityHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public V next() {
                        this.mLast = this.mBacking.next();
                        return (this).ScopedIdentityHashMap.this.mMap.get(this.mLast.getKey());
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedIdentityHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedIdentityHashMap.this.undoMap().size();
            }
        };
    }

    @Override
    public void clear() {
        this.mMap.clear();
        this.mHistory = new IdentityHashMap[5];
    }

    @Override
    public boolean containsKey(Object object) {
        return this.mMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.mMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.mMap.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public boolean isEmptyScope() {
        return this.mCurScope == -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = (this).ScopedIdentityHashMap.this.mMap.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast;
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedIdentityHashMap.this.recordUndo(this.mLast.getKey(), this.mLast.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return ScopedIdentityHashMap.this.mMap.size();
            }
        };
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        V v2 = this.mMap.put(k, v);
        this.recordUndo(k, v2);
        return v2;
    }

    @Override
    public V remove(Object object) {
        V v = this.mMap.remove(object);
        this.recordUndo(object, v);
        return v;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    public int currentScopeSize() {
        return this.undoMap().size();
    }

    public int getActiveScopeNum() {
        return this.mCurScope + 1;
    }
}

