/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICPossibleIncompleteType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import java.util.Arrays;
import java.util.Objects;

public final class CEnum
implements ICType,
ICPossibleIncompleteType<CEnum> {
    private final String[] mNames;
    private final String mIdentifier;
    private final boolean mIsComplete;

    public CEnum(String string, String[] stringArray) {
        assert (string != null);
        this.mIdentifier = string;
        this.mNames = stringArray;
        this.mIsComplete = true;
    }

    public CEnum(String string) {
        this.mIdentifier = string;
        this.mIsComplete = false;
        this.mNames = null;
    }

    public int getFieldCount() {
        if (this.mNames == null) {
            return 0;
        }
        return this.mNames.length;
    }

    public String[] getFieldIds() {
        return this.mNames;
    }

    @Override
    public String getName() {
        return this.mIdentifier;
    }

    @Override
    public String toString() {
        return this.mIdentifier;
    }

    @Override
    public boolean isIncomplete() {
        return !this.mIsComplete;
    }

    @Override
    public CEnum complete(CEnum cEnum) {
        return new CEnum(this.getName(), cEnum.getFieldIds());
    }

    public static ICType replaceEnumWithInt(ICType iCType) {
        if (iCType.getUnderlyingType() instanceof CEnum) {
            return new CPrimitive(CPrimitive.CPrimitives.INT);
        }
        return iCType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mIdentifier, this.mIsComplete, Arrays.hashCode(this.mNames));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CEnum cEnum = (CEnum)object;
        return Objects.equals(this.mIdentifier, cEnum.mIdentifier) && this.mIsComplete == cEnum.mIsComplete && Arrays.equals(this.mNames, cEnum.mNames);
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isIntegerType() {
        return true;
    }
}

