/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedWitnessInvariant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class ExtractedLoopInvariant
extends ExtractedWitnessInvariant {
    public ExtractedLoopInvariant(String string, IASTNode iASTNode) {
        super(string, iASTNode);
    }

    @Override
    public ExpressionResult transform(ILocation iLocation, IDispatcher iDispatcher, ExpressionResult expressionResult) {
        ExpressionResult expressionResult2 = this.instrument(iLocation, iDispatcher);
        Expression expression = ExtractedLoopInvariant.tryToExtractLoopInvariant(expressionResult2);
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        boolean bl = false;
        for (Statement statement : expressionResult.getStatements()) {
            if (statement instanceof WhileStatement) {
                if (bl) {
                    throw new UnsupportedOperationException("The result contains multiple loops, unable to match the invariant.");
                }
                bl = true;
                WhileStatement whileStatement = (WhileStatement)statement;
                if (expression != null) {
                    arrayList.add((Statement)ExtractedLoopInvariant.addLoopInvariant(whileStatement, expression, iLocation));
                    continue;
                }
                ArrayList<Statement> arrayList2 = new ArrayList<Statement>(expressionResult2.getStatements());
                Statement[] statementArray = (Statement[])DataStructureUtils.concat((Object[])whileStatement.getBody(), (Object[])((Statement[])arrayList2.toArray(Statement[]::new)));
                arrayList.addAll(arrayList2);
                arrayList.add((Statement)new WhileStatement(iLocation, whileStatement.getCondition(), whileStatement.getInvariants(), statementArray));
                continue;
            }
            arrayList.add(statement);
        }
        if (bl) {
            return new ExpressionResultBuilder(expressionResult).addAllExceptLrValueAndStatements(expressionResult2).resetStatements(arrayList).build();
        }
        return new ExpressionResultBuilder(expressionResult2).addAllIncludingLrValue(expressionResult).build();
    }

    private static Expression tryToExtractLoopInvariant(ExpressionResult expressionResult) {
        if (expressionResult.getStatements().size() != 1) {
            return null;
        }
        Statement statement = expressionResult.getStatements().get(0);
        if (!(statement instanceof AssertStatement)) {
            return null;
        }
        return ((AssertStatement)statement).getFormula();
    }

    private static WhileStatement addLoopInvariant(WhileStatement whileStatement, Expression expression, ILocation iLocation) {
        ArrayList<LoopInvariantSpecification> arrayList = new ArrayList<LoopInvariantSpecification>(Arrays.asList(whileStatement.getInvariants()));
        LoopInvariantSpecification loopInvariantSpecification = new LoopInvariantSpecification(iLocation, false, expression);
        Check check = new Check(Spec.WITNESS_INVARIANT);
        check.annotate((IElement)loopInvariantSpecification);
        arrayList.add(loopInvariantSpecification);
        return new WhileStatement(iLocation, whileStatement.getCondition(), (LoopInvariantSpecification[])arrayList.toArray(LoopInvariantSpecification[]::new), whileStatement.getBody());
    }

    @Override
    protected String getLocationDescription() {
        return "Loop invariant at";
    }
}

