/*
 * Decompiled with CFR 0.152.
 */
package lazabs.viewer;

import ap.theories.ADT;
import java.io.Serializable;
import lazabs.ast.ASTree;
import lazabs.ast.ASTree$ArraySelect$;
import lazabs.ast.ASTree$ArrayUpdate$;
import lazabs.ast.ASTree$Conjunction$;
import lazabs.ast.ASTree$Disjunction$;
import lazabs.ast.ASTree$Equality$;
import lazabs.ast.ASTree$Inequality$;
import lazabs.ast.ASTree$LessThanEqual$;
import lazabs.ast.ASTree$Modulo$;
import lazabs.ast.ASTree$Not$;
import lazabs.horn.global.HornClause;
import lazabs.horn.global.HornLiteral;
import lazabs.horn.global.Interp;
import lazabs.horn.global.RelVar;
import lazabs.viewer.ScalaPrinter$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class HornPrinter$ {
    public static HornPrinter$ MODULE$;

    static {
        new HornPrinter$();
    }

    public String apply(Seq<HornClause> system) {
        return ((TraversableOnce)system.map((Function1 & Serializable & scala.Serializable)h -> MODULE$.print((HornClause)h), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String getAlphabeticChar(int i) {
        int alpha = i / 26;
        return new StringBuilder(0).append((char)(i % 26 + 65)).append(alpha > 0 ? Integer.toString(alpha) : "").toString().toString();
    }

    public String print(HornClause h) {
        ObjectRef varMap = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).empty());
        IntRef curVarCounter = IntRef.create((int)-1);
        return new StringBuilder(5).append(this.printHornLiteral$1(h.head(), varMap, curVarCounter)).append(" :- ").append(((TraversableOnce)h.body().map((Function1 & Serializable & scala.Serializable)hl -> this.printHornLiteral$1((HornLiteral)hl, varMap, curVarCounter), List$.MODULE$.canBuildFrom())).mkString(",")).append(".").toString();
    }

    public String printDebug(HornLiteral lit) {
        HornLiteral hornLiteral = lit;
        if (hornLiteral instanceof Interp) {
            Interp interp = (Interp)hornLiteral;
            ASTree.Expression f = interp.value();
            return ScalaPrinter$.MODULE$.apply(f);
        }
        if (hornLiteral instanceof RelVar) {
            RelVar relVar = (RelVar)hornLiteral;
            String name = relVar.varName();
            List<ASTree.Parameter> params = relVar.params();
            return new StringBuilder(2).append(name).append("(").append(((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)p -> {
                if (p.name().startsWith("sc_")) {
                    return (String)new StringOps(Predef$.MODULE$.augmentString(p.name())).drop(3);
                }
                return p.name();
            }, List$.MODULE$.canBuildFrom())).mkString(",")).append(")").toString();
        }
        throw new MatchError((Object)hornLiteral);
    }

    public String printDebug(HornClause h) {
        return new StringBuilder(4).append(this.printDebug(h.head())).append(" :- ").append(((TraversableOnce)h.body().map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.printDebug((HornLiteral)x$6), List$.MODULE$.canBuildFrom())).mkString(" , ")).toString();
    }

    private static final int getNewVarCounter$1(IntRef curVarCounter$1) {
        ++curVarCounter$1.elem;
        return curVarCounter$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$print$1(char x$1) {
        return x$1 == '_';
    }

    public static final /* synthetic */ String $anonfun$print$2(int x$2) {
        return "und";
    }

    public static final /* synthetic */ boolean $anonfun$print$3(char x$3) {
        return x$3 == '_';
    }

    private final String printHornLiteral$1(HornLiteral hl, ObjectRef varMap$1, IntRef curVarCounter$1) {
        HornLiteral hornLiteral = hl;
        if (hornLiteral instanceof Interp) {
            Interp interp = (Interp)hornLiteral;
            ASTree.Expression v = interp.value();
            return this.printExp$1(v, (List)Nil$.MODULE$, varMap$1, curVarCounter$1);
        }
        if (hornLiteral instanceof RelVar) {
            RelVar relVar = (RelVar)hornLiteral;
            String varName = relVar.varName();
            List<ASTree.Parameter> params = relVar.params();
            String removePrefix = varName.startsWith("_") ? new StringBuilder(0).append(((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new StringOps(Predef$.MODULE$.augmentString(varName)).prefixLength((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HornPrinter$.$anonfun$print$1(BoxesRunTime.unboxToChar((Object)x$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> HornPrinter$.$anonfun$print$2(BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom())).mkString()).append(new StringOps(Predef$.MODULE$.augmentString(varName)).dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HornPrinter$.$anonfun$print$3(BoxesRunTime.unboxToChar((Object)x$3))))).toString() : varName;
            return new StringBuilder(0).append(removePrefix.toLowerCase()).append((Object)(params.isEmpty() ? "" : new StringBuilder(2).append("(").append(((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)p -> this.printParameter$1((ASTree.Parameter)p, varMap$1, curVarCounter$1), List$.MODULE$.canBuildFrom())).mkString(",")).append(")").toString())).toString();
        }
        throw new MatchError((Object)hornLiteral);
    }

    private final String printParameter$1(ASTree.Parameter p, ObjectRef varMap$1, IntRef curVarCounter$1) {
        Option option = ((Map)varMap$1.elem).get((Object)p.name());
        if (option instanceof Some) {
            Some some = (Some)option;
            int i = BoxesRunTime.unboxToInt((Object)some.value());
            return this.getAlphabeticChar(i);
        }
        if (None$.MODULE$.equals(option)) {
            int newIndex = HornPrinter$.getNewVarCounter$1(curVarCounter$1);
            varMap$1.elem = ((Map)varMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)BoxesRunTime.boxToInteger((int)newIndex)));
            return this.getAlphabeticChar(newIndex);
        }
        throw new MatchError((Object)option);
    }

    private final String printExp$1(ASTree.Expression e2, List vars, ObjectRef varMap$1, IntRef curVarCounter$1) {
        Option<Object> option;
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option2;
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option3;
        boolean bl = false;
        ASTree.Variable variable = null;
        ASTree.Expression expression = e2;
        if (expression instanceof ASTree.Existential) {
            String name;
            ASTree.Existential existential = (ASTree.Existential)expression;
            ASTree.Expression qe = existential.qe();
            String string = name = new StringBuilder(3).append("VAR").append(vars.size()).toString();
            return new StringBuilder(6).append("EX ").append(name).append(" (").append(this.printExp$1(qe, vars.$colon$colon((Object)string), varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.Universal) {
            String name;
            ASTree.Universal universal = (ASTree.Universal)expression;
            ASTree.Expression qe = universal.qe();
            String string = name = new StringBuilder(3).append("VAR").append(vars.size()).toString();
            return new StringBuilder(7).append("ALL ").append(name).append(" (").append(this.printExp$1(qe, vars.$colon$colon((Object)string), varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option4 = ASTree$Conjunction$.MODULE$.unapply(expression);
        if (!option4.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option4.get())._1();
            ASTree.Expression e22 = (ASTree.Expression)((Tuple2)option4.get())._2();
            return new StringBuilder(4).append("(").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(", ").append(this.printExp$1(e22, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option5 = ASTree$Disjunction$.MODULE$.unapply(expression);
        if (!option5.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option5.get())._1();
            ASTree.Expression e23 = (ASTree.Expression)((Tuple2)option5.get())._2();
            return new StringBuilder(4).append("(").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append("; ").append(this.printExp$1(e23, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option6 = ASTree$Equality$.MODULE$.unapply(expression);
        if (!option6.isEmpty()) {
            ASTree.Expression expression2 = (ASTree.Expression)((Tuple2)option6.get())._1();
            ASTree.Expression expression3 = (ASTree.Expression)((Tuple2)option6.get())._2();
            if (expression2 instanceof ASTree.NumericalConst) {
                ASTree.NumericalConst numericalConst = (ASTree.NumericalConst)expression2;
                BigInt num = numericalConst.num();
                if (expression3 instanceof ASTree.ADTtest) {
                    ASTree.ADTtest aDTtest = (ASTree.ADTtest)expression3;
                    ADT adt = aDTtest.adt();
                    int sortNum = aDTtest.sortNum();
                    ASTree.Expression expr = aDTtest.v();
                    return new StringBuilder(5).append("is-").append(adt.getCtorPerSort(sortNum, num.toInt()).name()).append("(").append(this.printExp$1(expr, vars, varMap$1, curVarCounter$1)).append(")").toString();
                }
            }
        }
        if (!(option3 = ASTree$Equality$.MODULE$.unapply(expression)).isEmpty()) {
            ASTree.Expression expression4 = (ASTree.Expression)((Tuple2)option3.get())._1();
            ASTree.Expression expression5 = (ASTree.Expression)((Tuple2)option3.get())._2();
            if (expression4 instanceof ASTree.ADTtest) {
                ASTree.ADTtest aDTtest = (ASTree.ADTtest)expression4;
                ADT adt = aDTtest.adt();
                int sortNum = aDTtest.sortNum();
                ASTree.Expression expr = aDTtest.v();
                if (expression5 instanceof ASTree.NumericalConst) {
                    ASTree.NumericalConst numericalConst = (ASTree.NumericalConst)expression5;
                    BigInt num = numericalConst.num();
                    return new StringBuilder(5).append("is-").append(adt.getCtorPerSort(sortNum, num.toInt()).name()).append("(").append(this.printExp$1(expr, vars, varMap$1, curVarCounter$1)).append(")").toString();
                }
            }
        }
        if (!(option2 = ASTree$Equality$.MODULE$.unapply(expression)).isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option2.get())._1();
            ASTree.Expression e24 = (ASTree.Expression)((Tuple2)option2.get())._2();
            return new StringBuilder(5).append("(").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" = ").append(this.printExp$1(e24, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option7 = ASTree$Inequality$.MODULE$.unapply(expression);
        if (!option7.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option7.get())._1();
            ASTree.Expression e25 = (ASTree.Expression)((Tuple2)option7.get())._2();
            return new StringBuilder(7).append("\\+(").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" = ").append(this.printExp$1(e25, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option8 = ASTree$LessThanEqual$.MODULE$.unapply(expression);
        if (!option8.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option8.get())._1();
            ASTree.Expression e26 = (ASTree.Expression)((Tuple2)option8.get())._2();
            return new StringBuilder(6).append("(").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" =< ").append(this.printExp$1(e26, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option9 = ASTree$Modulo$.MODULE$.unapply(expression);
        if (!option9.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option9.get())._1();
            ASTree.Expression e27 = (ASTree.Expression)((Tuple2)option9.get())._2();
            return new StringBuilder(7).append("(").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" mod ").append(this.printExp$1(e27, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option10 = ASTree$ArraySelect$.MODULE$.unapply(expression);
        if (!option10.isEmpty()) {
            ASTree.Expression ar = (ASTree.Expression)((Tuple2)option10.get())._1();
            ASTree.Expression ind = (ASTree.Expression)((Tuple2)option10.get())._2();
            return new StringBuilder(10).append("select(").append(this.printExp$1(ar, vars, varMap$1, curVarCounter$1)).append(", ").append(this.printExp$1(ind, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple3<ASTree.Expression, ASTree.Expression, ASTree.Expression>> option11 = ASTree$ArrayUpdate$.MODULE$.unapply(expression);
        if (!option11.isEmpty()) {
            ASTree.Expression ar = (ASTree.Expression)((Tuple3)option11.get())._1();
            ASTree.Expression ind = (ASTree.Expression)((Tuple3)option11.get())._2();
            ASTree.Expression value = (ASTree.Expression)((Tuple3)option11.get())._3();
            return new StringBuilder(11).append("store(").append(this.printExp$1(ar, vars, varMap$1, curVarCounter$1)).append(", ").append(this.printExp$1(ind, vars, varMap$1, curVarCounter$1)).append(", ").append(this.printExp$1(value, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.BinaryExpression) {
            ASTree.BinaryExpression binaryExpression = (ASTree.BinaryExpression)expression;
            ASTree.Expression e1 = binaryExpression.e1();
            ASTree.BinaryOperator op = binaryExpression.op();
            ASTree.Expression e28 = binaryExpression.e2();
            return new StringBuilder(4).append("(").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(op.st()).append(" ").append(this.printExp$1(e28, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.ADTctor) {
            ASTree.ADTctor aDTctor = (ASTree.ADTctor)expression;
            String name = aDTctor.name();
            Seq<ASTree.Expression> exprList = aDTctor.exprList();
            return new StringBuilder(2).append(name).append("(").append(((TraversableOnce)exprList.map((Function1 & Serializable & scala.Serializable)e -> this.printExp$1((ASTree.Expression)e, vars, varMap$1, curVarCounter$1), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
        }
        if (expression instanceof ASTree.ADTsel) {
            ASTree.ADTsel aDTsel = (ASTree.ADTsel)expression;
            String name = aDTsel.name();
            Seq<ASTree.Expression> exprList = aDTsel.exprList();
            return new StringBuilder(2).append(name).append("(").append(((TraversableOnce)exprList.map((Function1 & Serializable & scala.Serializable)e -> this.printExp$1((ASTree.Expression)e, vars, varMap$1, curVarCounter$1), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
        }
        if (expression instanceof ASTree.ADTsize) {
            ASTree.ADTsize aDTsize = (ASTree.ADTsize)expression;
            ASTree.Expression v = aDTsize.v();
            return new StringBuilder(7).append("_size(").append(this.printExp$1(v, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<ASTree.Expression> option12 = ASTree$Not$.MODULE$.unapply(expression);
        if (!option12.isEmpty()) {
            ASTree.Expression e3 = (ASTree.Expression)option12.get();
            return new StringBuilder(4).append("\\+(").append(this.printExp$1(e3, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.UnaryExpression) {
            ASTree.UnaryExpression unaryExpression = (ASTree.UnaryExpression)expression;
            ASTree.UnaryOperator op = unaryExpression.op();
            ASTree.Expression e4 = unaryExpression.e();
            return new StringBuilder(2).append(op.st()).append("(").append(this.printExp$1(e4, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.Variable) {
            bl = true;
            variable = (ASTree.Variable)expression;
            String name = variable.name();
            Option<Object> option13 = variable.deBruijn();
            if (None$.MODULE$.equals(option13)) {
                Option option14 = ((Map)varMap$1.elem).get((Object)name);
                if (option14 instanceof Some) {
                    Some some = (Some)option14;
                    int i = BoxesRunTime.unboxToInt((Object)some.value());
                    return this.getAlphabeticChar(i);
                }
                if (None$.MODULE$.equals(option14)) {
                    int newIndex = HornPrinter$.getNewVarCounter$1(curVarCounter$1);
                    varMap$1.elem = ((Map)varMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)BoxesRunTime.boxToInteger((int)newIndex)));
                    return this.getAlphabeticChar(newIndex);
                }
                throw new MatchError((Object)option14);
            }
        }
        if (expression instanceof ASTree.HeapFun) {
            ASTree.HeapFun heapFun = (ASTree.HeapFun)expression;
            String name = heapFun.name();
            Seq<ASTree.Expression> exprList = heapFun.exprList();
            return new StringBuilder(2).append(name).append("(").append(((TraversableOnce)exprList.map((Function1 & Serializable & scala.Serializable)e -> this.printExp$1((ASTree.Expression)e, vars, varMap$1, curVarCounter$1), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
        }
        if (expression instanceof ASTree.HeapPred) {
            ASTree.HeapPred heapPred = (ASTree.HeapPred)expression;
            String name = heapPred.name();
            Seq<ASTree.Expression> exprList = heapPred.exprList();
            return new StringBuilder(2).append(name).append("(").append(((TraversableOnce)exprList.map((Function1 & Serializable & scala.Serializable)e -> this.printExp$1((ASTree.Expression)e, vars, varMap$1, curVarCounter$1), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
        }
        if (bl && (option = variable.deBruijn()) instanceof Some) {
            Some some = (Some)option;
            int index = BoxesRunTime.unboxToInt((Object)some.value());
            if (index < vars.size()) {
                return (String)vars.apply(index);
            }
            return this.getAlphabeticChar(index - vars.size());
        }
        if (expression instanceof ASTree.NumericalConst) {
            ASTree.NumericalConst numericalConst = (ASTree.NumericalConst)expression;
            BigInt num = numericalConst.num();
            return num.toString();
        }
        if (expression instanceof ASTree.BoolConst) {
            ASTree.BoolConst boolConst = (ASTree.BoolConst)expression;
            boolean v = boolConst.value();
            return String.valueOf(BoxesRunTime.boxToBoolean((boolean)v));
        }
        if (expression instanceof ASTree.BVconst) {
            ASTree.BVconst bVconst = (ASTree.BVconst)expression;
            BigInt v = bVconst.num();
            return String.valueOf(v);
        }
        throw new Exception("Invalid expression");
    }

    private HornPrinter$() {
        MODULE$ = this;
    }
}

