/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieConstructedType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class TypeSortTranslator {
    protected final Script mScript;
    private final Map<IBoogieType, Sort> mType2Sort = new HashMap<IBoogieType, Sort>();
    private final Map<Sort, IBoogieType> mSort2Type = new HashMap<Sort, IBoogieType>();
    private final Map<String, Map<String, Expression[]>> mType2Attributes = new HashMap<String, Map<String, Expression[]>>();
    private final IUltimateServiceProvider mServices;

    public TypeSortTranslator(Collection<TypeDeclaration> collection, Script script, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mScript = script;
        Sort sort2 = SmtSortUtils.getBoolSort((Script)this.mScript);
        BoogiePrimitiveType boogiePrimitiveType = BoogieType.TYPE_BOOL;
        this.cacheSort((IBoogieType)boogiePrimitiveType, sort2);
        for (TypeDeclaration typeDeclaration : collection) {
            this.declareType(typeDeclaration);
        }
    }

    public TypeSortTranslator(HashRelation<Sort, IBoogieType> hashRelation, Script script, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mScript = script;
        for (Map.Entry entry : hashRelation.getSetOfPairs()) {
            this.cacheSort((IBoogieType)entry.getValue(), (Sort)entry.getKey());
        }
    }

    public TypeSortTranslator(Script script, IUltimateServiceProvider iUltimateServiceProvider) {
        this(Collections.emptySet(), script, iUltimateServiceProvider);
        Sort sort = SmtSortUtils.getIntSort((Script)this.mScript);
        BoogiePrimitiveType boogiePrimitiveType = BoogieType.TYPE_INT;
        this.cacheSort((IBoogieType)boogiePrimitiveType, sort);
    }

    public IBoogieType getType(Sort sort) {
        IBoogieType iBoogieType = this.mSort2Type.get(sort);
        if (iBoogieType == null) {
            if (sort.isArraySort()) {
                assert (SmtSortUtils.isArraySort((Sort)sort));
                Sort sort2 = sort.getArguments()[0];
                Sort sort3 = sort.getArguments()[1];
                BoogieType[] boogieTypeArray = new BoogieType[]{(BoogieType)this.getType(sort2)};
                BoogieType boogieType = (BoogieType)this.getType(sort3);
                iBoogieType = BoogieType.createArrayType((int)0, (BoogieType[])boogieTypeArray, (BoogieType)boogieType);
            } else {
                if (SmtSortUtils.isBitvecSort((Sort)sort)) {
                    String string = sort.getIndices()[0];
                    iBoogieType = BoogieType.createBitvectorType((int)Integer.valueOf(string));
                    return iBoogieType;
                }
                throw new IllegalArgumentException("Unknown sort " + String.valueOf(sort));
            }
        }
        return iBoogieType;
    }

    public Sort getSort(IBoogieType iBoogieType, BoogieASTNode boogieASTNode) {
        if (iBoogieType instanceof BoogieType) {
            iBoogieType = ((BoogieType)iBoogieType).getUnderlyingType();
        }
        if (this.mType2Sort.containsKey(iBoogieType)) {
            return this.mType2Sort.get(iBoogieType);
        }
        return this.constructSort(iBoogieType, boogieASTNode);
    }

    private void declareType(TypeDeclaration typeDeclaration) {
        String string;
        String[] stringArray = typeDeclaration.getTypeParams();
        if (stringArray.length != 0) {
            throw new IllegalArgumentException("Only types without parameters supported");
        }
        String string2 = typeDeclaration.getIdentifier();
        Map<String, Expression[]> map = Boogie2SmtSymbolTable.extractAttributes((Declaration)typeDeclaration);
        if (map != null) {
            this.mType2Attributes.put(string2, map);
            string = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(map, "builtin");
            if (string != null) {
                return;
            }
        }
        if (typeDeclaration.getSynonym() == null) {
            this.mScript.declareSort(string2, 0);
        } else {
            string = this.getSort(typeDeclaration.getSynonym().getBoogieType(), (BoogieASTNode)typeDeclaration);
            this.mScript.defineSort(string2, new Sort[0], (Sort)string);
        }
    }

    protected Sort constructSort(IBoogieType iBoogieType, BoogieASTNode boogieASTNode) {
        try {
            Sort sort = this.constructSort(iBoogieType, this.mType2Attributes::get);
            return sort;
        }
        catch (SMTLIBException sMTLIBException) {
            if ("Sort Array not declared".equals(sMTLIBException.getMessage())) {
                Boogie2SMT.reportUnsupportedSyntax(boogieASTNode, "Solver does not support arrays", this.mServices);
                throw sMTLIBException;
            }
            throw new AssertionError((Object)sMTLIBException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sort constructSort(IBoogieType iBoogieType, Function<String, Map<String, Expression[]>> function) {
        Sort sort;
        if (iBoogieType instanceof BoogiePrimitiveType) {
            if (iBoogieType.equals(BoogieType.TYPE_BOOL)) {
                sort = SmtSortUtils.getBoolSort((Script)this.mScript);
            } else if (iBoogieType.equals(BoogieType.TYPE_INT)) {
                sort = SmtSortUtils.getIntSort((Script)this.mScript);
            } else if (iBoogieType.equals(BoogieType.TYPE_REAL)) {
                sort = SmtSortUtils.getRealSort((Script)this.mScript);
            } else {
                if (iBoogieType.equals(BoogieType.TYPE_ERROR)) {
                    throw new IllegalArgumentException("BoogieAST contains type errors.");
                }
                if (((BoogiePrimitiveType)iBoogieType).getTypeCode() <= 0) throw new IllegalArgumentException("Unsupported PrimitiveType " + String.valueOf(iBoogieType));
                int n = ((BoogiePrimitiveType)iBoogieType).getTypeCode();
                sort = SmtSortUtils.getBitvectorSort((Script)this.mScript, (int)n);
            }
        } else if (iBoogieType instanceof BoogieArrayType) {
            BoogieArrayType boogieArrayType = (BoogieArrayType)iBoogieType;
            Sort sort2 = this.constructSort((IBoogieType)boogieArrayType.getValueType(), function);
            int n = boogieArrayType.getIndexCount() - 1;
            while (n >= 1) {
                Sort sort3 = this.constructSort((IBoogieType)boogieArrayType.getIndexType(n), function);
                sort2 = SmtSortUtils.getArraySort((Script)this.mScript, (Sort)sort3, (Sort)sort2);
                --n;
            }
            Sort sort4 = this.constructSort((IBoogieType)boogieArrayType.getIndexType(0), function);
            sort = SmtSortUtils.getArraySort((Script)this.mScript, (Sort)sort4, (Sort)sort2);
        } else {
            if (!(iBoogieType instanceof BoogieConstructedType)) throw new IllegalArgumentException("Unsupported type " + String.valueOf(iBoogieType));
            BoogieConstructedType boogieConstructedType = (BoogieConstructedType)iBoogieType;
            String string = boogieConstructedType.getConstr().getName();
            Map<String, Expression[]> map = function.apply(string);
            if (map == null) {
                sort = SmtSortUtils.getNamedSort((Script)this.mScript, (String)string);
            } else {
                String string2 = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(map, "builtin");
                if (string2 == null) {
                    sort = SmtSortUtils.getNamedSort((Script)this.mScript, (String)string);
                } else {
                    String[] stringArray = Boogie2SmtSymbolTable.checkForIndices(map);
                    sort = SmtSortUtils.getBuiltinSort((Script)this.mScript, (String)string2, (String[])stringArray);
                }
            }
        }
        this.cacheSort(iBoogieType, sort);
        return sort;
    }

    private void cacheSort(IBoogieType iBoogieType, Sort sort) {
        this.mType2Sort.put(iBoogieType, sort);
        this.mSort2Type.put(sort, iBoogieType);
    }
}

