/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class ImmutableList<X>
extends AbstractSequentialList<X> {
    private static final ImmutableList NIL = new ImmutableList();
    private final int mSize;
    private final X mHead;
    private final ImmutableList<X> mTail;

    private ImmutableList() {
        this.mSize = 0;
        this.mHead = null;
        this.mTail = null;
    }

    public ImmutableList(X x, ImmutableList<X> immutableList) {
        this.mSize = immutableList.mSize + 1;
        this.mHead = x;
        this.mTail = Objects.requireNonNull(immutableList);
    }

    @SafeVarargs
    public ImmutableList(X ... XArray) {
        this(Arrays.stream(XArray).iterator());
    }

    public ImmutableList(Collection<X> collection) {
        this(collection.iterator());
    }

    private ImmutableList(Iterator<X> iterator) {
        if (iterator.hasNext()) {
            this.mHead = iterator.next();
            this.mTail = iterator.hasNext() ? new ImmutableList<X>(iterator) : ImmutableList.empty();
            this.mSize = this.mTail.mSize + 1;
        } else {
            this.mHead = null;
            this.mTail = null;
            this.mSize = 0;
        }
    }

    public static <X> ImmutableList<X> empty() {
        return NIL;
    }

    public static <X> ImmutableList<X> singleton(X x) {
        return new ImmutableList<X>(x, ImmutableList.empty());
    }

    public X getHead() {
        if (this.mSize == 0) {
            throw new NoSuchElementException();
        }
        return this.mHead;
    }

    public ImmutableList<X> getTail() {
        if (this.mSize == 0) {
            throw new UnsupportedOperationException();
        }
        return this.mTail;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableList) {
            ImmutableList immutableList = (ImmutableList)object;
            if (this.mSize != immutableList.mSize) {
                return false;
            }
            if (this.mTail == immutableList.mTail) {
                return Objects.equals(this.mHead, immutableList.mHead);
            }
        }
        return super.equals(object);
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean add(X x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends X> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends X> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public X set(int n, X x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, X x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public X remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<X> listIterator(int n) {
        if (n < 0 || n > this.mSize) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n;
        ImmutableList<X> immutableList = this;
        while (n2 > 0) {
            immutableList = immutableList.mTail;
            --n2;
        }
        return new ConsListIterator<X>(immutableList, n2);
    }

    private static final class ConsListIterator<X>
    implements ListIterator<X> {
        private ImmutableList<X> mCurrent;
        private int mIndex;

        public ConsListIterator(ImmutableList<X> immutableList, int n) {
            this.mCurrent = immutableList;
            this.mIndex = n;
        }

        @Override
        public boolean hasNext() {
            return this.mCurrent != null && this.mCurrent.mSize > 0;
        }

        @Override
        public X next() {
            if (this.mCurrent == null || this.mCurrent.mSize == 0) {
                throw new NoSuchElementException();
            }
            Object x = this.mCurrent.mHead;
            this.mCurrent = this.mCurrent.mTail;
            ++this.mIndex;
            return x;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public X previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            return this.mIndex;
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(X x) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(X x) {
            throw new UnsupportedOperationException();
        }
    }
}

