/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.source.smtparser.chc;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.source.smtparser.Activator;

public class HCGBuilderHelper {

    public static class ConstructAndInitializeBackendSmtSolver {
        private final SolverBuilder.SolverSettings mSolverSettings;
        private final Logics mLogicForExternalSolver;
        private final ManagedScript mScript;

        public ConstructAndInitializeBackendSmtSolver(IUltimateServiceProvider iUltimateServiceProvider, String string) {
            IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
            SolverBuilder.SolverMode solverMode = (SolverBuilder.SolverMode)iPreferenceProvider.getEnum("SMT solver", SolverBuilder.SolverMode.class);
            String string2 = iPreferenceProvider.getString("Command for external solver");
            this.mLogicForExternalSolver = Logics.valueOf((String)iPreferenceProvider.getString("Logic for external solver"));
            String string3 = iPreferenceProvider.getString("Dump smtlib scripts to");
            boolean bl = !string3.isEmpty();
            SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setSolverMode(solverMode).setUseFakeIncrementalScript(false).setDumpSmtScriptToFile(bl, string3, string, false);
            this.mSolverSettings = solverMode.isExternal() ? solverSettings.setUseExternalSolver(true, string2, this.mLogicForExternalSolver) : solverSettings;
            Script script = SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)iUltimateServiceProvider, (SolverBuilder.SolverSettings)this.mSolverSettings, (String)"HornClauseSolverBackendSolverScript");
            this.mScript = new ManagedScript(iUltimateServiceProvider, script);
        }

        public SolverBuilder.SolverSettings getSolverSettings() {
            return this.mSolverSettings;
        }

        public Logics getLogicForExternalSolver() {
            return this.mLogicForExternalSolver;
        }

        public ManagedScript getScript() {
            return this.mScript;
        }
    }
}

