/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.Arrays;

public abstract class FunctionSymbolFactory {
    String mFuncName;
    UnifyHash<FunctionSymbol> mInstances;

    public FunctionSymbolFactory(String string) {
        this.mFuncName = string;
        this.mInstances = new UnifyHash();
    }

    public abstract Sort getResultSort(String[] var1, Sort[] var2, Sort var3);

    public int getFlags(String[] stringArray, Sort[] sortArray, Sort sort) {
        return 1;
    }

    private static boolean isReal(Sort[] sortArray) {
        Sort[] sortArray2 = sortArray;
        int n = sortArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sort sort = sortArray2[n2];
            if (sort.getRealSort() != sort) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Term getDefinition(TermVariable[] termVariableArray, Sort sort) {
        return null;
    }

    public FunctionSymbol getFunctionWithResult(Theory theory, String[] stringArray, Sort[] sortArray, Sort sort) {
        Term term;
        FunctionSymbol functionSymbol;
        Term[] termArray2;
        assert (FunctionSymbolFactory.isReal(sortArray));
        int n = this.getFlags(stringArray, sortArray, sort);
        if ((n & 0xE) != 0) {
            if (sortArray.length < 2) {
                return null;
            }
            Sort[] sortArray2 = new Sort[]{sortArray[0], sortArray[sortArray.length - 1]};
            termArray2 = (n & 0xE) == 2 ? sortArray2[1] : sortArray2[0];
            int n2 = 1;
            while (n2 < sortArray.length - 1) {
                if (sortArray[n2] != termArray2) {
                    return null;
                }
                ++n2;
            }
            sortArray = sortArray2;
        }
        if ((n & 0x10) == 0 != (sort == null)) {
            return null;
        }
        int n3 = Arrays.hashCode(stringArray) ^ Arrays.hashCode(sortArray) ^ (sort == null ? 0 : sort.hashCode());
        for (Term[] termArray2 : this.mInstances.iterateHashCode(n3)) {
            if (!Arrays.equals(termArray2.mIndices, stringArray) || !Arrays.equals(termArray2.mParamSort, sortArray) || sort != null && termArray2.mReturnSort != sort) continue;
            return termArray2;
        }
        if ((sort = this.getResultSort(stringArray, sortArray, sort)) == null) {
            return null;
        }
        termArray2 = new TermVariable[sortArray.length];
        int n4 = 0;
        while (n4 < sortArray.length) {
            termArray2[n4] = theory.createTermVariable("x" + n4, sortArray[n4]);
            ++n4;
        }
        if ((n & 0x10) != 0 && sort != sort.getRealSort()) {
            functionSymbol = this.getFunctionWithResult(theory, stringArray, sortArray, sort.getRealSort());
            term = theory.term(functionSymbol, termArray2);
        } else {
            term = this.getDefinition((TermVariable[])termArray2, sort);
        }
        if (term == null) {
            termArray2 = null;
        }
        functionSymbol = new FunctionSymbol(this.mFuncName, stringArray, sortArray, sort, (TermVariable[])termArray2, term, n);
        this.mInstances.put(n3, (Object)functionSymbol);
        return functionSymbol;
    }

    public String toString() {
        return this.mFuncName;
    }
}

