/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.models;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ModelUtils {
    private ModelUtils() {
    }

    public static void copyAnnotations(IElement iElement, IElement iElement2) {
        ModelUtils.copyAnnotationsFiltered(iElement, iElement2, iAnnotations -> true);
    }

    public static void mergeAnnotations(Collection<? extends IElement> collection, IElement iElement) {
        if (collection == null || iElement == null) {
            return;
        }
        List list = collection.stream().map(ModelUtils::getAnnotations).filter(map -> map != null).flatMap(map -> map.entrySet().stream()).collect(Collectors.toList());
        Map<String, IAnnotations> map2 = iElement.getPayload().getAnnotations();
        for (Map.Entry entry : list) {
            String string = (String)entry.getKey();
            IAnnotations iAnnotations = map2.get(string);
            if (iAnnotations != null) {
                IAnnotations iAnnotations2 = iAnnotations.merge((IAnnotations)entry.getValue());
                if (iAnnotations2 == null) continue;
                map2.put(string, iAnnotations2);
                continue;
            }
            map2.put(string, (IAnnotations)entry.getValue());
        }
    }

    public static void mergeAnnotations(IElement iElement, IElement ... iElementArray) {
        if (iElementArray == null || iElementArray.length == 0) {
            return;
        }
        ModelUtils.mergeAnnotations(Arrays.asList(iElementArray), iElement);
    }

    public static <E extends IAnnotations> void copyAnnotations(IElement iElement, IElement iElement2, Class<E> clazz) {
        if (iElement == null || iElement2 == null || clazz == null) {
            return;
        }
        ModelUtils.copyAnnotationsFiltered(iElement, iElement2, iAnnotations -> clazz.isAssignableFrom(iAnnotations.getClass()));
    }

    public static void copyAnnotationsExcept(IElement iElement, IElement iElement2, Class<?> ... classArray) {
        if (classArray == null || classArray.length == 0) {
            ModelUtils.copyAnnotations(iElement, iElement2);
            return;
        }
        ModelUtils.copyAnnotationsFiltered(iElement, iElement2, iAnnotations -> !Arrays.stream(classArray).anyMatch(clazz -> clazz.isAssignableFrom(iAnnotations.getClass())));
    }

    public static void copyAnnotationsFiltered(IElement iElement, IElement iElement2, Predicate<IAnnotations> predicate) {
        Map<String, IAnnotations> map = ModelUtils.getAnnotations(iElement);
        if (map == null) {
            return;
        }
        Map<String, IAnnotations> map2 = iElement2.getPayload().getAnnotations();
        for (Map.Entry<String, IAnnotations> entry : map.entrySet()) {
            IAnnotations iAnnotations;
            IAnnotations iAnnotations2;
            if (!predicate.test(entry.getValue()) || (iAnnotations2 = map2.put(entry.getKey(), entry.getValue())) == null || (iAnnotations = iAnnotations2.merge(entry.getValue())) == null) continue;
            map2.put(entry.getKey(), iAnnotations);
        }
    }

    public static void consumeAnnotations(IElement iElement, Consumer<Map.Entry<String, IAnnotations>> consumer) {
        Map<String, IAnnotations> map = ModelUtils.getAnnotations(iElement);
        if (map == null) {
            return;
        }
        map.entrySet().stream().forEach(consumer);
    }

    public static <T extends IAnnotations> T getAnnotation(IElement iElement, Class<T> clazz) {
        return (T)ModelUtils.getAnnotation(iElement, clazz.getName(), clazz::cast);
    }

    public static <T extends IAnnotations> T getAnnotation(IElement iElement, String string, Function<IAnnotations, T> function) {
        IAnnotations iAnnotations;
        IPayload iPayload;
        if (iElement == null) {
            return null;
        }
        if (iElement.hasPayload() && (iPayload = iElement.getPayload()).hasAnnotation() && (iAnnotations = iPayload.getAnnotations().get(string)) != null) {
            return (T)((IAnnotations)function.apply(iAnnotations));
        }
        return null;
    }

    private static Map<String, IAnnotations> getAnnotations(IElement iElement) {
        if (iElement == null) {
            return null;
        }
        if (!iElement.hasPayload()) {
            return null;
        }
        IPayload iPayload = iElement.getPayload();
        if (iPayload.hasAnnotation()) {
            return iPayload.getAnnotations();
        }
        return null;
    }
}

