/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.CachingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.AbsIntPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import java.util.List;
import java.util.Objects;

public abstract class AbsIntBaseInterpolantGenerator<LETTER extends IAction>
implements IInterpolatingTraceCheck<LETTER> {
    private final IPredicateUnifier mPredicateUnifier;
    private final Word<LETTER> mCex;
    private final IPredicate mPrecondition;
    private final IPredicate mPostcondition;
    private final InterpolantComputationStatus mStatus;

    AbsIntBaseInterpolantGenerator(IPredicateUnifier iPredicateUnifier, Word<LETTER> word, AbsIntPredicate<?> absIntPredicate, AbsIntPredicate<?> absIntPredicate2, InterpolantComputationStatus interpolantComputationStatus) {
        this.mPredicateUnifier = Objects.requireNonNull(iPredicateUnifier);
        this.mCex = word;
        this.mStatus = Objects.requireNonNull(interpolantComputationStatus);
        this.mPrecondition = absIntPredicate;
        this.mPostcondition = absIntPredicate2;
    }

    public List<LETTER> getTrace() {
        return this.mCex.asList();
    }

    public IPredicate getPrecondition() {
        return this.mPrecondition;
    }

    public IPredicate getPostcondition() {
        return this.mPostcondition;
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mPredicateUnifier;
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return this.mStatus;
    }

    public abstract CachingHoareTripleChecker getHoareTripleChecker();
}

