/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting.datastructures;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.ConjunctiveCounterFormula;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.ConjunctiveTransition;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.CountingAutomatonDataStructure;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CaDatastructureWriter<LETTER, STATE>
extends GeneralAutomatonPrinter {
    private final Map<LETTER, String> mAlphabet;
    private final Map<STATE, String> mStateMapping;

    public CaDatastructureWriter(PrintWriter printWriter, String string, CountingAutomatonDataStructure<LETTER, STATE> countingAutomatonDataStructure) {
        super(printWriter);
        this.mAlphabet = CaDatastructureWriter.getToStringMapping(countingAutomatonDataStructure.getAlphabet());
        this.mStateMapping = CaDatastructureWriter.getToStringMapping(countingAutomatonDataStructure.getStates());
        this.print("CountingAutomaton ");
        this.print(string);
        this.printAutomatonPrefix();
        this.printAlphabet();
        this.printCounters(countingAutomatonDataStructure.getCounters());
        this.printStates();
        this.printConditions("initialConditions", countingAutomatonDataStructure.getInitialConditions());
        this.printConditions("finalConditions", countingAutomatonDataStructure.getAcceptingConditions());
        this.printTransitions(countingAutomatonDataStructure);
        this.printAutomatonSuffix();
        this.finish();
    }

    private static <E> Map<E, String> getToStringMapping(Collection<E> collection) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        collection.stream().forEach(object -> {
            String string = linkedHashMap.put(object, CaDatastructureWriter.quoteAndReplaceBackslashes(object));
        });
        return linkedHashMap;
    }

    protected final void printElementPrefix(String string) {
        this.print(String.format("\t%s = ", string));
    }

    private void printAlphabet() {
        this.printCollectionPrefix("alphabet");
        this.printValues(this.mAlphabet);
        this.printCollectionSuffix();
    }

    private void printStates() {
        this.printCollectionPrefix("states");
        this.printValues(this.mStateMapping);
        this.printCollectionSuffix();
    }

    private void printCounters(Set<String> set) {
        this.printCollectionPrefix("counters");
        this.printCollection(set);
        this.printCollectionSuffix();
    }

    private void printConditions(String string, Map<STATE, Set<ConjunctiveCounterFormula>> map) {
        this.printCollectionPrefix(string);
        this.print(NEW_LINE);
        for (Map.Entry<STATE, Set<ConjunctiveCounterFormula>> entry : map.entrySet()) {
            this.printOneTransitionPrefix();
            this.print(this.mStateMapping.get(entry.getKey()));
            this.print(' ');
            this.printDisjunction(entry.getValue());
            this.printOneTransitionSuffix();
        }
        this.printTransitionsSuffix();
        this.print(',');
        this.print(NEW_LINE);
    }

    private void printDisjunction(Set<ConjunctiveCounterFormula> set) {
        String string = set.isEmpty() ? "false" : (set.size() == 1 ? set.iterator().next().toString() : String.format("(or %s)", set.stream().map(Object::toString).collect(Collectors.joining(" "))));
        this.print(CaDatastructureWriter.quoteAndReplaceBackslashes(string));
    }

    private void printTransitions(CountingAutomatonDataStructure<LETTER, STATE> countingAutomatonDataStructure) {
        this.printlnCollectionPrefix("transitions");
        for (STATE STATE : countingAutomatonDataStructure.getStates()) {
            for (ConjunctiveTransition<LETTER, STATE> conjunctiveTransition : countingAutomatonDataStructure.getOutgoingTransitions(STATE)) {
                this.printOneTransitionPrefix();
                this.print(this.mStateMapping.get(conjunctiveTransition.getPredecessor()));
                this.print(' ');
                this.print(this.mAlphabet.get(conjunctiveTransition.getLetter()));
                this.print(' ');
                this.print('\"');
                this.print(conjunctiveTransition.getGuard().toString());
                this.print('\"');
                this.print(' ');
                this.print('{');
                String string = conjunctiveTransition.getAssignment().stream().map(Object::toString).collect(Collectors.joining(","));
                this.print(string);
                this.print('}');
                this.print(' ');
                this.print(this.mStateMapping.get(conjunctiveTransition.getSuccessor()));
                this.printOneTransitionSuffix();
            }
        }
        this.printTransitionsSuffix();
        this.print(NEW_LINE);
    }
}

