/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.AutomatonSccComputation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class LoopComplexity<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mGraph;
    private final Integer mResult;
    private final HashMap<Set<STATE>, Integer> mStatesToLc = new HashMap();

    public LoopComplexity(AutomataLibraryServices automataLibraryServices, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton instanceof NestedWordAutomatonReachableStates ? iNestedWordAutomaton : new RemoveUnreachable<LETTER, STATE>(this.mServices, iNestedWordAutomaton).getResult();
        this.mGraph = this.constructGraph(iEmptyStackStateFactory);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeLoopComplexityOfSubgraph(this.mGraph.getStates());
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private NestedWordAutomatonReachableStates<LETTER, STATE> constructGraph(IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) throws AutomataOperationCanceledException {
        Object LETTER = this.mOperand.getVpAlphabet().getInternalAlphabet().iterator().next();
        Set set = Collections.singleton(LETTER);
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, new VpAlphabet(set, set, set), iEmptyStackStateFactory);
        for (STATE STATE : this.mOperand.getStates()) {
            nestedWordAutomaton.addState(true, true, STATE);
        }
        this.addOutgoingTransitions(LETTER, nestedWordAutomaton);
        return new RemoveUnreachable(this.mServices, nestedWordAutomaton).getResult();
    }

    private void addOutgoingTransitions(LETTER LETTER, NestedWordAutomaton<LETTER, STATE> nestedWordAutomaton) {
        for (STATE STATE : this.mOperand.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
                STATE STATE2 = outgoingInternalTransition.getSucc();
                if (nestedWordAutomaton.containsInternalTransition(STATE, LETTER, STATE2)) continue;
                nestedWordAutomaton.addInternalTransition(STATE, LETTER, STATE2);
            }
        }
    }

    private Integer computeLoopComplexityOfSubgraph(Set<STATE> set) throws AutomataOperationCanceledException {
        AutomatonSccComputation<LETTER, STATE> automatonSccComputation = new AutomatonSccComputation<LETTER, STATE>(this.mServices, this.mGraph, set, set);
        Collection<StronglyConnectedComponent<STATE>> collection = automatonSccComputation.getBalls();
        if (collection.isEmpty()) {
            return 0;
        }
        if (collection.size() == 1) {
            Set set2 = collection.iterator().next().getNodes();
            Collection<STATE> collection2 = this.extractNonchainStates(set2);
            if (collection2.isEmpty()) {
                return 1;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            HashSet<STATE> hashSet = new HashSet<STATE>(set);
            for (STATE STATE : collection2) {
                if (this.isCancellationRequested()) {
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                hashSet.remove(STATE);
                if (this.mStatesToLc.containsKey(hashSet)) {
                    arrayList.add(this.mStatesToLc.get(hashSet));
                } else {
                    Integer n = this.computeLoopComplexityOfSubgraph(hashSet);
                    HashSet<STATE> hashSet2 = new HashSet<STATE>(hashSet);
                    this.mStatesToLc.put(hashSet2, n);
                    arrayList.add(n);
                }
                hashSet.add(STATE);
            }
            return 1 + (Integer)Collections.min(arrayList);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (StronglyConnectedComponent<STATE> stronglyConnectedComponent : collection) {
            if (this.mStatesToLc.containsKey(stronglyConnectedComponent.getNodes())) {
                arrayList.add(this.mStatesToLc.get(stronglyConnectedComponent.getNodes()));
                continue;
            }
            Integer n = this.computeLoopComplexityOfSubgraph(stronglyConnectedComponent.getNodes());
            HashSet hashSet = new HashSet(stronglyConnectedComponent.getNodes());
            this.mStatesToLc.put(hashSet, n);
            arrayList.add(n);
        }
        return (Integer)Collections.max(arrayList);
    }

    private Collection<STATE> extractNonchainStates(Set<STATE> set) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (STATE STATE : set) {
            int n = 0;
            int n2 = 0;
            Iterable<IncomingInternalTransition<LETTER, STATE>> iterable = this.mGraph.internalPredecessors(STATE);
            Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable2 = this.mGraph.internalSuccessors(STATE);
            for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : iterable) {
                if (!set.contains(incomingInternalTransition.getPred())) continue;
                ++n;
            }
            for (OutgoingInternalTransition outgoingInternalTransition : iterable2) {
                if (!set.contains(outgoingInternalTransition.getSucc())) continue;
                ++n2;
            }
            assert (n > 0) : "must have at least one predecessor";
            assert (n2 > 0) : "must have at least one successor";
            if (n == 1 && n2 == 1) continue;
            arrayList.add(STATE);
        }
        return arrayList;
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Operand with " + this.mOperand.size() + " states has loop complexity " + String.valueOf(this.mResult);
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Integer getResult() {
        return this.mResult;
    }
}

