/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class MinimizeDfaSymbolic<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private int mNumberOfStates;
    private STATE mInitialState;
    private HashMap<STATE, Block> mPartition;
    private Worklist mWorklist;
    private HashMap<LETTER, Term> mLetter2Formular;
    private SMTInterpol mSmtInterpol;
    private Sort mBool;
    private Sort[] mEmptyArray;

    public MinimizeDfaSymbolic(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        long l = System.currentTimeMillis();
        this.minimizeDfaSymbolic();
        long l2 = System.currentTimeMillis();
        this.mLogger.info((Object)("Symbolic minimization time: " + (l2 - l) + " ms."));
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    private void minimizeDfaSymbolic() {
        this.initializeSolver();
        this.preprocessingData();
        this.initializePartitionAndWorklist();
        long l = System.currentTimeMillis();
        this.runLoop();
        this.buildResult();
        long l2 = System.currentTimeMillis();
        this.mLogger.info((Object)("Symbolic main time: " + (l2 - l) + " ms"));
    }

    private void preprocessingData() {
        this.mNumberOfStates = this.mOperand.size();
        this.mInitialState = this.mOperand.getInitialStates().iterator().next();
        Set set = this.mOperand.getVpAlphabet().getInternalAlphabet();
        this.mLetter2Formular = new HashMap(MinimizeDfaSymbolic.computeHashCap(set.size()));
        for (Object e : set) {
            try {
                this.mSmtInterpol.declareFun(e.toString(), this.mEmptyArray, this.mBool);
            }
            catch (SMTLIBException sMTLIBException) {
                this.mLogger.error((Object)"Function already exists! Not able to build twice!", (Throwable)sMTLIBException);
            }
            Term term = this.mSmtInterpol.term(e.toString(), new Term[0]);
            this.mLetter2Formular.put(e, term);
        }
    }

    private void initializePartitionAndWorklist() {
        Block block = new Block();
        Block block2 = new Block();
        this.mPartition = new HashMap(MinimizeDfaSymbolic.computeHashCap(this.mNumberOfStates));
        for (STATE STATE : this.mOperand.getStates()) {
            if (this.mOperand.isFinal(STATE)) {
                block.add(STATE);
                this.mPartition.put(STATE, block);
                continue;
            }
            block2.add(STATE);
            this.mPartition.put(STATE, block2);
        }
        this.mWorklist = new Worklist(2);
        this.mWorklist.push(block);
        this.mWorklist.push(block2);
    }

    private void runLoop() {
        while (!this.mWorklist.isEmpty()) {
            Object object;
            Iterator<Object> iterator;
            Block block;
            Block block2 = this.mWorklist.pop();
            HashMap<STATE, Term> hashMap = this.constructMapping(block2);
            Iterator<STATE> iterator2 = hashMap.keySet().iterator();
            HashMap<Block, Block> hashMap2 = this.buildIntersectingBlocksMap(iterator2);
            for (Block block3 : hashMap2.keySet()) {
                block = hashMap2.get(block3);
                if (block.size() >= block3.size()) continue;
                iterator = block.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    block3.remove(object);
                    this.mPartition.put(object, block);
                }
                if (this.mWorklist.contains(block3)) {
                    this.mWorklist.push(block);
                    continue;
                }
                if (block3.size() <= block.size()) {
                    this.mWorklist.push(block3);
                    continue;
                }
                this.mWorklist.push(block);
            }
            boolean bl = true;
            while (bl) {
                bl = false;
                iterator2 = hashMap.keySet().iterator();
                HashSet<Block> hashSet = this.buildIntersectingBlocksSet(iterator2);
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    Object object3;
                    block = (Block)iterator.next();
                    object = new Block();
                    Iterator iterator3 = block.iterator();
                    Object STATE = iterator3.next();
                    Term term = hashMap.get(STATE);
                    boolean bl2 = false;
                    ((Block)object).add(STATE);
                    while (iterator3.hasNext()) {
                        Term term2;
                        object3 = iterator3.next();
                        object2 = hashMap.get(object3);
                        if (bl2) {
                            term2 = this.conjunct(term, (Term)object2);
                            if (!this.isSatFormula(term2)) continue;
                            ((Block)object).add(object3);
                            term = term2;
                            continue;
                        }
                        term2 = this.negate((Term)object2);
                        Term term3 = this.conjunct(term, term2);
                        if (this.isSatFormula(term3)) {
                            term = term3;
                            bl2 = true;
                            continue;
                        }
                        Term term4 = this.negate(term);
                        Term term5 = this.conjunct((Term)object2, term4);
                        if (this.isSatFormula(term5)) {
                            ((Block)object).clear();
                            ((Block)object).add(object3);
                            term = term5;
                            bl2 = true;
                            continue;
                        }
                        ((Block)object).add(object3);
                    }
                    if (((Block)object).size() >= block.size()) continue;
                    bl = bl || block.size() > 2;
                    object3 = ((Block)object).iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        block.remove(object2);
                        this.mPartition.put(object2, (Block)object);
                    }
                    if (this.mWorklist.contains(block)) {
                        this.mWorklist.push((Block)object);
                        continue;
                    }
                    if (block.size() <= ((Block)object).size()) {
                        this.mWorklist.push(block);
                        continue;
                    }
                    this.mWorklist.push((Block)object);
                }
            }
        }
    }

    private void initializeSolver() {
        this.mSmtInterpol = new SMTInterpol();
        this.mSmtInterpol.setLogic(Logics.QF_UF);
        this.mBool = this.mSmtInterpol.sort("Bool", new Sort[0]);
        this.mEmptyArray = new Sort[0];
        throw new UnsupportedOperationException("Contact DD about creating SMTInterpol without SolverBuilder");
    }

    private HashMap<STATE, Term> constructMapping(Block block) {
        HashMap hashMap = new HashMap(MinimizeDfaSymbolic.computeHashCap(this.mNumberOfStates));
        Iterator iterator = block.iterator();
        while (iterator.hasNext()) {
            Object STATE = iterator.next();
            Set<LETTER> set = this.mOperand.lettersInternalIncoming(STATE);
            for (LETTER LETTER : set) {
                assert (this.hasIncomingTransitionWithLetter(STATE, LETTER));
                LinkedList linkedList = this.getPredecessor(STATE, LETTER);
                Term term = this.mLetter2Formular.get(LETTER);
                for (Object e : linkedList) {
                    Term term2 = (Term)hashMap.get(e);
                    if (term2 != null) {
                        hashMap.put(e, this.disjunct(term, term2));
                        continue;
                    }
                    hashMap.put(e, term);
                }
            }
        }
        return hashMap;
    }

    private HashSet<Block> buildIntersectingBlocksSet(Iterator<STATE> iterator) {
        HashSet<Block> hashSet = new HashSet<Block>(this.mNumberOfStates);
        while (iterator.hasNext()) {
            Block block = this.mPartition.get(iterator.next());
            if (hashSet.contains(block)) continue;
            hashSet.add(block);
        }
        return hashSet;
    }

    private HashMap<Block, Block> buildIntersectingBlocksMap(Iterator<STATE> iterator) {
        HashMap<Block, Block> hashMap = new HashMap<Block, Block>(MinimizeDfaSymbolic.computeHashCap(this.mNumberOfStates));
        while (iterator.hasNext()) {
            STATE STATE = iterator.next();
            Block block = this.mPartition.get(STATE);
            if (hashMap.containsKey(block)) {
                hashMap.get(block).add(STATE);
                continue;
            }
            Block block2 = new Block();
            block2.add(STATE);
            hashMap.put(block, block2);
        }
        return hashMap;
    }

    private boolean hasIncomingTransitionWithLetter(STATE STATE, LETTER LETTER) {
        return this.mOperand.internalPredecessors(STATE, LETTER).iterator().hasNext();
    }

    private LinkedList<STATE> getPredecessor(STATE STATE, LETTER LETTER) {
        LinkedList<STATE> linkedList = new LinkedList<STATE>();
        Iterator<IncomingInternalTransition<LETTER, STATE>> iterator = this.mOperand.internalPredecessors(STATE, LETTER).iterator();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next().getPred());
        }
        return linkedList;
    }

    private Term conjunct(Term term, Term term2) {
        Term[] termArray = new Term[]{term, term2};
        return this.mSmtInterpol.term("and", termArray);
    }

    private Term disjunct(Term term, Term term2) {
        Term[] termArray = new Term[]{term, term2};
        return this.mSmtInterpol.term("or", termArray);
    }

    private Term negate(Term term) {
        Term[] termArray = new Term[]{term};
        return this.mSmtInterpol.term("not", termArray);
    }

    private boolean isSatFormula(Term term) {
        this.mSmtInterpol.push(1);
        this.mSmtInterpol.assertTerm(term);
        Script.LBool lBool = this.mSmtInterpol.checkSat();
        this.mSmtInterpol.pop(1);
        return lBool == Script.LBool.SAT;
    }

    private void buildResult() {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap(MinimizeDfaSymbolic.computeHashCap(this.mPartition.size()));
        Block block = this.mPartition.get(this.mInitialState);
        Collection<Block> collection = this.mPartition.values();
        Iterator<Block> iterator = collection.iterator();
        HashSet<Block> hashSet = new HashSet<Block>(collection.size());
        this.startResultConstruction();
        while (iterator.hasNext()) {
            Block block2 = iterator.next();
            if (hashSet.contains(block2)) continue;
            hashSet.add(block2);
            object2 = block2.returnStates();
            object = this.mStateFactory.merge(object2);
            Object object3 = block2.iterator().next();
            hashMap.put(block2, object);
            this.addState(block2 == block, this.mOperand.isFinal(object3), object);
        }
        for (Block block2 : collection) {
            object2 = block2.iterator().next();
            object = hashMap.get(block2);
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(object2)) {
                Object STATE = outgoingInternalTransition.getSucc();
                Block block3 = this.mPartition.get(STATE);
                Object v = hashMap.get(block3);
                this.addInternalTransition(object, outgoingInternalTransition.getLetter(), v);
            }
        }
        this.finishResultConstruction(null, false);
    }

    public class Block {
        private HashSet<STATE> mStates;

        public Block(Collection<STATE> collection) {
            this.mStates = new HashSet(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.mStates.add(iterator.next());
            }
        }

        public Block(Block block) {
            this(block.returnStates());
        }

        public Block() {
            this.mStates = new HashSet(MinimizeDfaSymbolic.this.mNumberOfStates);
        }

        public boolean remove(STATE STATE) {
            return this.mStates.remove(STATE);
        }

        public void add(STATE STATE) {
            this.mStates.add(STATE);
        }

        public void clear() {
            this.mStates.clear();
        }

        public Iterator<STATE> iterator() {
            return this.mStates.iterator();
        }

        public int size() {
            return this.mStates.size();
        }

        public boolean contains(STATE STATE) {
            return this.mStates.contains(STATE);
        }

        public boolean isEmpty() {
            return this.mStates.isEmpty();
        }

        public Set<STATE> returnStates() {
            return this.mStates;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            Iterator iterator = this.mStates.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append('{');
                stringBuilder.append(iterator.next().toString());
                stringBuilder.append('}');
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    public class Worklist {
        private final HashSet<Block> mSetsOfStates;

        public Worklist(int n) {
            this.mSetsOfStates = new HashSet(n);
        }

        public Block pop() {
            if (this.mSetsOfStates.isEmpty()) {
                return null;
            }
            Block block = this.mSetsOfStates.iterator().next();
            this.mSetsOfStates.remove(block);
            return block;
        }

        public void push(Block block) {
            this.mSetsOfStates.add(block);
        }

        public boolean remove(Block block) {
            return this.mSetsOfStates.remove(block);
        }

        public boolean contains(Block block) {
            return this.mSetsOfStates.contains(block);
        }

        public int size() {
            return this.mSetsOfStates.size();
        }

        public boolean isEmpty() {
            return this.mSetsOfStates.isEmpty();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            Iterator<Block> iterator = this.mSetsOfStates.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().toString());
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }
}

