/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSat;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.InteractiveMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.NwaApproximateDelayedSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedConsistencyGeneratorDelayedSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedConsistencyGeneratorDelayedSimulationDoubleton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedTransitivityGeneratorDoubleton;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;

public class MinimizeNwaPmaxSatDelayedBi<LETTER, STATE>
extends MinimizeNwaPmaxSat<LETTER, STATE> {
    protected ScopedConsistencyGeneratorDelayedSimulation<Doubleton<STATE>, LETTER, STATE> mConsistencyGenerator;
    final ISetOfPairs<STATE, ?> mSpoilerWinnings;
    final ISetOfPairs<STATE, ?> mDuplicatorFollowing;
    final ISetOfPairs<STATE, ?> mSimulation;
    final BiPredicate<STATE, STATE> nothingMergedYet = (object, object2) -> false;

    public MinimizeNwaPmaxSatDelayedBi(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, new MinimizeNwaMaxSat2.Settings().setLibraryMode(false));
    }

    public MinimizeNwaPmaxSatDelayedBi(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, MinimizeNwaMaxSat2.Settings<STATE> settings) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, settings, null);
        this.printStartMessage();
        this.mSettings.setUseInternalCallConstraints(false);
        NwaApproximateDelayedSimulation nwaApproximateDelayedSimulation = new NwaApproximateDelayedSimulation(this.mServices, this.mOperand, this.nothingMergedYet);
        this.mSpoilerWinnings = nwaApproximateDelayedSimulation.getSpoilerWinningStates();
        this.mDuplicatorFollowing = nwaApproximateDelayedSimulation.getDuplicatorEventuallyAcceptingStates();
        this.mSimulation = nwaApproximateDelayedSimulation.computeOrdinarySimulation();
        this.run();
        this.printExitMessage();
    }

    @Override
    public void addStatistics(AutomataOperationStatistics automataOperationStatistics) {
        super.addStatistics(automataOperationStatistics);
    }

    @Override
    protected String createTaskDescription() {
        return null;
    }

    @Override
    protected void generateVariablesAndAcceptingConstraints() throws AutomataOperationCanceledException {
        Set<STATE> set = this.computeDuplicatorComplement(this.mDuplicatorFollowing, this.mSimulation);
        STATE[] STATEArray = this.constructStateArray(set);
        this.generateVariablesHelper(STATEArray);
        this.checkTimeout("generating variables");
    }

    @Override
    protected void generateTransitionAndTransitivityConstraints(boolean bl) throws AutomataOperationCanceledException {
        Set<STATE> set = this.computeDuplicatorComplement(this.mDuplicatorFollowing, this.mSimulation);
        STATE[] STATEArray = this.constructStateArray(set);
        int n = 0;
        while (n < STATEArray.length) {
            this.generateTransitionConstraints(STATEArray, n);
            this.checkTimeout("adding transition constraints");
            ++n;
        }
        if (bl) {
            this.generateTransitivityConstraints(STATEArray);
        }
    }

    @Override
    protected void generateVariablesHelper(STATE[] STATEArray) {
        if (STATEArray.length <= 1) {
            return;
        }
        int n = 0;
        while (n < STATEArray.length) {
            STATE STATE = STATEArray[n];
            if (this.mTransitivityGenerator != null) {
                this.mTransitivityGenerator.addContent(STATE);
            }
            if (this.mConsistencyGenerator != null) {
                this.mConsistencyGenerator.addContent(STATE);
            }
            int n2 = 0;
            while (n2 < n) {
                STATE STATE2 = STATEArray[n2];
                Doubleton doubleton = new Doubleton(STATE, STATE2);
                this.mStatePair2Var.put(STATE, STATE2, (Object)doubleton);
                this.mStatePair2Var.put(STATE2, STATE, (Object)doubleton);
                this.mSolver.addVariable(doubleton);
                if (!this.mSpoilerWinnings.containsPair(STATE, STATE2) || !this.mSpoilerWinnings.containsPair(STATE2, STATE)) {
                    this.setVariableFalse(doubleton);
                }
                ++n2;
            }
            ++n;
        }
    }

    @Override
    protected AbstractMaxSatSolver<Doubleton<STATE>> createTransitivitySolver() {
        this.mTransitivityGenerator = new ScopedTransitivityGeneratorDoubleton(this.mSettings.isUsePathCompression());
        this.mConsistencyGenerator = new ScopedConsistencyGeneratorDelayedSimulationDoubleton<STATE, LETTER, STATE>(this.mSettings.isUsePathCompression(), this.mServices, this.mOperand);
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.mConsistencyGenerator);
        arrayList.add(this.mTransitivityGenerator);
        return new InteractiveMaxSatSolver<Doubleton<STATE>>(this.mServices, arrayList);
    }

    @Override
    protected boolean isInitialPair(STATE STATE, STATE STATE2) {
        return this.mSpoilerWinnings.containsPair(STATE, STATE2) && this.mSpoilerWinnings.containsPair(STATE2, STATE);
    }

    private Set<STATE> computeDuplicatorComplement(ISetOfPairs<STATE, ?> iSetOfPairs, ISetOfPairs<STATE, ?> iSetOfPairs2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Pair pair : iSetOfPairs2) {
            if (iSetOfPairs.containsPair(pair.getFirst(), pair.getSecond())) continue;
            hashSet.add(pair.getFirst());
            hashSet.add(pair.getSecond());
        }
        return hashSet;
    }
}

