/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.HelpIncremental;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.IMinimize;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.Interrupt;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class MinimizeDfaHopcroftParallel<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE>
implements IMinimize {
    public static final boolean HELP_INCREMENTAL = true;
    private static boolean sParallel;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private boolean mResultConstructed;
    private ArrayList<STATE> mInt2state;
    private HashMap<STATE, Integer> mState2int;
    private Set<Block> mWorklist;
    private Map<Integer, Block> mMappings;
    private ArrayList<Block> mBlocks;
    private Interrupt mInterrupt;
    private int[] mState2representative;
    private double mRunTime;
    private LinkedBlockingQueue<Runnable> mTaskQueue;
    private MinimizeDfaIncrementalParallel<LETTER, STATE> mIncrementalAlgorithm;
    private final boolean mInitialized = false;

    public MinimizeDfaHopcroftParallel(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, new Interrupt());
    }

    public MinimizeDfaHopcroftParallel(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Interrupt interrupt) {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.mInterrupt = interrupt;
        this.printStartMessage();
        this.initialize();
        if (!sParallel) {
            this.executeAlgorithm();
        }
        assert (this.mState2int != null && this.mInt2state != null);
        this.printExitMessage();
    }

    public MinimizeDfaHopcroftParallel(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Interrupt interrupt, ArrayList<STATE> arrayList, HashMap<STATE, Integer> hashMap) {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.mInterrupt = interrupt;
        this.mInt2state = arrayList;
        this.mState2int = hashMap;
        this.initialize();
        assert (this.mState2int != null && this.mInt2state != null);
        if (!sParallel) {
            this.executeAlgorithm();
        }
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    private void executeAlgorithm() {
        assert (this.mInterrupt == null || !this.mInterrupt.getStatus()) : "HOP: The interrupt tells to terminate right at the beginning.";
        this.initialize();
        this.minimizeDfaHopcroft();
        if (!this.mResultConstructed) {
            this.constructResult();
        }
        this.mLogger.info((Object)this.exitMessage());
    }

    private void initialize() {
        if (this.mState2int == null && this.mInt2state == null) {
            this.initializeMappings();
        }
        this.createInitialPartition();
    }

    public void minimizeParallel(LinkedBlockingQueue<Runnable> linkedBlockingQueue, MinimizeDfaIncrementalParallel<LETTER, STATE> minimizeDfaIncrementalParallel) {
        this.mTaskQueue = linkedBlockingQueue;
        this.mIncrementalAlgorithm = minimizeDfaIncrementalParallel;
        this.minimizeDfaHopcroft();
    }

    private void createInitialPartition() {
        this.mMappings = Collections.synchronizedMap(new HashMap());
        this.mWorklist = new HashSet<Block>();
        this.mBlocks = new ArrayList();
        Collection<STATE> collection = this.mOperand.getFinalStates();
        Set<STATE> set = this.mOperand.getStates();
        int n = collection.size();
        int n2 = set.size();
        Block block = new Block(new HashSet<Integer>(n));
        Block block2 = new Block(new HashSet<Integer>(n2 - n));
        for (Object e : set) {
            if (collection.contains(e)) {
                this.mMappings.put(this.mState2int.get(e), block);
                block.add(this.mState2int.get(e));
                continue;
            }
            this.mMappings.put(this.mState2int.get(e), block2);
            block2.add(this.mState2int.get(e));
        }
        this.mWorklist.add(block);
        this.mWorklist.add(block2);
        this.mBlocks.add(block);
        this.mBlocks.add(block2);
    }

    private void initializeMappings() {
        int n = this.mOperand.getStates().size();
        this.mInt2state = new ArrayList(n);
        this.mState2int = new HashMap(MinimizeDfaHopcroftParallel.computeHashCap(n));
        int n2 = -1;
        for (STATE STATE : this.mOperand.getStates()) {
            this.mInt2state.add(STATE);
            this.mState2int.put(STATE, ++n2);
        }
    }

    private void minimizeDfaHopcroft() {
        if (sParallel) {
            this.mLogger.info((Object)"HOP: started");
        }
        while (this.mWorklist.iterator().hasNext()) {
            if (this.mInterrupt != null && this.mInterrupt.getStatus()) {
                return;
            }
            Block block = this.mWorklist.iterator().next();
            this.mWorklist.remove(block);
            HashSet<Integer> hashSet = block.getStates();
            for (Object LETTER : this.mOperand.getVpAlphabet().getInternalAlphabet()) {
                Object object;
                HashSet<Integer> hashSet2 = new HashSet<Integer>();
                for (int n : hashSet) {
                    for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : this.mOperand.internalPredecessors(this.mInt2state.get(n), LETTER)) {
                        hashSet2.add(this.mState2int.get(incomingInternalTransition.getPred()));
                    }
                }
                if (hashSet2.isEmpty()) continue;
                HashSet<Object> hashSet3 = new HashSet<Object>();
                for (Integer n : hashSet2) {
                    object = this.mMappings.get(n);
                    if (object == null) continue;
                    hashSet3.add(object);
                    ((Block)object).mark(n);
                }
                for (Block block2 : hashSet3) {
                    if (block2.doSplit()) {
                        object = block2.split();
                        if (((Block)object).getStates().size() == 1) {
                            int n = ((Block)object).getStates().iterator().next();
                            this.mMappings.remove(n);
                            if (block2.getStates().size() == 1) {
                                int n2 = block2.getStates().iterator().next();
                                this.mMappings.remove(n2);
                            }
                        } else {
                            for (int n : ((Block)object).getStates()) {
                                this.mMappings.put(n, (Block)object);
                            }
                        }
                        if (sParallel) {
                            assert (this.mIncrementalAlgorithm != null);
                            try {
                                this.mTaskQueue.put(new HelpIncremental(this.mIncrementalAlgorithm, new HashSet<Integer>(block2.getStates()), new HashSet<Integer>(((Block)object).getStates())));
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        this.mWorklist.add((Block)object);
                        this.mBlocks.add((Block)object);
                        continue;
                    }
                    block2.reset();
                }
            }
        }
    }

    private void constructResult() {
        assert (!this.mResultConstructed);
        HashMap<Integer, Collection<STATE>> hashMap = this.computeMapState2Equiv();
        HashMap hashMap2 = new HashMap(MinimizeDfaHopcroftParallel.computeHashCap(hashMap.size()));
        assert (this.mOperand.getInitialStates().iterator().hasNext()) : "There is no initial state in the automaton.";
        int n = this.mState2representative[this.mState2int.get(this.mOperand.getInitialStates().iterator().next())];
        this.startResultConstruction();
        for (Map.Entry<Integer, Collection<STATE>> object : hashMap.entrySet()) {
            boolean bl;
            int n2 = object.getKey();
            Collection<STATE> collection = object.getValue();
            boolean bl2 = bl = n2 == n;
            assert (collection.iterator().hasNext()) : "There is no equivalent state in the collection.";
            boolean bl3 = this.mOperand.isFinal(collection.iterator().next());
            Object STATE = this.addState(bl, bl3, collection);
            hashMap2.put(n2, STATE);
        }
        for (Integer n3 : hashMap.keySet()) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(this.mInt2state.get(n3))) {
                this.addInternalTransition(hashMap2.get(n3), outgoingInternalTransition.getLetter(), hashMap2.get(this.mState2representative[this.mState2int.get(outgoingInternalTransition.getSucc())]));
            }
        }
        this.finishResultConstruction(null, false);
        this.mResultConstructed = true;
    }

    private HashMap<Integer, ? extends Collection<STATE>> computeMapState2Equiv() {
        LinkedList<STATE> linkedList;
        int n;
        this.mState2representative = new int[this.mOperand.size()];
        HashMap hashMap = new HashMap(MinimizeDfaHopcroftParallel.computeHashCap(this.mOperand.size()));
        HashSet<Block> hashSet = new HashSet<Block>(this.mMappings.values());
        for (Block block : hashSet) {
            if (block.getStates().isEmpty()) continue;
            n = block.getStates().iterator().next();
            linkedList = new LinkedList<STATE>();
            for (int n2 : block.getStates()) {
                linkedList.add(this.mInt2state.get(n2));
                this.mState2representative[n2] = n;
            }
            hashMap.put(n, linkedList);
        }
        for (Block block : this.mBlocks) {
            n = block.getStates().iterator().next();
            linkedList = new LinkedList();
            for (int n2 : block.getStates()) {
                linkedList.add(this.mInt2state.get(n2));
                this.mState2representative[n2] = n;
            }
            hashMap.put(n, linkedList);
        }
        return hashMap;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        if (sParallel && !this.mResultConstructed) {
            this.constructResult();
        }
        return super.getResult();
    }

    public double getRunTime() {
        return this.mRunTime;
    }

    public static void setParallelFlag(boolean bl) {
        sParallel = bl;
    }

    public boolean getMappings() {
        return false;
    }

    public ArrayList<STATE> getInt2State() {
        return this.mInt2state;
    }

    public HashMap<STATE, Integer> getState2Int() {
        return this.mState2int;
    }

    public void removePartition(int n) {
        this.mMappings.remove(n);
    }

    public HashSet<Integer> getBlock(int n) {
        return this.mMappings.get(n).getAll();
    }

    private static class Block {
        private static int sId;
        private final int mId;
        private HashSet<Integer> mMarked;
        private HashSet<Integer> mUnmarked;

        public Block(HashSet<Integer> hashSet) {
            assert (hashSet != null);
            this.mUnmarked = hashSet;
            this.mMarked = new HashSet();
            this.mId = sId++;
        }

        public void mark(Integer n) {
            this.mMarked.add(n);
            this.mUnmarked.remove(n);
        }

        public void add(Integer n) {
            this.mUnmarked.add(n);
        }

        public HashSet<Integer> getStates() {
            return this.mUnmarked;
        }

        public HashSet<Integer> getAll() {
            HashSet<Integer> hashSet = new HashSet<Integer>(this.mUnmarked);
            hashSet.addAll(this.mMarked);
            return hashSet;
        }

        public boolean doSplit() {
            return !this.mUnmarked.isEmpty();
        }

        public Block split() {
            if (this.mMarked.size() <= this.mUnmarked.size()) {
                Block block = new Block(this.mMarked);
                this.mMarked = new HashSet();
                return block;
            }
            Block block = new Block(this.mUnmarked);
            this.mUnmarked = this.mMarked;
            this.mMarked = new HashSet();
            return block;
        }

        public void reset() {
            assert (this.mUnmarked.isEmpty());
            this.mUnmarked = this.mMarked;
            this.mMarked = new HashSet();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            assert (this.getClass() == object.getClass());
            return this.mId == ((Block)object).mId;
        }

        public int hashCode() {
            return this.mId;
        }
    }
}

