/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa.Senwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SenwaWalker<LETTER, STATE> {
    protected Senwa<LETTER, STATE> mTraversedSenwa;
    protected boolean mRemoveDeadEnds;
    protected boolean mRemoveNonLiveStates;
    protected Set<DoubleDecker<STATE>> mDoubleDeckersThatCanReachFinal;
    protected Map<STATE, STATE> mCallSuccOfRemovedDown;
    protected DoubleDecker<STATE> mAauxiliaryEmptyStackDoubleDecker;
    protected ISuccessorVisitor<LETTER, STATE> mSuccVisit;
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final List<STATE> mWorklist = new LinkedList<STATE>();
    private final Set<STATE> mMarked = new HashSet<STATE>();
    private final Map<STATE, Set<STATE>> mRemovedDoubleDeckers = new HashMap<STATE, Set<STATE>>();
    private long mDeadEndRemovalTime;

    public SenwaWalker(AutomataLibraryServices automataLibraryServices, Senwa<LETTER, STATE> senwa, ISuccessorVisitor<LETTER, STATE> iSuccessorVisitor, boolean bl) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mTraversedSenwa = senwa;
        this.mSuccVisit = iSuccessorVisitor;
        this.mRemoveDeadEnds = bl;
        this.traverseDoubleDeckerGraph();
    }

    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mTraversedSenwa;
    }

    private final boolean wasMarked(STATE STATE) {
        return this.mMarked.contains(STATE);
    }

    private final void mark(STATE STATE) {
        this.mMarked.add(STATE);
    }

    private final void enqueueAndMark(STATE STATE) {
        assert (this.mTraversedSenwa.getStates().contains(STATE));
        if (!this.wasMarked(STATE)) {
            this.mark(STATE);
            this.mWorklist.add(STATE);
        }
    }

    protected final void traverseDoubleDeckerGraph() throws AutomataOperationCanceledException {
        Iterable<STATE> iterable = this.mSuccVisit.getInitialStates();
        for (STATE STATE : iterable) {
            this.enqueueAndMark(STATE);
        }
        while (!this.mWorklist.isEmpty()) {
            STATE STATE;
            STATE = this.mWorklist.remove(0);
            assert (this.mTraversedSenwa.getStates().contains(STATE));
            this.processNextWorkListState(STATE);
        }
        this.mLogger.info((Object)("Result " + this.mTraversedSenwa.sizeInformation()));
        if (this.mRemoveDeadEnds && this.mRemoveNonLiveStates) {
            throw new IllegalArgumentException("RemoveDeadEnds and RemoveNonLiveStates is set");
        }
        if (this.mRemoveDeadEnds) {
            this.removeStatesThatCanNotReachFinal(false);
            if (this.mTraversedSenwa.getInitialStates().isEmpty()) {
                assert (this.mTraversedSenwa.getStates().isEmpty());
                this.mTraversedSenwa = this.getTotalizedEmptyAutomaton();
            }
            this.mLogger.info((Object)("After removal of dead ends " + this.mTraversedSenwa.sizeInformation()));
        }
        if (this.mRemoveNonLiveStates) {
            this.removeNonLiveStates();
            if (this.mTraversedSenwa.getInitialStates().isEmpty()) assert (this.mTraversedSenwa.getStates().isEmpty());
            this.mLogger.info((Object)("After removal of nonLiveStates " + this.mTraversedSenwa.sizeInformation()));
        }
    }

    private void processNextWorkListState(STATE STATE) throws AutomataOperationCanceledException {
        Iterable<Iterator<Object>> iterable;
        Iterator<Object> iterator;
        Object object22;
        Iterable<STATE> iterable2 = this.mSuccVisit.visitAndGetInternalSuccessors(STATE);
        for (Object object22 : iterable2) {
            this.enqueueAndMark(object22);
        }
        object22 = this.mSuccVisit.visitAndGetCallSuccessors(STATE);
        Iterator object32 = object22.iterator();
        while (object32.hasNext()) {
            iterator = object32.next();
            this.enqueueAndMark(iterator);
            assert (iterator == this.mTraversedSenwa.getEntry(iterator) || this.mTraversedSenwa.getEntry(iterator) == null);
            ArrayList<Iterator<STATE>> arrayList = new ArrayList<Iterator<STATE>>(this.mTraversedSenwa.getModuleStates(iterator));
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                iterable = object.next();
                Iterable<Iterable<Iterator<STATE>>> iterable3 = this.mSuccVisit.visitAndGetReturnSuccessors(iterable, (Iterable<Iterator<STATE>>)STATE);
                Iterator iterator2 = iterable3.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    this.enqueueAndMark(t);
                }
            }
            assert (this.mTraversedSenwa.getCallPredecessors(iterator).contains(STATE));
        }
        iterator = this.mTraversedSenwa.getEntry(STATE);
        for (IncomingCallTransition incomingCallTransition : this.mTraversedSenwa.callPredecessors(iterator)) {
            iterable = this.mSuccVisit.visitAndGetReturnSuccessors((Iterator<STATE>)STATE, incomingCallTransition.getPred());
            for (Object object : iterable) {
                this.enqueueAndMark(object);
            }
        }
        if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
            throw new AutomataOperationCanceledException(this.getClass());
        }
    }

    protected Senwa<LETTER, STATE> getTotalizedEmptyAutomaton() {
        Senwa senwa = new Senwa(this.mServices, this.mTraversedSenwa.getVpAlphabet(), (IEmptyStackStateFactory)this.mTraversedSenwa.getStateFactory());
        Object STATE = ((ISinkStateFactory)senwa.getStateFactory()).createSinkStateContent();
        senwa.addState(STATE, true, false, STATE);
        for (Object STATE2 : senwa.getStates()) {
            this.getTotalizedEmptyAutomatonHelper(senwa, STATE, STATE2);
        }
        return senwa;
    }

    private void getTotalizedEmptyAutomatonHelper(Senwa<LETTER, STATE> senwa, STATE STATE, STATE STATE2) {
        for (Object LETTER : senwa.getVpAlphabet().getInternalAlphabet()) {
            if (senwa.internalSuccessors(STATE2, LETTER).iterator().hasNext()) continue;
            senwa.addInternalTransition(STATE2, LETTER, STATE);
        }
        for (Object LETTER : senwa.getVpAlphabet().getCallAlphabet()) {
            if (senwa.callSuccessors(STATE2, LETTER).iterator().hasNext()) continue;
            senwa.addCallTransition(STATE2, LETTER, STATE);
        }
        for (Object LETTER : senwa.getVpAlphabet().getReturnAlphabet()) {
            for (Object STATE3 : senwa.getStates()) {
                if (senwa.returnSuccessors(STATE2, STATE3, LETTER).iterator().hasNext()) continue;
                senwa.addReturnTransition(STATE2, STATE3, LETTER, STATE);
            }
        }
    }

    private final Set<STATE> computeStatesThatCanNotReachFinal() {
        HashSet hashSet = new HashSet(this.mTraversedSenwa.getStates());
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object e : this.mTraversedSenwa.getFinalStates()) {
            hashSet.remove(e);
        }
        linkedList.addAll(this.mTraversedSenwa.getFinalStates());
        while (!linkedList.isEmpty()) {
            boolean bl;
            Object e;
            e = linkedList.removeFirst();
            hashSet.remove(e);
            for (IncomingInternalTransition incomingInternalTransition : this.mTraversedSenwa.internalPredecessors(e)) {
                bl = hashSet.remove(incomingInternalTransition.getPred());
                if (!bl) continue;
                linkedList.add(incomingInternalTransition.getPred());
            }
            for (IncomingCallTransition incomingCallTransition : this.mTraversedSenwa.callPredecessors(e)) {
                bl = hashSet.remove(incomingCallTransition.getPred());
                if (!bl) continue;
                linkedList.add(incomingCallTransition.getPred());
            }
            for (IncomingReturnTransition incomingReturnTransition : this.mTraversedSenwa.returnPredecessors(e)) {
                Object STATE = incomingReturnTransition.getLinPred();
                boolean bl2 = hashSet.remove(STATE);
                if (!bl2) continue;
                linkedList.add(STATE);
            }
        }
        return hashSet;
    }

    public final boolean removeStatesThatCanNotReachFinal(boolean bl) {
        long l = System.currentTimeMillis();
        Set<STATE> set = this.computeStatesThatCanNotReachFinal();
        if (bl) {
            this.announceRemovalOfDoubleDeckers(set);
        }
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (Object object : set) {
            if (this.mTraversedSenwa.isEntry(object)) {
                arrayList.add(object);
                continue;
            }
            this.mTraversedSenwa.removeState(object);
        }
        for (Object object : arrayList) {
            this.mTraversedSenwa.removeState(object);
        }
        boolean bl2 = !set.isEmpty();
        this.mDeadEndRemovalTime += System.currentTimeMillis() - l;
        return bl2;
    }

    private void announceRemovalOfDoubleDeckers(Set<STATE> set) {
        this.mCallSuccOfRemovedDown = new HashMap<STATE, STATE>();
        for (STATE STATE : set) {
            STATE STATE2 = this.mTraversedSenwa.getEntry(STATE);
            for (STATE STATE3 : this.mTraversedSenwa.getCallPredecessors(STATE2)) {
                Set<STATE> set2 = this.mRemovedDoubleDeckers.get(STATE);
                if (set2 == null) {
                    set2 = new HashSet<STATE>();
                    this.mRemovedDoubleDeckers.put(STATE, set2);
                }
                set2.add(STATE3);
                Set<STATE> set3 = this.computeState2CallSuccs(STATE3);
                if (set3.size() > 1) {
                    throw new UnsupportedOperationException("If state has several outgoing call transitions Hoare annotation might be incorrect.");
                }
                if (set3.size() == 1) {
                    STATE STATE4 = set3.iterator().next();
                    this.mCallSuccOfRemovedDown.put(STATE3, STATE4);
                    continue;
                }
                assert (set3.isEmpty());
            }
        }
    }

    private Set<STATE> computeState2CallSuccs(STATE STATE) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        if (STATE != this.mTraversedSenwa.getEmptyStackState()) {
            for (OutgoingCallTransition outgoingCallTransition : this.mTraversedSenwa.callSuccessors(STATE)) {
                hashSet.add(outgoingCallTransition.getSucc());
            }
        }
        return hashSet;
    }

    private boolean hasSuccessors(STATE STATE) {
        if (this.mTraversedSenwa.internalSuccessors(STATE).iterator().hasNext()) {
            return true;
        }
        if (this.mTraversedSenwa.callSuccessors(STATE).iterator().hasNext()) {
            return true;
        }
        return this.mTraversedSenwa.returnSuccessors(STATE).iterator().hasNext();
    }

    private final boolean removeAcceptingStatesWithoutSuccessors() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.mTraversedSenwa.getFinalStates()) {
            if (this.hasSuccessors(e)) continue;
            arrayList.add(e);
        }
        boolean bl = !arrayList.isEmpty();
        for (Iterator iterator : arrayList) {
            this.mTraversedSenwa.removeState(iterator);
        }
        return bl;
    }

    private final void removeNonLiveStates() {
        do {
            boolean bl = this.removeStatesThatCanNotReachFinal(false);
        } while (bl |= this.removeAcceptingStatesWithoutSuccessors());
    }

    public Map<STATE, STATE> getCallSuccOfRemovedDown() {
        if (this.mCallSuccOfRemovedDown == null || this.mRemovedDoubleDeckers == null) {
            throw new AssertionError((Object)"Request computation when removing");
        }
        return this.mCallSuccOfRemovedDown;
    }

    public Map<STATE, Set<STATE>> getRemovedDoubleDeckers() {
        if (this.mCallSuccOfRemovedDown == null || this.mRemovedDoubleDeckers == null) {
            throw new AssertionError((Object)"Request computation when removing");
        }
        return this.mRemovedDoubleDeckers;
    }

    public long getDeadEndRemovalTime() {
        return this.mDeadEndRemovalTime;
    }

    public static interface ISuccessorVisitor<LETTER, STATE> {
        public Iterable<STATE> getInitialStates();

        public Iterable<STATE> visitAndGetInternalSuccessors(STATE var1);

        public Iterable<STATE> visitAndGetCallSuccessors(STATE var1);

        public Iterable<STATE> visitAndGetReturnSuccessors(STATE var1, STATE var2);
    }
}

